/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import com.ibm.security.x509.X509CRLEntryImpl;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.CRLReason;
import java.security.cert.X509Extension;
import java.util.Date;
import javax.security.auth.x500.X500Principal;

public abstract class X509CRLEntry
implements X509Extension {
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof X509CRLEntry)) {
            return false;
        }
        try {
            byte[] byArray = this.getEncoded();
            byte[] byArray2 = ((X509CRLEntry)object).getEncoded();
            if (byArray.length != byArray2.length) {
                return false;
            }
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] == byArray2[i]) continue;
                return false;
            }
        }
        catch (CRLException cRLException) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        try {
            byte[] byArray = this.getEncoded();
            for (int i = 1; i < byArray.length; ++i) {
                n += byArray[i] * i;
            }
        }
        catch (CRLException cRLException) {
            return n;
        }
        return n;
    }

    public abstract byte[] getEncoded() throws CRLException;

    public abstract BigInteger getSerialNumber();

    public X500Principal getCertificateIssuer() {
        return null;
    }

    public abstract Date getRevocationDate();

    public abstract boolean hasExtensions();

    public abstract String toString();

    public CRLReason getRevocationReason() {
        if (!this.hasExtensions()) {
            return null;
        }
        return X509CRLEntryImpl.getRevocationReason((X509CRLEntry)this);
    }
}

