/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.DirectFloatBufferRS;
import java.nio.FloatBuffer;
import sun.misc.Cleaner;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

class DirectFloatBufferS
extends FloatBuffer
implements DirectBuffer {
    protected static final Unsafe unsafe = Bits.unsafe();
    private static final long arrayBaseOffset = unsafe.arrayBaseOffset(float[].class);
    protected static final boolean unaligned = Bits.unaligned();
    private final Object att;

    @Override
    public Object attachment() {
        return this.att;
    }

    @Override
    public Cleaner cleaner() {
        return null;
    }

    DirectFloatBufferS(DirectBuffer directBuffer, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4);
        this.address = directBuffer.address() + (long)n5;
        this.att = directBuffer;
    }

    @Override
    public FloatBuffer slice() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n << 2;
        assert (n4 >= 0);
        return new DirectFloatBufferS(this, -1, 0, n3, n3, n4);
    }

    @Override
    public FloatBuffer duplicate() {
        return new DirectFloatBufferS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    @Override
    public FloatBuffer asReadOnlyBuffer() {
        return new DirectFloatBufferRS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    @Override
    public long address() {
        return this.address;
    }

    private long ix(int n) {
        return this.address + (long)(n << 2);
    }

    @Override
    public float get() {
        return Float.intBitsToFloat(Bits.swap(unsafe.getInt(this.ix(this.nextGetIndex()))));
    }

    @Override
    public float get(int n) {
        return Float.intBitsToFloat(Bits.swap(unsafe.getInt(this.ix(this.checkIndex(n)))));
    }

    @Override
    public FloatBuffer get(float[] fArray, int n, int n2) {
        if (n2 << 2 > 6) {
            int n3;
            DirectFloatBufferS.checkBounds(n, n2, fArray.length);
            int n4 = this.position();
            int n5 = this.limit();
            assert (n4 <= n5);
            int n6 = n3 = n4 <= n5 ? n5 - n4 : 0;
            if (n2 > n3) {
                throw new BufferUnderflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyToIntArray(this.ix(n4), fArray, n << 2, n2 << 2);
            } else {
                Bits.copyToArray(this.ix(n4), fArray, arrayBaseOffset, n << 2, n2 << 2);
            }
            this.position(n4 + n2);
        } else {
            super.get(fArray, n, n2);
        }
        return this;
    }

    @Override
    public FloatBuffer put(float f) {
        unsafe.putInt(this.ix(this.nextPutIndex()), Bits.swap(Float.floatToRawIntBits(f)));
        Bits.keepAlive(this);
        return this;
    }

    @Override
    public FloatBuffer put(int n, float f) {
        unsafe.putInt(this.ix(this.checkIndex(n)), Bits.swap(Float.floatToRawIntBits(f)));
        Bits.keepAlive(this);
        return this;
    }

    @Override
    public FloatBuffer put(FloatBuffer floatBuffer) {
        if (floatBuffer instanceof DirectFloatBufferS) {
            int n;
            if (floatBuffer == this) {
                throw new IllegalArgumentException();
            }
            DirectFloatBufferS directFloatBufferS = (DirectFloatBufferS)floatBuffer;
            int n2 = directFloatBufferS.position();
            int n3 = directFloatBufferS.limit();
            assert (n2 <= n3);
            int n4 = n2 <= n3 ? n3 - n2 : 0;
            int n5 = this.position();
            int n6 = this.limit();
            assert (n5 <= n6);
            int n7 = n = n5 <= n6 ? n6 - n5 : 0;
            if (n4 > n) {
                throw new BufferOverflowException();
            }
            unsafe.copyMemory(directFloatBufferS.ix(n2), this.ix(n5), n4 << 2);
            Bits.keepAlive(this);
            directFloatBufferS.position(n2 + n4);
            this.position(n5 + n4);
        } else if (floatBuffer.hb != null) {
            int n = floatBuffer.position();
            int n8 = floatBuffer.limit();
            assert (n <= n8);
            int n9 = n <= n8 ? n8 - n : 0;
            this.put(floatBuffer.hb, floatBuffer.offset + n, n9);
            floatBuffer.position(n + n9);
        } else {
            super.put(floatBuffer);
        }
        return this;
    }

    @Override
    public FloatBuffer put(float[] fArray, int n, int n2) {
        if (n2 << 2 > 6) {
            int n3;
            DirectFloatBufferS.checkBounds(n, n2, fArray.length);
            int n4 = this.position();
            int n5 = this.limit();
            assert (n4 <= n5);
            int n6 = n3 = n4 <= n5 ? n5 - n4 : 0;
            if (n2 > n3) {
                throw new BufferOverflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyFromIntArray(fArray, n << 2, this.ix(n4), n2 << 2);
            } else {
                Bits.copyFromArray(fArray, arrayBaseOffset, n << 2, this.ix(n4), n2 << 2);
            }
            this.position(n4 + n2);
        } else {
            super.put(fArray, n, n2);
        }
        return this;
    }

    @Override
    public FloatBuffer compact() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        unsafe.copyMemory(this.ix(n), this.ix(0), n3 << 2);
        Bits.keepAlive(this);
        this.position(n3);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }
}

