/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.io.FileDescriptor;
import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteBufferAsCharBufferB;
import java.nio.ByteBufferAsCharBufferL;
import java.nio.ByteBufferAsDoubleBufferB;
import java.nio.ByteBufferAsDoubleBufferL;
import java.nio.ByteBufferAsFloatBufferB;
import java.nio.ByteBufferAsFloatBufferL;
import java.nio.ByteBufferAsIntBufferB;
import java.nio.ByteBufferAsIntBufferL;
import java.nio.ByteBufferAsLongBufferB;
import java.nio.ByteBufferAsLongBufferL;
import java.nio.ByteBufferAsShortBufferB;
import java.nio.ByteBufferAsShortBufferL;
import java.nio.CharBuffer;
import java.nio.DirectByteBufferR;
import java.nio.DirectCharBufferS;
import java.nio.DirectCharBufferU;
import java.nio.DirectDoubleBufferS;
import java.nio.DirectDoubleBufferU;
import java.nio.DirectFloatBufferS;
import java.nio.DirectFloatBufferU;
import java.nio.DirectIntBufferS;
import java.nio.DirectIntBufferU;
import java.nio.DirectLongBufferS;
import java.nio.DirectLongBufferU;
import java.nio.DirectShortBufferS;
import java.nio.DirectShortBufferU;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.MappedByteBuffer;
import java.nio.ShortBuffer;
import sun.misc.Cleaner;
import sun.misc.Unsafe;
import sun.misc.VM;
import sun.nio.ch.DirectBuffer;

class DirectByteBuffer
extends MappedByteBuffer
implements DirectBuffer {
    protected static final Unsafe unsafe = Bits.unsafe();
    private static final long arrayBaseOffset = unsafe.arrayBaseOffset(byte[].class);
    protected static final boolean unaligned = Bits.unaligned();
    private final Object att;
    private final Cleaner cleaner;

    @Override
    public Object attachment() {
        return this.att;
    }

    @Override
    public Cleaner cleaner() {
        return this.cleaner;
    }

    DirectByteBuffer(int n) {
        super(-1, 0, n, n);
        boolean bl = VM.isDirectMemoryPageAligned();
        int n2 = Bits.pageSize();
        long l = Math.max(1L, (long)n + (long)(bl ? n2 : 0));
        Bits.reserveMemory(l, n);
        long l2 = 0L;
        try {
            l2 = unsafe.allocateDBBMemory(l);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Bits.unreserveMemory(l, n);
            throw outOfMemoryError;
        }
        unsafe.setMemory(l2, l, (byte)0);
        this.address = bl && l2 % (long)n2 != 0L ? l2 + (long)n2 - (l2 & (long)(n2 - 1)) : l2;
        this.cleaner = Cleaner.create(this, new Deallocator(l2, l, n));
        this.att = null;
    }

    DirectByteBuffer(long l, int n, Object object) {
        super(-1, 0, n, n);
        this.address = l;
        this.cleaner = null;
        this.att = object;
    }

    private DirectByteBuffer(long l, int n) {
        super(-1, 0, n, n);
        this.address = l;
        this.cleaner = null;
        this.att = null;
    }

    protected DirectByteBuffer(int n, long l, FileDescriptor fileDescriptor, Runnable runnable) {
        super(-1, 0, n, n, fileDescriptor);
        this.address = l;
        this.cleaner = Cleaner.create(this, runnable);
        this.att = null;
    }

    DirectByteBuffer(DirectBuffer directBuffer, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4);
        this.address = directBuffer.address() + (long)n5;
        this.cleaner = null;
        this.att = directBuffer;
    }

    @Override
    public ByteBuffer slice() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n << 0;
        assert (n4 >= 0);
        return new DirectByteBuffer(this, -1, 0, n3, n3, n4);
    }

    @Override
    public ByteBuffer duplicate() {
        return new DirectByteBuffer(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    @Override
    public ByteBuffer asReadOnlyBuffer() {
        return new DirectByteBufferR(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    @Override
    public long address() {
        return this.address;
    }

    private long ix(int n) {
        return this.address + (long)(n << 0);
    }

    @Override
    public byte get() {
        return unsafe.getByte(this.ix(this.nextGetIndex()));
    }

    @Override
    public byte get(int n) {
        return unsafe.getByte(this.ix(this.checkIndex(n)));
    }

    @Override
    public ByteBuffer get(byte[] byArray, int n, int n2) {
        if (n2 << 0 > 6) {
            int n3;
            DirectByteBuffer.checkBounds(n, n2, byArray.length);
            int n4 = this.position();
            int n5 = this.limit();
            assert (n4 <= n5);
            int n6 = n3 = n4 <= n5 ? n5 - n4 : 0;
            if (n2 > n3) {
                throw new BufferUnderflowException();
            }
            Bits.copyToArray(this.ix(n4), byArray, arrayBaseOffset, n << 0, n2 << 0);
            this.position(n4 + n2);
        } else {
            super.get(byArray, n, n2);
        }
        return this;
    }

    @Override
    public ByteBuffer put(byte by) {
        unsafe.putByte(this.ix(this.nextPutIndex()), by);
        Bits.keepAlive(this);
        return this;
    }

    @Override
    public ByteBuffer put(int n, byte by) {
        unsafe.putByte(this.ix(this.checkIndex(n)), by);
        Bits.keepAlive(this);
        return this;
    }

    @Override
    public ByteBuffer put(ByteBuffer byteBuffer) {
        if (byteBuffer instanceof DirectByteBuffer) {
            int n;
            if (byteBuffer == this) {
                throw new IllegalArgumentException();
            }
            DirectByteBuffer directByteBuffer = (DirectByteBuffer)byteBuffer;
            int n2 = directByteBuffer.position();
            int n3 = directByteBuffer.limit();
            assert (n2 <= n3);
            int n4 = n2 <= n3 ? n3 - n2 : 0;
            int n5 = this.position();
            int n6 = this.limit();
            assert (n5 <= n6);
            int n7 = n = n5 <= n6 ? n6 - n5 : 0;
            if (n4 > n) {
                throw new BufferOverflowException();
            }
            unsafe.copyMemory(directByteBuffer.ix(n2), this.ix(n5), n4 << 0);
            Bits.keepAlive(this);
            directByteBuffer.position(n2 + n4);
            this.position(n5 + n4);
        } else if (byteBuffer.hb != null) {
            int n = byteBuffer.position();
            int n8 = byteBuffer.limit();
            assert (n <= n8);
            int n9 = n <= n8 ? n8 - n : 0;
            this.put(byteBuffer.hb, byteBuffer.offset + n, n9);
            byteBuffer.position(n + n9);
        } else {
            super.put(byteBuffer);
        }
        return this;
    }

    @Override
    public ByteBuffer put(byte[] byArray, int n, int n2) {
        if (n2 << 0 > 6) {
            int n3;
            DirectByteBuffer.checkBounds(n, n2, byArray.length);
            int n4 = this.position();
            int n5 = this.limit();
            assert (n4 <= n5);
            int n6 = n3 = n4 <= n5 ? n5 - n4 : 0;
            if (n2 > n3) {
                throw new BufferOverflowException();
            }
            Bits.copyFromArray(byArray, arrayBaseOffset, n << 0, this.ix(n4), n2 << 0);
            this.position(n4 + n2);
        } else {
            super.put(byArray, n, n2);
        }
        return this;
    }

    @Override
    public ByteBuffer compact() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        unsafe.copyMemory(this.ix(n), this.ix(0), n3 << 0);
        Bits.keepAlive(this);
        this.position(n3);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    byte _get(int n) {
        return unsafe.getByte(this.address + (long)n);
    }

    @Override
    void _put(int n, byte by) {
        unsafe.putByte(this.address + (long)n, by);
        Bits.keepAlive(this);
    }

    private char getChar(long l) {
        if (unaligned) {
            char c = unsafe.getChar(l);
            char c2 = this.nativeByteOrder ? c : Bits.swap(c);
            Bits.keepAlive(this);
            return c2;
        }
        char c = Bits.getChar(l, this.bigEndian);
        Bits.keepAlive(this);
        return c;
    }

    @Override
    public char getChar() {
        char c = this.getChar(this.ix(this.nextGetIndex(2)));
        Bits.keepAlive(this);
        return c;
    }

    @Override
    public char getChar(int n) {
        char c = this.getChar(this.ix(this.checkIndex(n, 2)));
        Bits.keepAlive(this);
        return c;
    }

    private ByteBuffer putChar(long l, char c) {
        if (unaligned) {
            char c2 = c;
            unsafe.putChar(l, this.nativeByteOrder ? c2 : Bits.swap(c2));
            Bits.keepAlive(this);
        } else {
            Bits.putChar(l, c, this.bigEndian);
            Bits.keepAlive(this);
        }
        return this;
    }

    @Override
    public ByteBuffer putChar(char c) {
        this.putChar(this.ix(this.nextPutIndex(2)), c);
        return this;
    }

    @Override
    public ByteBuffer putChar(int n, char c) {
        this.putChar(this.ix(this.checkIndex(n, 2)), c);
        return this;
    }

    @Override
    public CharBuffer asCharBuffer() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n3 >> 1;
        if (!unaligned && (this.address + (long)n) % 2L != 0L) {
            return this.bigEndian ? new ByteBufferAsCharBufferB(this, -1, 0, n4, n4, n) : new ByteBufferAsCharBufferL(this, -1, 0, n4, n4, n);
        }
        return this.nativeByteOrder ? new DirectCharBufferU(this, -1, 0, n4, n4, n) : new DirectCharBufferS(this, -1, 0, n4, n4, n);
    }

    private short getShort(long l) {
        if (unaligned) {
            short s = unsafe.getShort(l);
            short s2 = this.nativeByteOrder ? s : Bits.swap(s);
            Bits.keepAlive(this);
            return s2;
        }
        short s = Bits.getShort(l, this.bigEndian);
        Bits.keepAlive(this);
        return s;
    }

    @Override
    public short getShort() {
        short s = this.getShort(this.ix(this.nextGetIndex(2)));
        Bits.keepAlive(this);
        return s;
    }

    @Override
    public short getShort(int n) {
        short s = this.getShort(this.ix(this.checkIndex(n, 2)));
        Bits.keepAlive(this);
        return s;
    }

    private ByteBuffer putShort(long l, short s) {
        if (unaligned) {
            short s2 = s;
            unsafe.putShort(l, this.nativeByteOrder ? s2 : Bits.swap(s2));
            Bits.keepAlive(this);
        } else {
            Bits.putShort(l, s, this.bigEndian);
            Bits.keepAlive(this);
        }
        return this;
    }

    @Override
    public ByteBuffer putShort(short s) {
        this.putShort(this.ix(this.nextPutIndex(2)), s);
        return this;
    }

    @Override
    public ByteBuffer putShort(int n, short s) {
        this.putShort(this.ix(this.checkIndex(n, 2)), s);
        return this;
    }

    @Override
    public ShortBuffer asShortBuffer() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n3 >> 1;
        if (!unaligned && (this.address + (long)n) % 2L != 0L) {
            return this.bigEndian ? new ByteBufferAsShortBufferB(this, -1, 0, n4, n4, n) : new ByteBufferAsShortBufferL(this, -1, 0, n4, n4, n);
        }
        return this.nativeByteOrder ? new DirectShortBufferU(this, -1, 0, n4, n4, n) : new DirectShortBufferS(this, -1, 0, n4, n4, n);
    }

    private int getInt(long l) {
        if (unaligned) {
            int n = unsafe.getInt(l);
            int n2 = this.nativeByteOrder ? n : Bits.swap(n);
            Bits.keepAlive(this);
            return n2;
        }
        int n = Bits.getInt(l, this.bigEndian);
        Bits.keepAlive(this);
        return n;
    }

    @Override
    public int getInt() {
        int n = this.getInt(this.ix(this.nextGetIndex(4)));
        Bits.keepAlive(this);
        return n;
    }

    @Override
    public int getInt(int n) {
        int n2 = this.getInt(this.ix(this.checkIndex(n, 4)));
        Bits.keepAlive(this);
        return n2;
    }

    private ByteBuffer putInt(long l, int n) {
        if (unaligned) {
            int n2 = n;
            unsafe.putInt(l, this.nativeByteOrder ? n2 : Bits.swap(n2));
            Bits.keepAlive(this);
        } else {
            Bits.putInt(l, n, this.bigEndian);
            Bits.keepAlive(this);
        }
        return this;
    }

    @Override
    public ByteBuffer putInt(int n) {
        this.putInt(this.ix(this.nextPutIndex(4)), n);
        return this;
    }

    @Override
    public ByteBuffer putInt(int n, int n2) {
        this.putInt(this.ix(this.checkIndex(n, 4)), n2);
        return this;
    }

    @Override
    public IntBuffer asIntBuffer() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n3 >> 2;
        if (!unaligned && (this.address + (long)n) % 4L != 0L) {
            return this.bigEndian ? new ByteBufferAsIntBufferB(this, -1, 0, n4, n4, n) : new ByteBufferAsIntBufferL(this, -1, 0, n4, n4, n);
        }
        return this.nativeByteOrder ? new DirectIntBufferU(this, -1, 0, n4, n4, n) : new DirectIntBufferS(this, -1, 0, n4, n4, n);
    }

    private long getLong(long l) {
        if (unaligned) {
            long l2 = unsafe.getLong(l);
            long l3 = this.nativeByteOrder ? l2 : Bits.swap(l2);
            Bits.keepAlive(this);
            return l3;
        }
        long l4 = Bits.getLong(l, this.bigEndian);
        Bits.keepAlive(this);
        return l4;
    }

    @Override
    public long getLong() {
        long l = this.getLong(this.ix(this.nextGetIndex(8)));
        Bits.keepAlive(this);
        return l;
    }

    @Override
    public long getLong(int n) {
        long l = this.getLong(this.ix(this.checkIndex(n, 8)));
        Bits.keepAlive(this);
        return l;
    }

    private ByteBuffer putLong(long l, long l2) {
        if (unaligned) {
            long l3 = l2;
            unsafe.putLong(l, this.nativeByteOrder ? l3 : Bits.swap(l3));
            Bits.keepAlive(this);
        } else {
            Bits.putLong(l, l2, this.bigEndian);
            Bits.keepAlive(this);
        }
        return this;
    }

    @Override
    public ByteBuffer putLong(long l) {
        this.putLong(this.ix(this.nextPutIndex(8)), l);
        return this;
    }

    @Override
    public ByteBuffer putLong(int n, long l) {
        this.putLong(this.ix(this.checkIndex(n, 8)), l);
        return this;
    }

    @Override
    public LongBuffer asLongBuffer() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n3 >> 3;
        if (!unaligned && (this.address + (long)n) % 8L != 0L) {
            return this.bigEndian ? new ByteBufferAsLongBufferB(this, -1, 0, n4, n4, n) : new ByteBufferAsLongBufferL(this, -1, 0, n4, n4, n);
        }
        return this.nativeByteOrder ? new DirectLongBufferU(this, -1, 0, n4, n4, n) : new DirectLongBufferS(this, -1, 0, n4, n4, n);
    }

    private float getFloat(long l) {
        if (unaligned) {
            int n = unsafe.getInt(l);
            float f = Float.intBitsToFloat(this.nativeByteOrder ? n : Bits.swap(n));
            Bits.keepAlive(this);
            return f;
        }
        float f = Bits.getFloat(l, this.bigEndian);
        Bits.keepAlive(this);
        return f;
    }

    @Override
    public float getFloat() {
        float f = this.getFloat(this.ix(this.nextGetIndex(4)));
        Bits.keepAlive(this);
        return f;
    }

    @Override
    public float getFloat(int n) {
        float f = this.getFloat(this.ix(this.checkIndex(n, 4)));
        Bits.keepAlive(this);
        return f;
    }

    private ByteBuffer putFloat(long l, float f) {
        if (unaligned) {
            int n = Float.floatToRawIntBits(f);
            unsafe.putInt(l, this.nativeByteOrder ? n : Bits.swap(n));
            Bits.keepAlive(this);
        } else {
            Bits.putFloat(l, f, this.bigEndian);
            Bits.keepAlive(this);
        }
        return this;
    }

    @Override
    public ByteBuffer putFloat(float f) {
        this.putFloat(this.ix(this.nextPutIndex(4)), f);
        return this;
    }

    @Override
    public ByteBuffer putFloat(int n, float f) {
        this.putFloat(this.ix(this.checkIndex(n, 4)), f);
        return this;
    }

    @Override
    public FloatBuffer asFloatBuffer() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n3 >> 2;
        if (!unaligned && (this.address + (long)n) % 4L != 0L) {
            return this.bigEndian ? new ByteBufferAsFloatBufferB(this, -1, 0, n4, n4, n) : new ByteBufferAsFloatBufferL(this, -1, 0, n4, n4, n);
        }
        return this.nativeByteOrder ? new DirectFloatBufferU(this, -1, 0, n4, n4, n) : new DirectFloatBufferS(this, -1, 0, n4, n4, n);
    }

    private double getDouble(long l) {
        if (unaligned) {
            long l2 = unsafe.getLong(l);
            double d = Double.longBitsToDouble(this.nativeByteOrder ? l2 : Bits.swap(l2));
            Bits.keepAlive(this);
            return d;
        }
        double d = Bits.getDouble(l, this.bigEndian);
        Bits.keepAlive(this);
        return d;
    }

    @Override
    public double getDouble() {
        double d = this.getDouble(this.ix(this.nextGetIndex(8)));
        Bits.keepAlive(this);
        return d;
    }

    @Override
    public double getDouble(int n) {
        double d = this.getDouble(this.ix(this.checkIndex(n, 8)));
        Bits.keepAlive(this);
        return d;
    }

    private ByteBuffer putDouble(long l, double d) {
        if (unaligned) {
            long l2 = Double.doubleToRawLongBits(d);
            unsafe.putLong(l, this.nativeByteOrder ? l2 : Bits.swap(l2));
            Bits.keepAlive(this);
        } else {
            Bits.putDouble(l, d, this.bigEndian);
            Bits.keepAlive(this);
        }
        return this;
    }

    @Override
    public ByteBuffer putDouble(double d) {
        this.putDouble(this.ix(this.nextPutIndex(8)), d);
        return this;
    }

    @Override
    public ByteBuffer putDouble(int n, double d) {
        this.putDouble(this.ix(this.checkIndex(n, 8)), d);
        return this;
    }

    @Override
    public DoubleBuffer asDoubleBuffer() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n3 >> 3;
        if (!unaligned && (this.address + (long)n) % 8L != 0L) {
            return this.bigEndian ? new ByteBufferAsDoubleBufferB(this, -1, 0, n4, n4, n) : new ByteBufferAsDoubleBufferL(this, -1, 0, n4, n4, n);
        }
        return this.nativeByteOrder ? new DirectDoubleBufferU(this, -1, 0, n4, n4, n) : new DirectDoubleBufferS(this, -1, 0, n4, n4, n);
    }

    private static class Deallocator
    implements Runnable {
        private static Unsafe unsafe = Unsafe.getUnsafe();
        private long address;
        private long size;
        private int capacity;

        private Deallocator(long l, long l2, int n) {
            assert (l != 0L);
            this.address = l;
            this.size = l2;
            this.capacity = n;
        }

        @Override
        public void run() {
            if (this.address == 0L) {
                return;
            }
            unsafe.freeDBBMemory(this.address);
            this.address = 0L;
            Bits.unreserveMemory(this.size, this.capacity);
        }
    }
}

