/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkProvider;
import java.net.RDMASocketImpl;
import java.net.SocketImpl;
import java.security.AccessController;
import java.util.List;
import java.util.Scanner;
import sun.security.action.GetPropertyAction;
import sun.security.action.LoadLibraryAction;

class RDMANetworkProvider
implements NetworkProvider {
    private static final String name = "RDMA";
    private InetAddress preferredAddress = null;
    private static final boolean zeroCopy;
    private static final int zeroCopyThreshold;
    private static final int DFLT_ZERO_COPY_THRESHOLD = 256;
    private static final int MIN_ZERO_COPY_THRESHOLD = 64;
    private static final int MAX_ZERO_COPY_THRESHOLD = 16384;
    private static final boolean debugInterception;
    private static final String SEND_BUFFER_SIZE = "SendBufferSize";
    private static final String RECEIVE_BUFFER_SIZE = "ReceiveBufferSize";
    private static final String SEND_QUEUE_SIZE = "SendQueueSize";
    private static final String RECEIVE_QUEUE_SIZE = "ReceiveQueueSize";
    private static final String SEND_INLINE_SIZE = "SendInlineSize";
    private static final int sendBufferSize;
    private static final int receiveBufferSize;
    private static final int sendQueueSize;
    private static final int receiveQueueSize;
    private static final int sendInlineSize;

    RDMANetworkProvider() {
    }

    private native void initialize0(boolean var1, int var2, int var3, int var4, int var5, int var6, int var7) throws IOException;

    private native int cleanup0();

    @Override
    public void initialize() throws IOException {
        try {
            this.initialize0(zeroCopy, zeroCopyThreshold, sendBufferSize, receiveBufferSize, sendQueueSize, receiveQueueSize, sendInlineSize);
            if (debugInterception) {
                System.out.println("[JSOR Info] RDMA network provider inialized");
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    @Override
    public void cleanup() {
        this.cleanup0();
    }

    @Override
    public SocketImpl createImpl(SocketImpl socketImpl) {
        RDMASocketImpl rDMASocketImpl = new RDMASocketImpl(socketImpl, zeroCopy, zeroCopyThreshold, debugInterception);
        if (debugInterception) {
            System.out.println("[JSOR Info] Socket switched to RDMA mode");
        }
        return rDMASocketImpl;
    }

    @Override
    public void postAccept(SocketImpl socketImpl, SocketImpl socketImpl2) throws IOException {
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void setPreferredAddress(List<String> list, List<String> list2) {
        InetAddress inetAddress = null;
        try {
            String string = AccessController.doPrivileged(new GetPropertyAction("com.ibm.net.rdma.preferredAddress"));
            if (string != null && (!list.isEmpty() && list.contains(string) || !list2.isEmpty() && list2.contains(string))) {
                inetAddress = InetAddress.getByName(string);
            } else if (!list.isEmpty()) {
                inetAddress = InetAddress.getByName(list.get(0));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.preferredAddress = inetAddress;
    }

    @Override
    public InetAddress getPreferredAddress() {
        return this.preferredAddress;
    }

    static {
        String string = null;
        String string2 = null;
        boolean bl = false;
        int n = 256;
        boolean bl2 = false;
        String string3 = null;
        String string4 = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        AccessController.doPrivileged(new LoadLibraryAction("jsor"));
        string = AccessController.doPrivileged(new GetPropertyAction("com.ibm.net.rdma.zeroCopy"));
        if (string != null) {
            bl = Boolean.parseBoolean(string);
        }
        zeroCopy = bl;
        string2 = AccessController.doPrivileged(new GetPropertyAction("com.ibm.net.rdma.zeroCopyThreshold"));
        if (string2 != null) {
            try {
                n = Integer.parseInt(string2);
                if (n < 64) {
                    System.out.format("[JSOR Warning] Invalid zero copy threshold '%d' - defaulting to %d KB%n", n, 64);
                    n = 64;
                } else if (n > 16384) {
                    System.out.format("[JSOR Warning] Invalid zero copy threshold '%d' - defaulting to %d KB%n", n, 16384);
                    n = 16384;
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("[JSOR Warning] Invalid \"com.ibm.net.rdma.zeroCopyThreshold\" property value (" + numberFormatException.getMessage() + "): defaulting to " + 256 + " KB");
                n = 256;
            }
        }
        zeroCopyThreshold = n;
        string3 = AccessController.doPrivileged(new GetPropertyAction("com.ibm.net.rdma.debug"));
        if (string3 != null) {
            bl2 = Boolean.parseBoolean(string3);
        }
        debugInterception = bl2;
        string4 = AccessController.doPrivileged(new GetPropertyAction("com.ibm.net.rdma.socketOptions"));
        if (string4 != null) {
            Scanner scanner = null;
            try {
                scanner = new Scanner(new File(string4));
            }
            catch (Exception exception) {
                // empty catch block
            }
            while (scanner != null && scanner.hasNextLine()) {
                String[] stringArray;
                String string5 = scanner.nextLine().trim();
                if (string5.length() == 0 || (stringArray = string5.split("=")).length != 2) continue;
                String string6 = stringArray[0].trim();
                String string7 = stringArray[1].trim();
                try {
                    switch (string6) {
                        case "SendBufferSize": {
                            n2 = Integer.parseInt(string7);
                            break;
                        }
                        case "ReceiveBufferSize": {
                            n3 = Integer.parseInt(string7);
                            break;
                        }
                        case "SendQueueSize": {
                            n4 = Integer.parseInt(string7);
                            break;
                        }
                        case "ReceiveQueueSize": {
                            n5 = Integer.parseInt(string7);
                            break;
                        }
                        case "SendInlineSize": {
                            n6 = Integer.parseInt(string7);
                            break;
                        }
                    }
                }
                catch (Exception exception) {}
            }
        }
        sendBufferSize = n2;
        receiveBufferSize = n3;
        sendQueueSize = n4;
        receiveQueueSize = n5;
        sendInlineSize = n6;
    }
}

