/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;

public class Runtime {
    private static Runtime currentRuntime = new Runtime();

    public static Runtime getRuntime() {
        return currentRuntime;
    }

    private Runtime() {
    }

    public void exit(int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkExit(n);
        }
        Shutdown.exit(n);
    }

    public void addShutdownHook(Thread thread) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("shutdownHooks"));
        }
        ApplicationShutdownHooks.add(thread);
    }

    public boolean removeShutdownHook(Thread thread) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("shutdownHooks"));
        }
        return ApplicationShutdownHooks.remove(thread);
    }

    public void halt(int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkExit(n);
        }
        Shutdown.halt(n);
    }

    @Deprecated
    public static void runFinalizersOnExit(boolean bl) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkExit(0);
            }
            catch (SecurityException securityException) {
                throw new SecurityException("runFinalizersOnExit");
            }
        }
        Shutdown.setRunFinalizersOnExit(bl);
    }

    public Process exec(String string) throws IOException {
        return this.exec(string, null, null);
    }

    public Process exec(String string, String[] stringArray) throws IOException {
        return this.exec(string, stringArray, null);
    }

    public Process exec(String string, String[] stringArray, File file) throws IOException {
        if (string.length() == 0) {
            throw new IllegalArgumentException("Empty command");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String[] stringArray2 = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray2[n] = stringTokenizer.nextToken();
            ++n;
        }
        return this.exec(stringArray2, stringArray, file);
    }

    public Process exec(String[] stringArray) throws IOException {
        return this.exec(stringArray, null, null);
    }

    public Process exec(String[] stringArray, String[] stringArray2) throws IOException {
        return this.exec(stringArray, stringArray2, null);
    }

    public Process exec(String[] stringArray, String[] stringArray2, File file) throws IOException {
        return new ProcessBuilder(stringArray).environment(stringArray2).directory(file).start();
    }

    public native int availableProcessors();

    public native long freeMemory();

    public native long totalMemory();

    public native long maxMemory();

    public native void gc();

    private static native void runFinalization0();

    public void runFinalization() {
        Runtime.runFinalization0();
    }

    public native void traceInstructions(boolean var1);

    public native void traceMethodCalls(boolean var1);

    @CallerSensitive
    public void load(String string) {
        this.load0(Reflection.getCallerClass(), string);
    }

    synchronized void load0(Class clazz, String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkLink(string);
        }
        if (!new File(string).isAbsolute()) {
            throw new UnsatisfiedLinkError("Expecting an absolute path of the library: " + string);
        }
        ClassLoader.loadLibrary((Class)clazz, (String)string, (boolean)true);
    }

    @CallerSensitive
    public void loadLibrary(String string) {
        this.loadLibrary0(Reflection.getCallerClass(), string);
    }

    synchronized void loadLibrary0(Class clazz, String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkLink(string);
        }
        if (string.indexOf(File.separatorChar) != -1) {
            throw new UnsatisfiedLinkError("Directory separator should not appear in library name: " + string);
        }
        ClassLoader.loadLibrary((Class)clazz, (String)string, (boolean)false);
    }

    @Deprecated
    public InputStream getLocalizedInputStream(InputStream inputStream) {
        return inputStream;
    }

    @Deprecated
    public OutputStream getLocalizedOutputStream(OutputStream outputStream) {
        return outputStream;
    }
}

