/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils.resolver.implementations;

import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverException;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverSpi;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xml.utils.URI;
import org.w3c.dom.Attr;

public class ResolverDirectHTTP
extends ResourceResolverSpi {
    static Logger log = Logger.getLogger(ResolverDirectHTTP.class.getName());
    private static final String[] properties = new String[]{"http.proxy.host", "http.proxy.port", "http.proxy.username", "http.proxy.password", "http.basic.username", "http.basic.password"};
    private static final int HttpProxyHost = 0;
    private static final int HttpProxyPort = 1;
    private static final int HttpProxyUser = 2;
    private static final int HttpProxyPass = 3;
    private static final int HttpBasicUser = 4;
    private static final int HttpBasicPass = 5;

    @Override
    public boolean engineIsThreadSafe() {
        return true;
    }

    @Override
    public XMLSignatureInput engineResolve(Attr attr, String string) throws ResourceResolverException {
        try {
            Object object;
            Object object2;
            boolean bl = false;
            String string2 = this.engineGetProperty(properties[0]);
            String string3 = this.engineGetProperty(properties[1]);
            if (string2 != null && string3 != null) {
                bl = true;
            }
            String string4 = null;
            String string5 = null;
            String string6 = null;
            if (bl) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Use of HTTP proxy enabled: " + string2 + ":" + string3);
                }
                string4 = System.getProperty("http.proxySet");
                string5 = System.getProperty("http.proxyHost");
                string6 = System.getProperty("http.proxyPort");
                System.setProperty("http.proxySet", "true");
                System.setProperty("http.proxyHost", string2);
                System.setProperty("http.proxyPort", string3);
            }
            boolean bl2 = string4 != null && string5 != null && string6 != null;
            URI uRI = this.getNewURI(attr.getNodeValue(), string);
            URI uRI2 = new URI(uRI);
            uRI2.setFragment(null);
            URL uRL = new URL(uRI2.toString());
            URLConnection uRLConnection = uRL.openConnection();
            String string7 = this.engineGetProperty(properties[2]);
            Object object3 = this.engineGetProperty(properties[3]);
            if (string7 != null && object3 != null) {
                object2 = string7 + ":" + (String)object3;
                object = Base64.encode(((String)object2).getBytes());
                uRLConnection.setRequestProperty("Proxy-Authorization", (String)object);
            }
            if ((string7 = uRLConnection.getHeaderField("WWW-Authenticate")) != null && string7.startsWith("Basic")) {
                object3 = this.engineGetProperty(properties[4]);
                object2 = this.engineGetProperty(properties[5]);
                if (object3 != null && object2 != null) {
                    uRLConnection = uRL.openConnection();
                    object = (String)object3 + ":" + (String)object2;
                    String string8 = Base64.encode(((String)object).getBytes());
                    uRLConnection.setRequestProperty("Authorization", "Basic " + string8);
                }
            }
            string7 = uRLConnection.getHeaderField("Content-Type");
            object3 = uRLConnection.getInputStream();
            object2 = new ByteArrayOutputStream();
            object = new byte[4096];
            int n = 0;
            int n2 = 0;
            while ((n = ((InputStream)object3).read((byte[])object)) >= 0) {
                ((ByteArrayOutputStream)object2).write((byte[])object, 0, n);
                n2 += n;
            }
            log.log(Level.FINE, "Fetched " + n2 + " bytes from URI " + uRI.toString());
            XMLSignatureInput xMLSignatureInput = new XMLSignatureInput(((ByteArrayOutputStream)object2).toByteArray());
            xMLSignatureInput.setSourceURI(uRI.toString());
            xMLSignatureInput.setMIMEType(string7);
            if (bl && bl2) {
                System.setProperty("http.proxySet", string4);
                System.setProperty("http.proxyHost", string5);
                System.setProperty("http.proxyPort", string6);
            }
            return xMLSignatureInput;
        }
        catch (MalformedURLException malformedURLException) {
            throw new ResourceResolverException("generic.EmptyMessage", malformedURLException, attr, string);
        }
        catch (IOException iOException) {
            throw new ResourceResolverException("generic.EmptyMessage", iOException, attr, string);
        }
    }

    @Override
    public boolean engineCanResolve(Attr attr, String string) {
        if (attr == null) {
            log.log(Level.FINE, "quick fail, uri == null");
            return false;
        }
        String string2 = attr.getNodeValue();
        if (string2.equals("") || string2.charAt(0) == '#') {
            log.log(Level.FINE, "quick fail for empty URIs and local ones");
            return false;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "I was asked whether I can resolve " + string2);
        }
        if (string2.startsWith("http:") || string != null && string.startsWith("http:")) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "I state that I can resolve " + string2);
            }
            return true;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "I state that I can't resolve " + string2);
        }
        return false;
    }

    @Override
    public String[] engineGetPropertyKeys() {
        return (String[])properties.clone();
    }

    private URI getNewURI(String string, String string2) throws URI.MalformedURIException {
        if (string2 == null || "".equals(string2)) {
            return new URI(string);
        }
        return new URI(new URI(string2), string);
    }
}

