/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyEventPostProcessor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;
import javax.swing.plaf.basic.ComboPopup;
import sun.awt.SunToolkit;

public class WindowsRootPaneUI
extends BasicRootPaneUI {
    private static final WindowsRootPaneUI windowsRootPaneUI = new WindowsRootPaneUI();
    static final AltProcessor altProcessor = new AltProcessor();

    public static ComponentUI createUI(JComponent jComponent) {
        return windowsRootPaneUI;
    }

    static class AltProcessor
    implements KeyEventPostProcessor {
        static boolean altKeyPressed = false;
        static boolean menuCanceledOnPress = false;
        static JRootPane root = null;
        static Window winAncestor = null;
        private int topTier = 0;
        private JMenuBar topMBar = null;

        AltProcessor() {
        }

        void altPressed(KeyEvent keyEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (menuElementArray.length > 0 && !(menuElementArray[0] instanceof ComboPopup)) {
                menuSelectionManager.clearSelectedPath();
                menuCanceledOnPress = true;
                keyEvent.consume();
            } else if (menuElementArray.length > 0) {
                menuCanceledOnPress = false;
                if (WindowsLookAndFeel.isMnemonicHidden()) {
                    WindowsLookAndFeel.setMnemonicHidden(false);
                    WindowsGraphicsUtils.repaintMnemonicsInWindow(winAncestor);
                }
                keyEvent.consume();
            } else {
                JMenu jMenu;
                JMenuBar jMenuBar;
                menuCanceledOnPress = false;
                WindowsLookAndFeel.setMnemonicHidden(false);
                WindowsGraphicsUtils.repaintMnemonicsInWindow(winAncestor);
                JMenuBar jMenuBar2 = jMenuBar = root != null ? root.getJMenuBar() : null;
                if (jMenuBar == null && winAncestor instanceof JFrame) {
                    jMenuBar = ((JFrame)winAncestor).getJMenuBar();
                }
                if (jMenuBar == null && root != null) {
                    jMenuBar = this.getJMenuBar(root);
                }
                JMenu jMenu2 = jMenu = jMenuBar != null ? jMenuBar.getMenu(0) : null;
                if (jMenu != null) {
                    keyEvent.consume();
                }
            }
        }

        void altReleased(KeyEvent keyEvent) {
            if (menuCanceledOnPress) {
                WindowsLookAndFeel.setMnemonicHidden(true);
                WindowsGraphicsUtils.repaintMnemonicsInWindow(winAncestor);
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            if (menuSelectionManager.getSelectedPath().length == 0) {
                JMenuBar jMenuBar;
                JMenuBar jMenuBar2 = jMenuBar = root != null ? root.getJMenuBar() : null;
                if (jMenuBar == null && winAncestor instanceof JFrame) {
                    jMenuBar = ((JFrame)winAncestor).getJMenuBar();
                }
                if (jMenuBar == null && root != null) {
                    jMenuBar = this.getJMenuBar(root);
                }
                JMenu jMenu = jMenuBar != null ? jMenuBar.getMenu(0) : null;
                boolean bl = false;
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                if (toolkit instanceof SunToolkit) {
                    boolean bl2 = bl = keyEvent.getWhen() <= ((SunToolkit)toolkit).getWindowDeactivationTime(winAncestor);
                }
                if (jMenu != null && !bl) {
                    MenuElement[] menuElementArray = new MenuElement[]{jMenuBar, jMenu};
                    menuSelectionManager.setSelectedPath(menuElementArray);
                } else if (!WindowsLookAndFeel.isMnemonicHidden() && !altKeyPressed) {
                    WindowsLookAndFeel.setMnemonicHidden(true);
                    WindowsGraphicsUtils.repaintMnemonicsInWindow(winAncestor);
                }
            } else if (menuSelectionManager.getSelectedPath()[0] instanceof ComboPopup) {
                WindowsLookAndFeel.setMnemonicHidden(true);
                WindowsGraphicsUtils.repaintMnemonicsInWindow(winAncestor);
            }
        }

        @Override
        public boolean postProcessKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.isConsumed()) {
                return false;
            }
            if (keyEvent.getKeyCode() == 18) {
                root = SwingUtilities.getRootPane(keyEvent.getComponent());
                Window window = winAncestor = root == null ? null : SwingUtilities.getWindowAncestor(root);
                if (keyEvent.getID() == 401) {
                    if (!altKeyPressed) {
                        this.altPressed(keyEvent);
                    }
                    altKeyPressed = true;
                    return true;
                }
                if (keyEvent.getID() == 402) {
                    if (altKeyPressed) {
                        this.altReleased(keyEvent);
                    } else {
                        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                        MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
                        if (menuElementArray.length <= 0) {
                            WindowsLookAndFeel.setMnemonicHidden(true);
                            WindowsGraphicsUtils.repaintMnemonicsInWindow(winAncestor);
                        }
                    }
                    altKeyPressed = false;
                }
                root = null;
                winAncestor = null;
            } else {
                altKeyPressed = false;
            }
            return false;
        }

        private JMenuBar getJMenuBar(JRootPane jRootPane) {
            Window window;
            JMenuBar jMenuBar = null;
            if (jRootPane != null && (jMenuBar = this.getTopJMenuBar(jRootPane)) == null && jRootPane.getParent() instanceof JInternalFrame && (window = SwingUtilities.windowForComponent(jRootPane.getParent())) != null && window instanceof RootPaneContainer) {
                jRootPane = ((RootPaneContainer)((Object)window)).getRootPane();
                jMenuBar = this.getTopJMenuBar(jRootPane);
            }
            return jMenuBar;
        }

        private JMenuBar getTopJMenuBar(JRootPane jRootPane) {
            this.topTier = 0;
            this.topMBar = null;
            if (jRootPane != null) {
                Container container = jRootPane.getContentPane();
                this.searchChildren(container, 0);
            }
            return this.topMBar;
        }

        private boolean searchChildren(Container container, int n) {
            if (container != null) {
                if (this.topTier != 0 && ++n >= this.topTier) {
                    return false;
                }
                Component[] componentArray = container.getComponents();
                for (int i = 0; i < componentArray.length; ++i) {
                    Component component = componentArray[i];
                    if (component instanceof JMenuBar) {
                        if (this.topTier != 0 && n >= this.topTier) continue;
                        this.topTier = n;
                        this.topMBar = (JMenuBar)component;
                        return true;
                    }
                    if (component instanceof Container && this.searchChildren((Container)component, n)) break;
                }
            }
            return false;
        }
    }
}

