/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.oa.poa;

import com.sun.corba.se.spi.extension.CopyObjectPolicy;
import com.sun.corba.se.spi.extension.ServantCachingPolicy;
import com.sun.corba.se.spi.extension.ZeroPortPolicy;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import org.omg.CORBA.Policy;
import org.omg.PortableServer.IdAssignmentPolicy;
import org.omg.PortableServer.IdUniquenessPolicy;
import org.omg.PortableServer.ImplicitActivationPolicy;
import org.omg.PortableServer.LifespanPolicy;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.RequestProcessingPolicy;
import org.omg.PortableServer.ServantRetentionPolicy;
import org.omg.PortableServer.ThreadPolicy;

public final class Policies {
    private static final int MIN_POA_POLICY_ID = 16;
    private static final int MAX_POA_POLICY_ID = 22;
    private static final int POLICY_TABLE_SIZE = 7;
    int defaultObjectCopierFactoryId;
    private HashMap policyMap = new HashMap();
    public static final Policies defaultPolicies = new Policies();
    public static final Policies rootPOAPolicies = new Policies(0, 0, 0, 1, 0, 0, 0);
    private int[] poaPolicyValues;

    private int getPolicyValue(int n) {
        return this.poaPolicyValues[n - 16];
    }

    private void setPolicyValue(int n, int n2) {
        this.poaPolicyValues[n - 16] = n2;
    }

    private Policies(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.poaPolicyValues = new int[]{n, n2, n3, n4, n5, n6, n7};
    }

    private Policies() {
        this(0, 0, 0, 1, 1, 0, 0);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Policies[");
        boolean bl = true;
        Iterator iterator = this.policyMap.values().iterator();
        while (iterator.hasNext()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",");
            }
            stringBuffer.append(iterator.next().toString());
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private int getPOAPolicyValue(Policy policy) {
        if (policy instanceof ThreadPolicy) {
            return ((ThreadPolicy)policy).value().value();
        }
        if (policy instanceof LifespanPolicy) {
            return ((LifespanPolicy)policy).value().value();
        }
        if (policy instanceof IdUniquenessPolicy) {
            return ((IdUniquenessPolicy)policy).value().value();
        }
        if (policy instanceof IdAssignmentPolicy) {
            return ((IdAssignmentPolicy)policy).value().value();
        }
        if (policy instanceof ServantRetentionPolicy) {
            return ((ServantRetentionPolicy)policy).value().value();
        }
        if (policy instanceof RequestProcessingPolicy) {
            return ((RequestProcessingPolicy)policy).value().value();
        }
        if (policy instanceof ImplicitActivationPolicy) {
            return ((ImplicitActivationPolicy)policy).value().value();
        }
        return -1;
    }

    private void checkForPolicyError(BitSet bitSet) throws InvalidPolicy {
        for (short s = 0; s < bitSet.length(); s = (short)(s + 1)) {
            if (!bitSet.get(s)) continue;
            throw new InvalidPolicy(s);
        }
    }

    private void addToErrorSet(Policy[] policyArray, int n, BitSet bitSet) {
        for (int i = 0; i < policyArray.length; ++i) {
            if (policyArray[i].policy_type() != n) continue;
            bitSet.set(i);
            return;
        }
    }

    Policies(Policy[] policyArray, int n) throws InvalidPolicy {
        this();
        this.defaultObjectCopierFactoryId = n;
        if (policyArray == null) {
            return;
        }
        BitSet bitSet = new BitSet(policyArray.length);
        for (int n2 = 0; n2 < policyArray.length; n2 = (int)((short)(n2 + 1))) {
            Policy policy = policyArray[n2];
            int n3 = this.getPOAPolicyValue(policy);
            Integer n4 = new Integer(policy.policy_type());
            Policy policy2 = (Policy)this.policyMap.get(n4);
            if (policy2 == null) {
                this.policyMap.put(n4, policy);
            }
            if (n3 < 0) continue;
            this.setPolicyValue(n4, n3);
            if (policy2 == null || this.getPOAPolicyValue(policy2) == n3) continue;
            bitSet.set(n2);
        }
        if (!this.retainServants() && this.useActiveMapOnly()) {
            this.addToErrorSet(policyArray, 21, bitSet);
            this.addToErrorSet(policyArray, 22, bitSet);
        }
        if (this.isImplicitlyActivated()) {
            if (!this.retainServants()) {
                this.addToErrorSet(policyArray, 20, bitSet);
                this.addToErrorSet(policyArray, 21, bitSet);
            }
            if (!this.isSystemAssignedIds()) {
                this.addToErrorSet(policyArray, 20, bitSet);
                this.addToErrorSet(policyArray, 19, bitSet);
            }
        }
        this.checkForPolicyError(bitSet);
    }

    public Policy get_effective_policy(int n) {
        Integer n2 = new Integer(n);
        Policy policy = (Policy)this.policyMap.get(n2);
        return policy;
    }

    public final boolean isOrbControlledThreads() {
        return this.getPolicyValue(16) == 0;
    }

    public final boolean isSingleThreaded() {
        return this.getPolicyValue(16) == 1;
    }

    public final boolean isTransient() {
        return this.getPolicyValue(17) == 0;
    }

    public final boolean isPersistent() {
        return this.getPolicyValue(17) == 1;
    }

    public final boolean isUniqueIds() {
        return this.getPolicyValue(18) == 0;
    }

    public final boolean isMultipleIds() {
        return this.getPolicyValue(18) == 1;
    }

    public final boolean isUserAssignedIds() {
        return this.getPolicyValue(19) == 0;
    }

    public final boolean isSystemAssignedIds() {
        return this.getPolicyValue(19) == 1;
    }

    public final boolean retainServants() {
        return this.getPolicyValue(21) == 0;
    }

    public final boolean useActiveMapOnly() {
        return this.getPolicyValue(22) == 0;
    }

    public final boolean useDefaultServant() {
        return this.getPolicyValue(22) == 1;
    }

    public final boolean useServantManager() {
        return this.getPolicyValue(22) == 2;
    }

    public final boolean isImplicitlyActivated() {
        return this.getPolicyValue(20) == 0;
    }

    public final int servantCachingLevel() {
        Integer n = new Integer(0x53550000);
        ServantCachingPolicy servantCachingPolicy = (ServantCachingPolicy)((Object)this.policyMap.get(n));
        if (servantCachingPolicy == null) {
            return 0;
        }
        return servantCachingPolicy.getType();
    }

    public final boolean forceZeroPort() {
        Integer n = new Integer(1398079489);
        ZeroPortPolicy zeroPortPolicy = (ZeroPortPolicy)((Object)this.policyMap.get(n));
        if (zeroPortPolicy == null) {
            return false;
        }
        return zeroPortPolicy.forceZeroPort();
    }

    public final int getCopierId() {
        Integer n = new Integer(1398079490);
        CopyObjectPolicy copyObjectPolicy = (CopyObjectPolicy)((Object)this.policyMap.get(n));
        if (copyObjectPolicy != null) {
            return copyObjectPolicy.getValue();
        }
        return this.defaultObjectCopierFactoryId;
    }
}

