/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.packed;

import com.ibm.jvm.packed.PackedObject;
import com.ibm.jvm.packed.PackedObjectSupport;
import com.ibm.jvm.packed.PackedSerialContext;
import com.ibm.jvm.packed.PackedWriter;
import com.ibm.jvm.packed.reflect.PackedArray;
import com.ibm.jvm.packed.reflect.PackedField;
import com.ibm.jvm.packed.reflect.PackedUnsafe;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class WriterFactory {
    static PackedWriter pojoWriter = new POJOWriter();
    static PackedWriter simplePackedWriter = new SimplePackedWriter();
    static PackedWriter mixedPackedWriter = new MixedPackedWriter();
    static PackedWriter simplePackedArrayWriter = new PackedArrayWriter();
    static PackedWriter mixedPackedArrayWriter = new MixedPackedArrayWriter();
    static PackedWriter pReferenceWriter = new PackedReferenceWriter();
    static PackedWriter pReferenceArrayWriter = new PackedReferenceArrayWriter();
    static PackedWriter pInheritanceWriter = new PackedInheritanceWriter();

    static PackedWriter getPackedWriter(Class<?> clazz) {
        if (clazz == PackedObject[].class || PackedObject[].class.isAssignableFrom(clazz)) {
            return pReferenceArrayWriter;
        }
        if (clazz == PackedObject.class) {
            return pReferenceWriter;
        }
        Class<?> clazz2 = clazz;
        if (PackedObject.isPackedArray(clazz2)) {
            if (PackedObject.isMixedPacked(clazz2)) {
                return mixedPackedArrayWriter;
            }
            if (PackedArray.getComponentType(clazz2).getSuperclass() != PackedObject.class) {
                return mixedPackedArrayWriter;
            }
            return simplePackedArrayWriter;
        }
        if (clazz.isArray()) {
            if (PackedObject.isMixedPacked(clazz2)) {
                return mixedPackedArrayWriter;
            }
            return simplePackedArrayWriter;
        }
        if (PackedObject.isMixedPacked(clazz2)) {
            if (clazz2.getSuperclass() != PackedObject.class) {
                return pInheritanceWriter;
            }
            return mixedPackedWriter;
        }
        return simplePackedWriter;
    }

    static PackedWriter getMixedFieldWriter(PackedField packedField) {
        Class clazz = packedField.getType();
        if (clazz.isPrimitive()) {
            return null;
        }
        if (!packedField.isNestedPacked()) {
            if (clazz == PackedObject.class) {
                return pReferenceWriter;
            }
            if (clazz == PackedObject[].class || PackedObject[].class.isAssignableFrom(clazz)) {
                return pReferenceArrayWriter;
            }
        } else {
            Class clazz2 = clazz;
            if (clazz.isArray()) {
                if (PackedObject.isMixedPacked((Class)clazz2)) {
                    return mixedPackedArrayWriter;
                }
                return null;
            }
            if (PackedObject.isPackedArray((Class)clazz2)) {
                if (PackedObject.isMixedPacked((Class)clazz2)) {
                    return mixedPackedArrayWriter;
                }
                return null;
            }
            if (PackedObject.isMixedPacked((Class)clazz2)) {
                return mixedPackedWriter;
            }
            return null;
        }
        if (Object.class.isAssignableFrom(clazz)) {
            return pojoWriter;
        }
        return null;
    }

    private static final class POJOWriter
    extends AbstractWriter {
        private POJOWriter() {
        }

        @Override
        public byte getMarkerByte() {
            return 6;
        }

        @Override
        public void writeAsMixedField(PackedField packedField, PackedObject packedObject, ObjectOutputStream objectOutputStream, PackedSerialContext packedSerialContext) throws IOException {
            if (packedSerialContext.debugEnabled()) {
                packedSerialContext.log("Mixed field name=" + packedField.getName());
            }
            Object object = this.getObjectFromField(packedField, packedObject);
            objectOutputStream.writeByte(6);
            int n = packedSerialContext.objectWrite(object);
            objectOutputStream.writeInt(n);
            if (packedSerialContext.debugEnabled()) {
                packedSerialContext.log("Java object " + (object != null ? "type=" + object.getClass().getName() + ":" + object : "NULL"));
            }
            objectOutputStream.writeObject(object);
        }
    }

    private static final class PackedReferenceArrayWriter
    extends AbstractWriter {
        private PackedReferenceArrayWriter() {
        }

        @Override
        public byte getMarkerByte() {
            return 5;
        }

        @Override
        public void writeAsMixedField(PackedField packedField, PackedObject packedObject, ObjectOutputStream objectOutputStream, PackedSerialContext packedSerialContext) throws IOException {
            try {
                long l = PackedReferenceArrayWriter.getUs().fieldOffset(packedField);
                PackedObject[] packedObjectArray = (PackedObject[])PackedReferenceArrayWriter.getUs().getObject(packedObject, l);
                if (this.checkLastWrittenObject(packedObjectArray, objectOutputStream, packedSerialContext)) {
                    return;
                }
                int n = packedSerialContext.objectWrite(packedObjectArray);
                objectOutputStream.writeByte(5);
                objectOutputStream.writeInt(n);
                objectOutputStream.writeInt(packedObjectArray.length);
                if (packedSerialContext.debugEnabled()) {
                    packedSerialContext.log("Array type=PackedOject length=" + packedObjectArray.length);
                }
                for (int i = 0; i < packedObjectArray.length; ++i) {
                    PackedObject packedObject2 = packedObjectArray[i];
                    if (packedSerialContext.debugEnabled()) {
                        packedSerialContext.log("Array element [" + i + "]");
                    }
                    PackedObjectSupport.writePackedObject(packedObject2, objectOutputStream, packedSerialContext);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
        }

        @Override
        public void writePackedObject(PackedObject packedObject, ObjectOutputStream objectOutputStream, PackedSerialContext packedSerialContext) throws IOException {
            PackedObject packedObject2 = packedObject;
            objectOutputStream.writeInt(PackedArray.getLength((PackedObject)packedObject2));
            if (packedSerialContext.debugEnabled()) {
                packedSerialContext.log("Array type=PackedOject length=" + PackedArray.getLength((PackedObject)packedObject2));
            }
            for (int i = 0; i < PackedArray.getLength((PackedObject)packedObject2); ++i) {
                PackedObject packedObject3 = PackedArray.getPackedObject((PackedObject)packedObject2, (int)i);
                if (packedSerialContext.debugEnabled()) {
                    packedSerialContext.log("Array element [" + i + "]");
                }
                PackedObjectSupport.writePackedObject(packedObject3, objectOutputStream, packedSerialContext);
            }
        }
    }

    private static final class MixedPackedArrayWriter
    extends AbstractWriter {
        private MixedPackedArrayWriter() {
        }

        @Override
        public byte getMarkerByte() {
            return 3;
        }

        @Override
        public void writeAsMixedField(PackedField packedField, PackedObject packedObject, ObjectOutputStream objectOutputStream, PackedSerialContext packedSerialContext) throws IOException {
            PackedObject packedObject2 = this.getNestedPackedArrayFromField(packedField, packedObject);
            if (this.checkLastWrittenObject(packedObject2, objectOutputStream, packedSerialContext)) {
                return;
            }
            int n = packedSerialContext.objectWrite(packedObject2);
            objectOutputStream.writeByte(3);
            objectOutputStream.writeInt(n);
            if (packedObject2.isPackedArray() && packedSerialContext.debugEnabled()) {
                packedSerialContext.log("Mixed field name=" + packedField.getName());
            }
            for (int i = 0; i < PackedArray.getLength((PackedObject)packedObject2); ++i) {
                if (packedSerialContext.debugEnabled()) {
                    packedSerialContext.log("Array element = [" + i + "]");
                }
                PackedObject packedObject3 = PackedArray.getPackedObject((PackedObject)packedObject2, (int)i);
                this.writeFields(packedObject3.getClass(), packedObject3, objectOutputStream, packedSerialContext);
                objectOutputStream.writeByte(16);
            }
        }

        @Override
        public void writePackedObject(PackedObject packedObject, ObjectOutputStream objectOutputStream, PackedSerialContext packedSerialContext) throws IOException {
            if (packedObject == null) {
                if (packedSerialContext.debugEnabled()) {
                    packedSerialContext.log("Mixed array type=(null)");
                }
                objectOutputStream.writeInt(-1);
                return;
            }
            PackedObject packedObject2 = packedObject;
            Class<?> clazz = packedObject.getClass().getComponentType();
            if (clazz == null) {
                clazz = packedObject.getClass();
                objectOutputStream.writeInt(PackedArray.getLength((PackedObject)packedObject2));
            }
            this.writeClassDesc(clazz, objectOutputStream);
            if (packedSerialContext.debugEnabled()) {
                packedSerialContext.log("Mixed array type=" + packedObject.getClass().getName() + " length=" + PackedArray.getLength((PackedObject)packedObject2));
            }
            for (int i = 0; i < PackedArray.getLength((PackedObject)packedObject2); ++i) {
                if (packedSerialContext.debugEnabled()) {
                    packedSerialContext.log("Array element = [" + i + "]");
                }
                PackedObject packedObject3 = PackedArray.getPackedObject((PackedObject)packedObject2, (int)i);
                PackedObjectSupport.writePackedObject(packedObject3, objectOutputStream, packedSerialContext);
            }
        }
    }

    private static final class PackedArrayWriter
    extends AbstractWriter {
        private PackedArrayWriter() {
        }

        @Override
        public byte getMarkerByte() {
            return 1;
        }

        @Override
        public void writePackedObject(PackedObject packedObject, ObjectOutputStream objectOutputStream, PackedSerialContext packedSerialContext) throws IOException {
            objectOutputStream.writeBoolean(packedObject.isNativePacked());
            PackedObject packedObject2 = packedObject;
            objectOutputStream.writeInt(PackedArray.getLength((PackedObject)packedObject2));
            Class<?> clazz = packedObject.getClass().getComponentType();
            if (clazz == null) {
                clazz = packedObject.getClass();
            }
            if (packedSerialContext.debugEnabled()) {
                packedSerialContext.log("Packed Array type=" + clazz + " length=" + PackedArray.getLength((PackedObject)packedObject2));
            }
            this.writeClassDesc(clazz, objectOutputStream);
            for (int i = 0; i < PackedArray.getLength((PackedObject)packedObject2); ++i) {
                PackedObject packedObject3 = PackedArray.getPackedObject((PackedObject)packedObject2, (int)i);
                if (packedSerialContext.debugEnabled()) {
                    packedSerialContext.log("Array element = [" + i + "]");
                }
                PackedObjectSupport.writePackedObject(packedObject3, objectOutputStream, packedSerialContext);
            }
        }
    }

    private static final class PackedReferenceWriter
    extends AbstractWriter {
        private PackedReferenceWriter() {
        }

        @Override
        public byte getMarkerByte() {
            return 4;
        }

        @Override
        public void writeAsMixedField(PackedField packedField, PackedObject packedObject, ObjectOutputStream objectOutputStream, PackedSerialContext packedSerialContext) throws IOException {
            PackedObject packedObject2 = this.getPackedObjectFromField(packedField, packedObject);
            if (this.checkLastWrittenObject(packedObject2, objectOutputStream, packedSerialContext)) {
                return;
            }
            objectOutputStream.writeByte(4);
            if (packedSerialContext.debugEnabled()) {
                packedSerialContext.log("Mixed field name=" + packedField.getName());
            }
            PackedObjectSupport.writePackedObject(packedObject2, objectOutputStream, packedSerialContext);
        }

        @Override
        public void writePackedObject(PackedObject packedObject, ObjectOutputStream objectOutputStream, PackedSerialContext packedSerialContext) throws IOException {
            PackedObjectSupport.writePackedObject(packedObject, objectOutputStream, packedSerialContext);
        }
    }

    private static final class PackedInheritanceWriter
    extends AbstractWriter {
        private PackedInheritanceWriter() {
        }

        @Override
        public byte getMarkerByte() {
            return 14;
        }

        @Override
        public void writeAsMixedField(PackedField packedField, PackedObject packedObject, ObjectOutputStream objectOutputStream, PackedSerialContext packedSerialContext) throws IOException {
            PackedObject packedObject2 = this.getNestedPackedObjectFromField(packedField, packedObject);
            if (this.checkLastWrittenObject(packedObject2, objectOutputStream, packedSerialContext)) {
                return;
            }
            objectOutputStream.writeByte(2);
            int n = packedSerialContext.objectWrite(packedObject2);
            objectOutputStream.writeInt(n);
            if (packedSerialContext.debugEnabled()) {
                packedSerialContext.log("Mixed field name=" + packedField.getName());
            }
            this.writeFields(packedObject2.getClass(), packedObject2, objectOutputStream, packedSerialContext);
            objectOutputStream.writeByte(16);
        }

        @Override
        public void writePackedObject(PackedObject packedObject, ObjectOutputStream objectOutputStream, PackedSerialContext packedSerialContext) throws IOException {
            Class clazz = packedObject.getClass();
            int n = 0;
            int n2 = 0;
            Class clazz2 = clazz;
            Class clazz3 = clazz;
            while (clazz3 != PackedObject.class && Serializable.class.isAssignableFrom(clazz3)) {
                clazz3 = clazz3.getSuperclass();
                ++n;
            }
            Class[] classArray = new Class[n];
            for (clazz3 = clazz; clazz3 != PackedObject.class && Serializable.class.isAssignableFrom(clazz3); clazz3 = clazz3.getSuperclass()) {
                if (n2 >= n) continue;
                classArray[n2++] = clazz3;
            }
            List<Class> list = Arrays.asList(classArray);
            Collections.reverse(list);
            objectOutputStream.writeByte(classArray.length);
            this.writeClassDesc(clazz, objectOutputStream);
            this.writeSerializedByteArray(packedObject, objectOutputStream, packedSerialContext);
            for (n2 = 0; n2 < classArray.length; ++n2) {
                if (packedSerialContext.debugEnabled()) {
                    packedSerialContext.log("Mixed object: type=" + clazz.getName());
                }
                clazz = list.get(n2);
                this.writeClassDesc(clazz, objectOutputStream);
                this.writeFields(clazz, packedObject, objectOutputStream, packedSerialContext);
                objectOutputStream.writeByte(16);
            }
        }
    }

    private static final class MixedPackedWriter
    extends AbstractWriter {
        private MixedPackedWriter() {
        }

        @Override
        public byte getMarkerByte() {
            return 2;
        }

        @Override
        public void writeAsMixedField(PackedField packedField, PackedObject packedObject, ObjectOutputStream objectOutputStream, PackedSerialContext packedSerialContext) throws IOException {
            PackedObject packedObject2 = this.getNestedPackedObjectFromField(packedField, packedObject);
            if (this.checkLastWrittenObject(packedObject2, objectOutputStream, packedSerialContext)) {
                return;
            }
            objectOutputStream.writeByte(2);
            int n = packedSerialContext.objectWrite(packedObject2);
            objectOutputStream.writeInt(n);
            if (packedSerialContext.debugEnabled()) {
                packedSerialContext.log("Mixed field name=" + packedField.getName());
            }
            this.writeFields(packedObject2.getClass(), packedObject2, objectOutputStream, packedSerialContext);
            objectOutputStream.writeByte(16);
        }

        @Override
        public void writePackedObject(PackedObject packedObject, ObjectOutputStream objectOutputStream, PackedSerialContext packedSerialContext) throws IOException {
            Class<?> clazz = packedObject.getClass();
            this.writeClassDesc(clazz, objectOutputStream);
            if (packedSerialContext.debugEnabled()) {
                packedSerialContext.log("Mixed object: type=" + clazz.getName());
            }
            this.writeSerializedByteArray(packedObject, objectOutputStream, packedSerialContext);
            this.writeFields(clazz, packedObject, objectOutputStream, packedSerialContext);
            objectOutputStream.writeByte(16);
        }
    }

    private static final class SimplePackedWriter
    extends AbstractWriter {
        private SimplePackedWriter() {
        }

        @Override
        public byte getMarkerByte() {
            return 0;
        }

        @Override
        public void writePackedObject(PackedObject packedObject, ObjectOutputStream objectOutputStream, PackedSerialContext packedSerialContext) throws IOException {
            boolean bl = packedObject.isNativePacked();
            objectOutputStream.writeBoolean(bl);
            Class<?> clazz = packedObject.getClass();
            if (packedSerialContext.debugEnabled()) {
                packedSerialContext.log("Simple Packed type=" + clazz.getName() + " native=" + bl);
            }
            this.writeClassDesc(clazz, objectOutputStream);
            this.writeSerializedByteArray(packedObject, objectOutputStream, packedSerialContext);
        }
    }

    private static abstract class AbstractWriter
    implements PackedWriter {
        static final int MAX_BUFFER_SIZE = 1024;
        private static PackedUnsafe us = PackedUnsafe.getUnsafe();

        private AbstractWriter() {
        }

        @Override
        public void writeAsMixedField(PackedField packedField, PackedObject packedObject, ObjectOutputStream objectOutputStream, PackedSerialContext packedSerialContext) throws IOException {
            throw new IOException("Unsupported operation");
        }

        @Override
        public void writePackedObject(PackedObject packedObject, ObjectOutputStream objectOutputStream, PackedSerialContext packedSerialContext) throws IOException {
            throw new IOException("Unsupported operation");
        }

        Object getObjectFromField(PackedField packedField, PackedObject packedObject) {
            long l = AbstractWriter.getUs().fieldOffset(packedField);
            Object object = AbstractWriter.getUs().getObject(packedObject, l);
            return object;
        }

        PackedObject getPackedObjectFromField(PackedField packedField, PackedObject packedObject) {
            long l = AbstractWriter.getUs().fieldOffset(packedField);
            PackedObject packedObject2 = (PackedObject)AbstractWriter.getUs().getObject(packedObject, l);
            return packedObject2;
        }

        PackedObject getNestedPackedObjectFromField(PackedField packedField, PackedObject packedObject) {
            long l = AbstractWriter.getUs().fieldOffset(packedField);
            PackedObject packedObject2 = AbstractWriter.getUs().getNestedPackedObject(packedObject, l, packedField.getType());
            return packedObject2;
        }

        PackedObject getNestedPackedArrayFromField(PackedField packedField, PackedObject packedObject) {
            long l = AbstractWriter.getUs().fieldOffset(packedField);
            int n = packedField.getNestedArrayLength();
            PackedObject packedObject2 = AbstractWriter.getUs().getNestedPackedArray(packedObject, l, packedField.getType(), n);
            return packedObject2;
        }

        void writeFieldDesc(PackedField packedField, ObjectOutputStream objectOutputStream) throws IOException {
            String string = packedField.getName();
            objectOutputStream.writeByte(12);
            objectOutputStream.writeUTF(string);
        }

        void writeClassDesc(Class<?> clazz, ObjectOutputStream objectOutputStream) throws IOException {
            String string = clazz.getName();
            objectOutputStream.writeByte(11);
            objectOutputStream.writeUTF(string);
        }

        void writeSerializedByteArray(PackedObject packedObject, ObjectOutputStream objectOutputStream, PackedSerialContext packedSerialContext) throws IOException {
            long l = packedObject.getPackedDataSize();
            byte[] byArray = new byte[l > 1024L ? 1024 : (int)l];
            objectOutputStream.writeByte(10);
            objectOutputStream.writeLong(l);
            long l2 = 0L;
            long l3 = l;
            while (l3 > 0L) {
                int n = packedObject.writePackedDataToByteArray(l2, byArray, 0, byArray.length);
                if (n <= 0) {
                    throw new IOException("writePackedDataToByteArray failed");
                }
                objectOutputStream.write(byArray, 0, n);
                l3 -= (long)n;
                l2 += (long)n;
            }
        }

        void writeFields(Class<?> clazz, PackedObject packedObject, ObjectOutputStream objectOutputStream, PackedSerialContext packedSerialContext) throws IOException {
            PackedField[] packedFieldArray = PackedField.getDeclaredFields(clazz);
            for (int i = 0; i < packedFieldArray.length; ++i) {
                PackedWriter packedWriter;
                int n = packedFieldArray[i].getModifiers();
                if ((n & 8) > 0 || (n & 0x80) > 0 || (packedWriter = WriterFactory.getMixedFieldWriter(packedFieldArray[i])) == null) continue;
                this.writeFieldDesc(packedFieldArray[i], objectOutputStream);
                packedWriter.writeAsMixedField(packedFieldArray[i], packedObject, objectOutputStream, packedSerialContext);
            }
        }

        boolean checkLastWrittenObject(Object object, ObjectOutputStream objectOutputStream, PackedSerialContext packedSerialContext) throws IOException {
            int n;
            if (object == null) {
                objectOutputStream.writeByte(7);
                return true;
            }
            if (object != null && (n = packedSerialContext.getLastWrittenOffset(object)) >= 0) {
                if (packedSerialContext.debugEnabled()) {
                    packedSerialContext.log("Packed indirection offset=(" + n + ")");
                }
                objectOutputStream.writeByte(8);
                objectOutputStream.writeInt(n);
                return true;
            }
            return false;
        }

        public static PackedUnsafe getUs() {
            return us;
        }

        public static void setUs(PackedUnsafe packedUnsafe) {
            us = packedUnsafe;
        }
    }
}

