/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.nativeAdapterData.internal;

import com.ibm.cic.common.commonNativeAdapterData.ICommonNativeAdapterDataParser;
import com.ibm.cic.common.commonNativeAdapterData.ICommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.NativeAdapterData;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.adapterdata.ArtifactCommonAttributes;
import com.ibm.cic.common.core.model.adapterdata.IAdapterData;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.IErrorReporter;
import com.ibm.cic.common.nativeAdapterData.EnvironmentNativeData;
import com.ibm.cic.common.nativeAdapterData.LumkitNativeData;
import com.ibm.cic.common.nativeAdapterData.internal.IXMLConstants;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;

public class NativeAdapterDataParser
extends ICommonNativeAdapterDataParser
implements IXMLConstants {
    private NativeAdapterData nativeData;
    private IErrorReporter reporter;
    private ICommonNativeAdapterDataParser.ElemStack elemStack;

    public void initialize(IInstallableUnit iu, IErrorReporter errorReporter) {
        this.nativeData = new NativeAdapterData();
        this.reporter = errorReporter;
        this.elemStack = new ICommonNativeAdapterDataParser.ElemStack();
        super.initialize(iu, this.nativeData, this.elemStack, errorReporter);
    }

    public IArtifact startArtifact(String uri, String name, String qName, Attributes attributes, String key) {
        return super.startArtifact(this.elemStack, this.reporter, uri, name, qName, attributes, key);
    }

    public void endArtifact() {
        this.elemStack.pop();
    }

    public IArtifact startArtifactNoKey(String uri, String name, String qName, Attributes attributes, ArtifactCommonAttributes aca) {
        return super.startArtifactNoKey(this.elemStack, this.reporter, uri, name, qName, attributes, aca);
    }

    public void startElement(String uri, String name, String qName, Attributes attributes) {
        this.elemStack.push((Object)new ICommonNativeAdapterDataParser.ElemStackEntry(name));
        boolean processed = this.processCommonElement(name, attributes);
        if (!processed) {
            if (name.equals("lumkit")) {
                this.handleLumkitAttributes(attributes);
            } else if (name.equals("environment")) {
                this.handleEnvironmentAttributes(attributes);
            } else {
                this.reporter.unexpectedElement(name, attributes);
            }
        }
    }

    public void endElement(String uri, String name, String qName) {
        this.elemStack.pop();
    }

    public IAdapterData getAdapterData() {
        return this.nativeData;
    }

    public URL getSchema() {
        Bundle bundle = Platform.getBundle((String)"com.ibm.cic.common.nativeAdapterData");
        Path path = new Path("schema/nativeAdapterData.xsd");
        return FileLocator.find((Bundle)bundle, (IPath)path, null);
    }

    private void handleLumkitAttributes(Attributes attributes) {
        boolean hasErrors = false;
        if (!this.isTopLevelElement()) {
            this.reporter.unexpectedElement("lumkit", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "lumkit", new String[]{"ecfpath"})) {
            hasErrors = true;
        }
        String ecfpath = attributes.getValue("ecfpath");
        this.reporter.checkRequiredAttribute("lumkit", "ecfpath", (Object)ecfpath);
        if (!hasErrors) {
            this.nativeData.addData((ICommonNativeData)new LumkitNativeData(ecfpath));
        }
    }

    private void handleEnvironmentAttributes(Attributes attributes) {
        String value;
        String name;
        boolean hasErrors = false;
        if (!this.isTopLevelElement()) {
            this.reporter.unexpectedElement("environment", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "environment", new String[]{"name", "value", "append", "prepend", "context"})) {
            hasErrors = true;
        }
        if ((name = attributes.getValue("name")) == null) {
            this.reporter.checkRequiredAttribute("environment", "name", null);
            hasErrors = true;
        }
        if ((value = attributes.getValue("value")) == null) {
            this.reporter.checkRequiredAttribute("environment", "value", null);
            hasErrors = true;
        }
        String appendStr = attributes.getValue("append");
        String prependStr = attributes.getValue("prepend");
        String context = attributes.getValue("context");
        if (context == null) {
            this.reporter.checkRequiredAttribute("environment", "context", null);
            hasErrors = true;
        } else if (!context.equals("ALL_USER") && !context.equals("CURR_USER")) {
            this.reporter.invalidAttributeValue("environment", "context", context);
            hasErrors = true;
        }
        if (!hasErrors) {
            boolean append = appendStr != null && this.isAttributeTrue(appendStr);
            boolean prepend = prependStr != null && this.isAttributeTrue(prependStr);
            EnvironmentNativeData data = new EnvironmentNativeData(name, value, append, prepend, context);
            this.nativeData.addData((ICommonNativeData)data);
        }
    }
}

