/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.fips.provider;

import com.ibm.crypto.fips.provider.AlgorithmStatus;
import com.ibm.crypto.fips.provider.ECNamedCurve;
import com.ibm.crypto.fips.provider.ECParameterGenerator;
import com.ibm.crypto.fips.provider.ECPrivateKey;
import com.ibm.crypto.fips.provider.ECPublicKey;
import com.ibm.crypto.fips.provider.ECUtils;
import com.ibm.crypto.fips.provider.FIPSRuntimeException;
import com.ibm.crypto.fips.provider.SHA1withECDSA;
import com.ibm.crypto.fips.provider.SelfTest;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECFieldFp;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidParameterSpecException;

public final class ECKeyPairGenerator
extends KeyPairGeneratorSpi
implements AlgorithmStatus {
    private int a = 256;
    SecureRandom b = null;
    ECParameterSpec c;
    private static final String[] z;

    @Override
    public boolean isFipsApproved() {
        return true;
    }

    @Override
    public void initialize(int n2, SecureRandom secureRandom) {
        if (n2 < 192 || n2 > 521 || n2 != 192 && n2 != 224 && n2 != 256 && n2 != 384 && n2 != 521) {
            throw new InvalidParameterException(z[2]);
        }
        this.a = n2;
        this.b = secureRandom;
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof ECParameterSpec)) {
            if (algorithmParameterSpec instanceof ECGenParameterSpec) {
                this.c = ECNamedCurve.getECParameterSpec(((ECGenParameterSpec)algorithmParameterSpec).getName());
                if (this.c == null) {
                    throw new InvalidAlgorithmParameterException(z[4]);
                }
                this.b = secureRandom;
                this.a = this.c.getCurve().getField().getFieldSize();
                return;
            }
            throw new InvalidAlgorithmParameterException(z[5]);
        }
        this.c = (ECParameterSpec)algorithmParameterSpec;
        this.initialize(this.c.getCurve().getField().getFieldSize(), secureRandom);
    }

    @Override
    public KeyPair generateKeyPair() {
        if (!SelfTest.isFipsRunnable()) {
            throw new FIPSRuntimeException();
        }
        KeyPair keyPair = this.a();
        if (!this.a(keyPair)) {
            SelfTest.failure = new FIPSRuntimeException(z[3]);
            throw new FIPSRuntimeException(z[3]);
        }
        return keyPair;
    }

    protected KeyPair a() {
        if (this.b == null) {
            this.b = null;
            try {
                this.b = SecureRandom.getInstance(z[0]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.b = new SecureRandom();
            }
        }
        if (this.c == null) {
            this.b();
        }
        int n2 = this.c.getCurve().getField().getFieldSize();
        BigInteger bigInteger = new BigInteger(n2, this.b);
        bigInteger = bigInteger.abs();
        while (bigInteger.compareTo(this.c.getOrder()) != -1) {
            bigInteger = new BigInteger(n2, this.b);
            bigInteger = bigInteger.abs();
        }
        try {
            ECPrivateKey eCPrivateKey = new ECPrivateKey(bigInteger, this.c);
            ECPublicKey eCPublicKey = new ECPublicKey(ECUtils.b(bigInteger, this.c.getGenerator(), this.c.getCurve()), this.c);
            KeyPair keyPair = new KeyPair(eCPublicKey, eCPrivateKey);
            return keyPair;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new ProviderException(invalidKeyException.getMessage());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new ProviderException(invalidParameterSpecException.getMessage());
        }
    }

    private void b() {
        switch (this.a) {
            case 192: {
                ECFieldFp eCFieldFp = new ECFieldFp(ECParameterGenerator.a);
                Object var2_6 = null;
                EllipticCurve ellipticCurve = new EllipticCurve(eCFieldFp, ECParameterGenerator.E.mod(ECParameterGenerator.a), ECParameterGenerator.c);
                this.c = new ECParameterSpec(ellipticCurve, ECParameterGenerator.f, ECParameterGenerator.b, 1);
                break;
            }
            case 224: {
                ECFieldFp eCFieldFp = new ECFieldFp(ECParameterGenerator.g);
                Object var2_7 = null;
                EllipticCurve ellipticCurve = new EllipticCurve(eCFieldFp, ECParameterGenerator.E.mod(ECParameterGenerator.g), ECParameterGenerator.i);
                this.c = new ECParameterSpec(ellipticCurve, ECParameterGenerator.l, ECParameterGenerator.h, 1);
                break;
            }
            case 256: {
                ECFieldFp eCFieldFp = new ECFieldFp(ECParameterGenerator.m);
                Object var2_8 = null;
                EllipticCurve ellipticCurve = new EllipticCurve(eCFieldFp, ECParameterGenerator.E.mod(ECParameterGenerator.m), ECParameterGenerator.o);
                this.c = new ECParameterSpec(ellipticCurve, ECParameterGenerator.r, ECParameterGenerator.n, 1);
                break;
            }
            case 384: {
                ECFieldFp eCFieldFp = new ECFieldFp(ECParameterGenerator.s);
                Object var2_9 = null;
                EllipticCurve ellipticCurve = new EllipticCurve(eCFieldFp, ECParameterGenerator.E.mod(ECParameterGenerator.s), ECParameterGenerator.u);
                this.c = new ECParameterSpec(ellipticCurve, ECParameterGenerator.x, ECParameterGenerator.t, 1);
                break;
            }
            case 521: {
                ECFieldFp eCFieldFp = new ECFieldFp(ECParameterGenerator.y);
                Object var2_10 = null;
                EllipticCurve ellipticCurve = new EllipticCurve(eCFieldFp, ECParameterGenerator.E.mod(ECParameterGenerator.y), ECParameterGenerator.A);
                this.c = new ECParameterSpec(ellipticCurve, ECParameterGenerator.D, ECParameterGenerator.z, 1);
            }
        }
    }

    private boolean a(KeyPair keyPair) {
        PrivateKey privateKey;
        PublicKey publicKey;
        byte[] byArray = z[1].getBytes();
        try {
            publicKey = keyPair.getPublic();
        }
        catch (Exception exception) {
            return false;
        }
        try {
            privateKey = keyPair.getPrivate();
        }
        catch (Exception exception) {
            return false;
        }
        try {
            SHA1withECDSA sHA1withECDSA = new SHA1withECDSA();
            sHA1withECDSA.a(privateKey);
            sHA1withECDSA.a(byArray, 0, byArray.length);
            byte[] byArray2 = sHA1withECDSA.a();
            sHA1withECDSA.a(publicKey);
            sHA1withECDSA.a(byArray, 0, byArray.length);
            if (!sHA1withECDSA.a(byArray2)) {
                ((ECPublicKey)publicKey).zeroize();
                ((ECPrivateKey)privateKey).zeroize();
                return false;
            }
        }
        catch (Exception exception) {
            ((ECPublicKey)publicKey).zeroize();
            ((ECPrivateKey)privateKey).zeroize();
            return false;
        }
        return true;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "Kg\u0005\u001f\u0011aP:)&cK,#\u0019";
        int n3 = -1;
        block13: while (true) {
            char[] cArray;
            block18: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block17: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block17;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block18;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 2;
                                break;
                            }
                            case 1: {
                                n9 = 37;
                                break;
                            }
                            case 2: {
                                n9 = 72;
                                break;
                            }
                            case 3: {
                                n9 = 76;
                                break;
                            }
                            default: {
                                n9 = 116;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "Cg\u000b\b1Db\u0000\u0005>Ii\u0005\u0002;Rt\u001a\u001f Ws\u001f\u0014#X";
                    n3 = 0;
                    continue block13;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "RW!!\u0011\"V!6\u0011\"H=?\u0000\"G-l\u001bl@h#\u00128\u0005yuF.\u0005z~@.\u0005zyB.\u0005{t@.\u0005}~E";
                    n3 = 1;
                    continue block13;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "Gf\f\u001f5\"v!+\u001a\"\u0003h\u001a\u0011pL.5TV@;8TDD! \u0011f";
                    n3 = 2;
                    continue block13;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "AP::\u0011\"K)!\u0011\"K'8Tp@+#\u0013lL2)\u0010\"J:l\u001amQh?\u0001rU'>\u0000gA";
                    n3 = 3;
                    continue block13;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "RD:-\u0019q\u0005%9\u0007v\u0005*)TkK;8\u0015lF-l\u001bd\u0005\r\u000f$cW)!\u0011v@:\u001f\u0004gFh#\u0006\"`\u000b\u000b\u0011lu)>\u0015o@<)\u0006QU-/";
                    n3 = 4;
                    continue block13;
                }
                case 4: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

