/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.pakAdapterData;

import com.ibm.cic.common.commonNativeAdapterData.FileCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.ICommonNativeAdapterDataParser;
import com.ibm.cic.common.commonNativeAdapterData.ICommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.NativeAdapterData;
import com.ibm.cic.common.core.api.utils.PlatformUtils;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.adapterdata.ArtifactCommonAttributes;
import com.ibm.cic.common.core.model.adapterdata.IAdapterData;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.IErrorReporter;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.pakAdapterData.PakCommonAdapterData;
import com.ibm.cic.common.pakAdapterData.PakPropertyData;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;

public class PakAdapterDataParser
extends ICommonNativeAdapterDataParser {
    private static final Logger log = Logger.getLogger(PakAdapterDataParser.class);
    private NativeAdapterData pakData;
    private IErrorReporter reporter;
    private ICommonNativeAdapterDataParser.ElemStack elemStack;

    public void endArtifact() {
        this.elemStack.pop();
    }

    public void endElement(String uri, String name, String name2) {
        this.elemStack.pop();
    }

    public IAdapterData getAdapterData() {
        return this.pakData;
    }

    public URL getSchema() {
        Bundle bundle = Platform.getBundle((String)"com.ibm.cic.common.pakAdapterData");
        Path path = new Path("schema/pakAdapterData.xsd");
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        return url;
    }

    public void initialize(IInstallableUnit parentIU, IErrorReporter errorReporter) {
        this.pakData = new NativeAdapterData();
        this.reporter = errorReporter;
        this.elemStack = new ICommonNativeAdapterDataParser.ElemStack();
        super.initialize(parentIU, this.pakData, this.elemStack, this.reporter);
    }

    public IArtifact startArtifact(String uri, String name, String qName, Attributes attributes, String key) {
        return super.startArtifact(this.elemStack, this.reporter, uri, name, qName, attributes, key);
    }

    public void startElement(String uri, String name, String name2, Attributes attributes) {
        this.elemStack.push((Object)new ICommonNativeAdapterDataParser.ElemStackEntry(name));
        boolean processed = this.processCommonElement(name, attributes);
        if (!processed) {
            if (name.equals("pak")) {
                this.handlePakElementAttributes(attributes);
            } else if (name.equals("file") && this.isPakSubElement()) {
                this.handleFileAttributes(attributes);
            } else if (name.equals("property") && this.isPakSubElement()) {
                this.handlePropertyAttributes(attributes);
            } else {
                this.reporter.unexpectedElement(name, attributes);
            }
        }
    }

    private void handlePakElementAttributes(Attributes attributes) {
        String installLocation;
        String productInfoFile;
        boolean hasErrors = false;
        if (!this.isPerformSubElement()) {
            this.reporter.unexpectedElement("pak", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "pak", new String[]{"installLocation", "productInfoFile"})) {
            hasErrors = true;
        }
        if ((productInfoFile = attributes.getValue("productInfoFile")) == null) {
            this.reporter.checkRequiredAttribute("pak", "productInfoFile", null);
            hasErrors = true;
        }
        if ((installLocation = attributes.getValue("installLocation")) != null && !installLocation.equals("")) {
            IStatus status;
            if (installLocation.startsWith("..")) {
                this.reporter.invalidAttributeValue("pak", "installLocation", installLocation);
            }
            if (!(status = PlatformUtils.validatePath((String)installLocation)).isOK()) {
                log.debug("Invalid installLocation from meta-data.  Default to end user-specified's location.");
                installLocation = null;
            }
        }
        if (!hasErrors) {
            PakCommonAdapterData data = new PakCommonAdapterData(productInfoFile, installLocation);
            data.setLineNumber(this.reporter.getLastCharactersLineNumber());
            ICommonNativeData parent = this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addChild((ICommonNativeData)data);
            }
            this.elemStack.top().data = data;
        }
    }

    protected void handlePropertyAttributes(Attributes attributes) {
        boolean hasErrors = false;
        if (!this.isPakSubElement()) {
            this.reporter.unexpectedElement("property", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "property", new String[]{"name", "value"})) {
            hasErrors = true;
        }
        String propertyName = attributes.getValue("name");
        String propertyValue = attributes.getValue("value");
        if (propertyName == null) {
            this.reporter.checkRequiredAttribute("property", "name", null);
            hasErrors = true;
        } else if (propertyName.equals("")) {
            this.reporter.invalidAttributeValue("property", "name", propertyName);
        }
        if (propertyValue == null) {
            this.reporter.checkRequiredAttribute("property", "value", null);
            hasErrors = true;
        }
        if (!hasErrors) {
            PakPropertyData data = new PakPropertyData(propertyName, propertyValue);
            ICommonNativeData parent = this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addChild((ICommonNativeData)data);
            }
            this.elemStack.top().data = data;
        }
    }

    protected void handleFileAttributes(Attributes attributes) {
        boolean hasErrors = false;
        if (!this.isPakSubElement()) {
            this.reporter.unexpectedElement("file", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "file", new String[0])) {
            hasErrors = true;
        }
        if (!hasErrors) {
            FileCommonNativeData data = new FileCommonNativeData();
            ICommonNativeData parent = this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addChild((ICommonNativeData)data);
            }
            this.elemStack.top().data = data;
        }
    }

    protected boolean isPakSubElement() {
        ICommonNativeAdapterDataParser.ElemStackEntry entry = this.elemStack.top(-1);
        if (entry == null) {
            return false;
        }
        return entry.name.equals("pak");
    }

    protected boolean processCommonCharacters(String name, String chars) {
        boolean processed = false;
        processed = super.processCommonCharacters(name, chars);
        if (!processed) {
            if (name.equals("property") && this.isPakSubElement()) {
                processed = true;
            } else if (name.equals("file") && this.isPakSubElement()) {
                this.handlePakFilePath(chars);
                processed = true;
            } else {
                processed = false;
            }
        }
        return processed;
    }

    protected void handlePakFilePath(String text) {
        FileCommonNativeData data = (FileCommonNativeData)this.elemStack.top().data;
        if (data != null) {
            data.addFileText(text);
        }
    }

    public IArtifact startArtifactNoKey(String uri, String name, String qName, Attributes attributes, ArtifactCommonAttributes aca) {
        return super.startArtifactNoKey(this.elemStack, this.reporter, uri, name, qName, attributes, aca);
    }
}

