/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.product;

import com.ibm.ws.pak.internal.NIFPlugin;
import com.ibm.ws.pak.internal.PakCoreMessages;
import com.ibm.ws.pak.internal.utils.NIFPluginUtils;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import com.ibm.ws.pak.internal.utils.product.NoProductPluginFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class ProductPlugin
extends NIFPlugin {
    protected static final String S_OFFERING_PARAM = "offering";
    protected static final String S_OFFERINGNAME_PARAM = "offeringname";
    protected static final String S_VERSION_PARAM = "version";
    public static final String S_INSTALLROOT_PARAM = "installroot";
    public static final String S_COMPONENTMAPREPOSITORY_PARAM = "componentmaprepository";
    protected static final String S_PRODUCTGAVERSION_PARAM = "productgaversion";
    private ProductPlugin m_prodpAggregated = null;
    private ProductPlugin[] m_aprodpAvailable = null;
    private ProductPlugin[] m_aprodpFound = null;
    private static ProductPlugin m_prodpSingleton = null;
    private static ProductPlugin m_prodpCachedAggregated = null;
    private static final String S_EMPTY = "";
    private static final String[] AS_EMPTY = new String[0];
    private static final String[] AS_OPTIONAL_PARAMS = new String[]{"aggregatedpluginpath"};
    private static final String S_GET = "get";
    private static final String S_AGGREGATED_PLUGIN_PATH_PARAM = "aggregatedpluginpath";
    private static final String S_PRODUCT_PLUGIN_CLASS = "com.ibm.ws.pak.internal.utils.product.ProductPlugin";
    private static final String className = "ProductPlugin";

    public static ProductPlugin resetProductPluginIfNeeded(String sAcceptableTargetProductIDs) throws NoProductPluginFoundException {
        if (ProductPlugin.needToResetProductPlugin(sAcceptableTargetProductIDs)) {
            return ProductPlugin.resetProductPlugin(sAcceptableTargetProductIDs, null);
        }
        return ProductPlugin.m_prodpSingleton.m_prodpAggregated;
    }

    public static ProductPlugin resetProductPluginIfNeeded(String sAcceptableTargetProductIDs, String sProductGAVersion) throws NoProductPluginFoundException {
        if (ProductPlugin.needToResetProductPlugin(sAcceptableTargetProductIDs)) {
            return ProductPlugin.resetProductPlugin(sAcceptableTargetProductIDs, sProductGAVersion);
        }
        return ProductPlugin.m_prodpSingleton.m_prodpAggregated;
    }

    public static String getCurrentBackupPath() {
        return ProductPlugin.m_prodpSingleton.m_prodpAggregated.getBackuppath();
    }

    public static String getCurrentProductInstallRoot() {
        return ProductPlugin.m_prodpSingleton.m_prodpAggregated.getParamValue(S_INSTALLROOT_PARAM);
    }

    public static String getCurrentProductOffering() {
        return ProductPlugin.m_prodpSingleton.m_prodpAggregated.getOffering();
    }

    public static String getCurrentProductVersion() {
        return ProductPlugin.m_prodpSingleton.m_prodpAggregated.getProductcurrentversion();
    }

    public static String getProductGAVersion() {
        return ProductPlugin.m_prodpSingleton.m_prodpAggregated.getProductgaversion();
    }

    public static String[] getAllInstalledProductIDs() {
        if (m_prodpSingleton == null || ProductPlugin.m_prodpSingleton.m_aprodpFound == null) {
            return new String[0];
        }
        String[] asReturn = new String[ProductPlugin.m_prodpSingleton.m_aprodpFound.length];
        int i = 0;
        while (i < ProductPlugin.m_prodpSingleton.m_aprodpFound.length) {
            asReturn[i] = ProductPlugin.m_prodpSingleton.m_aprodpFound[i].getOffering();
            ++i;
        }
        return asReturn;
    }

    private static boolean needToResetProductPlugin(String sAcceptableTargetProductIDs) {
        if (sAcceptableTargetProductIDs == null || sAcceptableTargetProductIDs.equals(S_EMPTY)) {
            return false;
        }
        if (sAcceptableTargetProductIDs.equals("NA")) {
            return false;
        }
        String sCurrentOffering = m_prodpSingleton.getOffering();
        StringTokenizer st = new StringTokenizer(sAcceptableTargetProductIDs, ";");
        Vector<String> vAcceptableTargetProductIDs = new Vector<String>();
        while (st.hasMoreElements()) {
            String sToken = st.nextToken();
            vAcceptableTargetProductIDs.add(sToken);
            if (!sToken.trim().equals(sCurrentOffering)) continue;
            return false;
        }
        if ("EXPRESSTRIAL".equals(sCurrentOffering) && vAcceptableTargetProductIDs.contains("EXPRESS")) {
            return false;
        }
        return !"BASETRIAL".equals(sCurrentOffering) || !vAcceptableTargetProductIDs.contains("BASE");
    }

    private static ProductPlugin resetProductPlugin(String sAcceptableTargetProductIDs, String sProductGAVersion) throws NoProductPluginFoundException {
        ProductPlugin[] aprodp;
        StringTokenizer st = new StringTokenizer(sAcceptableTargetProductIDs, ";");
        Vector<String> vsTokens = new Vector<String>();
        while (st.hasMoreElements()) {
            vsTokens.add(st.nextToken().trim());
        }
        ProductPlugin[] productPluginArray = aprodp = ProductPlugin.m_prodpSingleton.m_aprodpFound;
        int n = aprodp.length;
        int n2 = 0;
        while (n2 < n) {
            ProductPlugin element = productPluginArray[n2];
            String sOfferingThis = element.getOffering();
            String sGAVersion = element.getProductgaversion();
            if (vsTokens.contains(sOfferingThis)) {
                if (sProductGAVersion == null) {
                    ProductPlugin.m_prodpSingleton.m_prodpAggregated = element;
                    return ProductPlugin.m_prodpSingleton.m_prodpAggregated;
                }
                if (sGAVersion.equals(sProductGAVersion)) {
                    ProductPlugin.m_prodpSingleton.m_prodpAggregated = element;
                    return ProductPlugin.m_prodpSingleton.m_prodpAggregated;
                }
            }
            ++n2;
        }
        throw new NoProductPluginFoundException(PakCoreMessages.PAK_CORE_S_NO_SELECTED_PRODUCT_PLUGIN);
    }

    public static void cacheAggregatedProductPlugin() {
        m_prodpCachedAggregated = ProductPlugin.m_prodpSingleton.m_prodpAggregated;
    }

    public static void setProductPluginBackToTheCachedOne() {
        if (m_prodpCachedAggregated != null) {
            ProductPlugin.m_prodpSingleton.m_prodpAggregated = m_prodpCachedAggregated;
            m_prodpCachedAggregated = null;
        }
    }

    public String getProductcurrentversion() {
        return this.m_prodpAggregated.getProductcurrentversion();
    }

    public String getAllinstalledproductfeatures() throws IOException {
        return this.m_prodpAggregated.getAllinstalledproductfeatures();
    }

    public String getProductgaversion() {
        return this.m_prodpAggregated.getProductgaversion();
    }

    @Override
    public void init() {
        super.init();
        if (!this.getClass().getName().equals(S_PRODUCT_PLUGIN_CLASS)) {
            return;
        }
        try {
            this.initAggregatedAndAvailableProductPlugins();
        }
        catch (Exception e) {
            Logr.warn(className, "init", e.getMessage(), e);
            this.m_prodpAggregated = null;
        }
    }

    public String getBackuppath() {
        return this.m_prodpAggregated.getBackuppath();
    }

    public String getOffering() {
        return this.m_prodpAggregated.getOffering();
    }

    public String getProductOfferingName() {
        return this.m_prodpAggregated.getParamValue(S_OFFERINGNAME_PARAM);
    }

    public static String getProductOfferingName(String sOffering) {
        if (m_prodpSingleton == null) {
            throw new RuntimeException(PakCoreMessages.PAK_CORE_S_NO_SELECTED_PRODUCT_PLUGIN);
        }
        return m_prodpSingleton.getProductOfferingNameFromOfferingID(sOffering);
    }

    public static String getCurrentProductOfferingVersion() {
        if (m_prodpSingleton == null) {
            throw new RuntimeException(PakCoreMessages.PAK_CORE_S_NO_SELECTED_PRODUCT_PLUGIN);
        }
        return m_prodpSingleton.getProductcurrentversion();
    }

    public final boolean isSelectedProductSupported() {
        return this.m_prodpAggregated != null;
    }

    @Override
    public String getAttributeValue(String sAttributeName) {
        try {
            String sMethodName = S_GET + sAttributeName.substring(0, 1).toUpperCase() + sAttributeName.substring(1);
            Method methodGetThisAttribute = this.m_prodpAggregated.getClass().getMethod(sMethodName, new Class[0]);
            String sReturn = (String)methodGetThisAttribute.invoke((Object)this.m_prodpAggregated, new Object[0]);
            return sReturn;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    protected boolean isTheGivenProductInstalledAtTheGivenLocation() {
        return true;
    }

    @Override
    protected String[] getRequiredParams() {
        return AS_EMPTY;
    }

    @Override
    protected String[] getOptionalParams() {
        return AS_OPTIONAL_PARAMS;
    }

    private String getProductOfferingNameFromOfferingID(String sOfferingID) {
        ProductPlugin[] productPluginArray = this.m_aprodpAvailable;
        int n = this.m_aprodpAvailable.length;
        int n2 = 0;
        while (n2 < n) {
            ProductPlugin element = productPluginArray[n2];
            if (element.getOffering().equals(sOfferingID)) {
                return element.getParamValue(S_OFFERINGNAME_PARAM);
            }
            ++n2;
        }
        return sOfferingID;
    }

    private void initAggregatedAndAvailableProductPlugins() throws IllegalAccessException, IOException, ClassNotFoundException, InstantiationException, SAXException, ParserConfigurationException {
        m_prodpSingleton = this;
        NIFPlugin[] anifp = NIFPlugin.createPlugins(this.getPluginDefinitionDocument(), this.getPathToAggregatedPlugins(), this.getInstallToolkitBridge());
        NIFPluginUtils.enforceAllThesePluginsAssignableFromThisClass(this.getClass(), anifp);
        this.m_aprodpAvailable = new ProductPlugin[anifp.length];
        Vector<ProductPlugin> vprodpFound = new Vector<ProductPlugin>();
        int i = 0;
        while (i < anifp.length) {
            ProductPlugin prodpThis;
            this.m_aprodpAvailable[i] = prodpThis = (ProductPlugin)anifp[i];
            if (prodpThis.isTheGivenProductInstalledAtTheGivenLocation()) {
                vprodpFound.addElement(prodpThis);
                this.m_prodpAggregated = prodpThis;
            }
            ++i;
        }
        this.m_aprodpFound = new ProductPlugin[vprodpFound.size()];
        i = 0;
        while (i < vprodpFound.size()) {
            this.m_aprodpFound[i] = (ProductPlugin)vprodpFound.elementAt(i);
            ++i;
        }
    }

    private String getPathToAggregatedPlugins() {
        String sPath = this.getParamValue(S_AGGREGATED_PLUGIN_PATH_PARAM);
        if (sPath == null) {
            sPath = "install-package/applicable-products/product";
        }
        return sPath;
    }
}

