/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.macroresolvers;

import com.ibm.ws.pak.internal.install.metadata.NIFStack;
import com.ibm.ws.pak.internal.utils.URIUtils;
import com.ibm.ws.pak.internal.utils.componentactions.UninstallCommonComponentInfo;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import com.ibm.ws.pak.internal.utils.macroresolvers.MacroResolver;
import com.ibm.ws.pak.internal.utils.product.ProductPlugin;
import org.w3c.dom.Document;

public class UninstallableCommonComponentPakListMacroResolver
extends MacroResolver {
    private static final String S_UNINSTALLABLECCPAKLIST_MACRO_ID = "UninstallableCCPAKList";
    private static final String COMMA = ",";
    private static final String className = "UninstallableCommonComponentPakListMacroResolver";

    @Override
    protected boolean isMacroIDAcceptable(String sMacroID) {
        return S_UNINSTALLABLECCPAKLIST_MACRO_ID.equals(sMacroID);
    }

    @Override
    protected String resolveMacro(String sMacroID, String sMacroText, Document documentPluginDefinitions) {
        Logr.methodEntry(className, "resolveMacro");
        String[] arg = sMacroText.split(COMMA);
        String commonComponentRequires = arg[0];
        String currentProductPrimaryPakName = arg[1];
        String ret = sMacroText;
        try {
            if (!NIFStack.isOpen()) {
                FileSystemEntry fseBackupPath = new FileSystemEntry(URIUtils.convertPathToURI(ProductPlugin.getCurrentBackupPath(), this.getInstallToolkitBridge()), this.getInstallToolkitBridge());
                NIFStack.open(fseBackupPath, this.getInstallToolkitBridge());
            }
            UninstallCommonComponentInfo uninstallCCInfo = UninstallCommonComponentInfo.getUninstallCommonComponentInfoInstance(NIFStack.getAllNIFStackElements(), commonComponentRequires, currentProductPrimaryPakName);
            ret = uninstallCCInfo.getAllUninstallableCommonComponentBackupPaksURIs();
        }
        catch (Exception e) {
            Logr.warn(className, "resolveMacro", e.getMessage(), e);
            e.printStackTrace();
        }
        Logr.methodReturn(className, "resolveMacro", ret);
        return ret;
    }
}

