/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.macroresolvers;

import com.ibm.ws.pak.internal.utils.logging.Logr;
import com.ibm.ws.pak.internal.utils.macroresolvers.MacroResolver;
import com.ibm.ws.pak.internal.utils.macroresolvers.PathToBaseNameMacroResolver;
import java.io.IOException;
import java.net.URISyntaxException;
import org.w3c.dom.Document;

public class PathToBaseNameNoExtensionMacroResolver
extends PathToBaseNameMacroResolver {
    private static final String S_MACRO_ID = "NIFBASENAMENOEXTENSION";
    private static final String[] AS_REQUIRED_PARAMS = new String[0];
    private static final String S_DOT = ".";
    private static final String className = "PathToBaseNameNoExtensionMacroResolver";

    @Override
    protected boolean isMacroIDAcceptable(String sMacroID) {
        return S_MACRO_ID.equals(sMacroID);
    }

    @Override
    protected String[] getRequiredParams() {
        return AS_REQUIRED_PARAMS;
    }

    @Override
    protected String resolveMacro(String sMacroID, String sMacroText, Document documentPluginDefinitions) {
        Logr.methodEntry(className, "resolveMacro");
        try {
            String sBaseName = super.resolveMacroRaw(sMacroID, sMacroText, documentPluginDefinitions);
            String s = sBaseName.substring(0, sBaseName.lastIndexOf(S_DOT));
            Logr.methodReturn(className, "resolveMacro", s);
            return s;
        }
        catch (IOException iOException) {
            String s = MacroResolver.getUnresolvedMacro(sMacroID, sMacroText);
            Logr.methodReturn(className, "resolveMacro", s);
            return s;
        }
        catch (URISyntaxException uRISyntaxException) {
            String s = MacroResolver.getUnresolvedMacro(sMacroID, sMacroText);
            Logr.methodReturn(className, "resolveMacro", s);
            return s;
        }
    }
}

