/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.macroresolvers;

import com.ibm.ws.pak.internal.utils.logging.Logr;
import com.ibm.ws.pak.internal.utils.macroresolvers.MacroResolver;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Document;

public class NIFResourceBundleMacroResolver
extends MacroResolver {
    private static final String S_RESOURCEBUNDLE_ATTRIBUTE_MACRO_ID = "L";
    private static final String S_COMMA = ",";
    private static final String className = "NIFResourceBundleMacroResolver";

    @Override
    protected boolean isMacroIDAcceptable(String sMacroID) {
        return S_RESOURCEBUNDLE_ATTRIBUTE_MACRO_ID.equals(sMacroID);
    }

    @Override
    protected String resolveMacro(String sMacroID, String sMacroText, Document documentPluginDefinitions) {
        Logr.methodEntry(className, "resolveMacro");
        try {
            StringTokenizer st = new StringTokenizer(sMacroText, S_COMMA);
            String sResourceBundleName = st.nextToken().trim();
            String sKey = st.nextToken().trim();
            Vector<String> vsParams = new Vector<String>();
            while (st.hasMoreTokens()) {
                vsParams.add(st.nextToken().trim());
            }
            Object[] asParams = vsParams.toArray(new String[vsParams.size()]);
            ResourceBundle resourcebundleWS = ResourceBundle.getBundle(sResourceBundleName);
            String sString = resourcebundleWS.getString(sKey);
            if (asParams.length > 0) {
                sString = MessageFormat.format(sString, asParams);
            }
            Logr.methodReturn(className, "resolveMacro", sString);
            return sString;
        }
        catch (Throwable throwable) {
            Logr.methodReturn(className, "resolveMacro", sMacroText);
            return sMacroText;
        }
    }
}

