/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.macroresolvers;

import com.ibm.ws.pak.internal.NIFPlugin;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import com.ibm.ws.pak.internal.utils.macroresolvers.MacroResolver;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;

public class NIFPluginAttributeMacroResolver
extends MacroResolver {
    private static final String S_NIFP_ATTRIBUTE_MACRO_ID = "NIFP";
    private static final Pattern PATTERN_NIFP_ATTRIBUTE = Pattern.compile("^(.+?)\\.(.+?)$");
    private static final int N_PLUGIN_ID_GROUP = 1;
    private static final int N_PLUGIN_ATTRIBUTE_GROUP = 2;
    private static final String className = "NIFPluginAttributeMacroResolver";

    @Override
    protected boolean isMacroIDAcceptable(String sMacroID) {
        return S_NIFP_ATTRIBUTE_MACRO_ID.equals(sMacroID);
    }

    @Override
    protected String resolveMacro(String sMacroID, String sMacroText, Document documentPluginDefinitions) {
        Logr.methodEntry(className, "resolveMacro");
        Matcher matcherNIFPAttribute = PATTERN_NIFP_ATTRIBUTE.matcher(sMacroText);
        if (!matcherNIFPAttribute.matches()) {
            String s = MacroResolver.getUnresolvedMacro(S_NIFP_ATTRIBUTE_MACRO_ID, sMacroText);
            Logr.methodReturn(className, "resolveMacro", s);
            return s;
        }
        String sPluginID = matcherNIFPAttribute.group(1);
        String sAttributeName = matcherNIFPAttribute.group(2);
        NIFPlugin nifpThis = NIFPlugin.getCachedPlugin(sPluginID, documentPluginDefinitions, this.getInstallToolkitBridge());
        if (nifpThis == null) {
            String s = MacroResolver.getUnresolvedMacro(S_NIFP_ATTRIBUTE_MACRO_ID, sMacroText);
            Logr.methodReturn(className, "resolveMacro", s);
            return s;
        }
        String s = nifpThis.getAttributeValue(sAttributeName);
        Logr.methodReturn(className, "resolveMacro", s);
        return s;
    }
}

