/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.macroresolvers;

import com.ibm.ws.pak.internal.utils.logging.Logr;
import com.ibm.ws.pak.internal.utils.macroresolvers.MacroResolver;
import java.util.regex.Pattern;
import org.w3c.dom.Document;

public class MatchConditionMacroResolver
extends MacroResolver {
    private static final String S_MACRO_ID = "MATCH";
    private static final String S_TOKEN_SEPARATOR = ";";
    private static final String className = "MatchConditionMacroResolver";

    @Override
    protected boolean isMacroIDAcceptable(String sMacroID) {
        return S_MACRO_ID.equals(sMacroID);
    }

    @Override
    protected String resolveMacro(String sMacroID, String sMacroText, Document documentPluginDefinitions) {
        Logr.methodEntry(className, "resolveMacro");
        if (sMacroText == null || sMacroText.trim().length() == 0) {
            Logr.methodReturn(className, "resolveMacro", "false");
            return Boolean.FALSE.toString();
        }
        int nIndexOfTokenSeparator = sMacroText.indexOf(S_TOKEN_SEPARATOR);
        if (nIndexOfTokenSeparator < 0) {
            Logr.methodReturn(className, "resolveMacro", "false");
            return Boolean.FALSE.toString();
        }
        String sToken = sMacroText.substring(0, nIndexOfTokenSeparator);
        if (sToken == null) {
            Logr.methodReturn(className, "resolveMacro", "false");
            return Boolean.FALSE.toString();
        }
        sToken = sToken.trim();
        String sRegexp = sMacroText.substring(nIndexOfTokenSeparator + 1).trim();
        if (sRegexp == null || sRegexp.trim().length() == 0) {
            Logr.methodReturn(className, "resolveMacro", "false");
            return Boolean.FALSE.toString();
        }
        String sReturn = new Boolean(Pattern.matches(sRegexp, sToken)).toString();
        Logr.methodReturn(className, "resolveMacro", sReturn);
        return sReturn;
    }
}

