/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.macroresolvers;

import com.ibm.ws.pak.internal.install.metadata.MaintenanceInfoPlugin;
import com.ibm.ws.pak.internal.utils.StringUtils;
import com.ibm.ws.pak.internal.utils.XMLUtils;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import com.ibm.ws.pak.internal.utils.macroresolvers.MacroResolver;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class GetPackageNamesMacroResolver
extends MacroResolver {
    private static final String S_GETPACKAGENAMES_ATTRIBUTE_MACRO_ID = "NIFPACKAGENAMES";
    private static final String S_EMPTY = "";
    private static final String className = "GetPackageNamesMacroResolver";

    @Override
    protected boolean isMacroIDAcceptable(String sMacroID) {
        return S_GETPACKAGENAMES_ATTRIBUTE_MACRO_ID.equals(sMacroID);
    }

    @Override
    protected String resolveMacro(String sMacroID, String sMacroText, Document documentPluginDefinitions) {
        String[] asURIs = StringUtils.convertStringToTokenArray(sMacroText, ";");
        try {
            return this.getPackageNames(asURIs);
        }
        catch (Throwable throwable) {
            return sMacroText;
        }
    }

    private String getPackageNames(String[] asURIs) throws IOException, URISyntaxException, IllegalAccessException, SAXException, ParserConfigurationException, InstantiationException, ClassNotFoundException {
        String sReturn = S_EMPTY;
        int i = 0;
        while (i < asURIs.length) {
            String sNameThis = this.getPackageName(asURIs[i]);
            if (sNameThis != null) {
                sReturn = String.valueOf(sReturn) + this.getPackageName(asURIs[i]);
                if (i < asURIs.length - 1) {
                    sReturn = String.valueOf(sReturn) + ";";
                }
            }
            ++i;
        }
        return sReturn;
    }

    private String getPackageName(String sURI) throws IOException, URISyntaxException, IllegalAccessException, SAXException, ParserConfigurationException, InstantiationException, ClassNotFoundException {
        Logr.methodEntry(className, "resolveMacro");
        FileSystemEntry fseThis = new FileSystemEntry(new URI(sURI), "maintenance.xml", this.getInstallToolkitBridge());
        if (!fseThis.exists()) {
            Logr.methodReturn(className, "resolveMacro", "null");
            return null;
        }
        MaintenanceInfoPlugin mipThisPackage = MaintenanceInfoPlugin.getMaintenanceInfoPlugin(XMLUtils.getSimpleXMLParserFromFileSystemEntry(fseThis).getDocument(), this.getInstallToolkitBridge());
        Logr.methodReturn(className, "resolveMacro", mipThisPackage.getName());
        return mipThisPackage.getName();
    }
}

