/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.filesystems;

import com.ibm.ws.pak.internal.NIFConstants;
import com.ibm.ws.pak.internal.utils.fileactions.ZIPFileOperation;
import com.ibm.ws.pak.internal.utils.filesystems.ExecEngine;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystem;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemNotSupportedException;
import com.ibm.ws.pak.internal.utils.filesystems.PlatformConstants;
import com.ibm.ws.pak.internal.utils.filesystems.UnclosableZIPOutputStream;
import com.ibm.ws.pak.internal.utils.installtoolkitbridge.InstallToolkitBridgeException;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class ZIPFileSystem
extends FileSystem {
    private final Vector m_vuziposCached = new Vector();
    private final Hashtable m_hashtableZipFilesCached = new Hashtable();
    public static final String S_ZIP_FS_SCHEME = "zip";
    private static final String S_TEMP_FILE_PREFIX = ".~$";
    private static final String S_ZIP = "zip";
    private static final String S_UTF_8 = "UTF-8";
    private static final String S_EMPTY = "";
    private static final String S_OPERATION_NOT_SUPPORTED = "Operation not supported for ZIPFileSystem.";
    private static final String S_DELETE_ENTRY_ON_EXIT_NOT_SUPPORTED = "Operation not supported for ZIPFileSystem for internal ZIP entries.";
    private static final String S_DELETE_FAILED = "Failed to delete: ";
    private static final String S_ZIPENTRY_OBJECT = "zipentryobject";
    private static final String S_ZIPINPUTSTREAM_OBJECT = "zipinputstreamobject";
    private static final String S_FILE_NOT_FOUND = "File not found: ";
    private static final String S_ATTRIB_COMMAND = "attrib";
    private static final String S_ATTR_HIDDEN = "+h";
    private static final String S_DISK_FS_SCHEME = "file";
    private static final String S_INVALID_FS_FOR_SYMLINK_ATTEMPT = "Invalid filesystem for symbolic link attempt or host and target filesystems don't match.";
    private static final String S_SOFTLINK_OPTION = "-s";
    private static final String S_FORCE_OPTION = "-f";
    private static final String S_LN_LOCATION_1 = "/bin/ln";
    private static final String S_LN_LOCATION_2 = "/usr/bin/ln";
    private static final String S_NO_LN_1 = "Symbolic linking ";
    private static final String S_NO_LN_2 = "->";
    private static final String S_NO_LN_3 = " failed as ln command was not found.";
    private static final String S_GENERIC_FAILURE_1 = "Symbolic linking ";
    private static final String S_GENERIC_FAILURE_2 = "->";
    private static final String S_GENERIC_FAILURE_3 = " failed.  Standard Error : ";
    private static final int N_LN_SUCCESS_CODE = 0;
    private static final String S_DOT_TMP = ".tmp";
    private static final String className = "ZIPFileSystem";

    public void performAllZIPOperationsForThisTargetFile(URI uriTargetFile, Vector vZIPFileOperations) throws IOException {
        if (vZIPFileOperations == null || vZIPFileOperations.size() == 0) {
            return;
        }
        this.reinitThisFSForReading(uriTargetFile);
        File fTargetFile = new File(uriTargetFile.getPath());
        File fTargetFileTmp = this.createTempFileForThisFile(fTargetFile);
        ZipOutputStream zipoutputstreamTargetTmp = new ZipOutputStream(new FileOutputStream(fTargetFileTmp));
        ZipFile zipfileTarget = this.getZipFileForReading(uriTargetFile);
        this.moveAllEntriesFromThisZipFileToAnotherOneUnlessItIsToBeUpdated(zipfileTarget, zipoutputstreamTargetTmp, vZIPFileOperations);
        this.ensureThisZipFileClosed(fTargetFile);
        try {
            this.applyZIPFileOperationsToZIPFile(vZIPFileOperations, zipoutputstreamTargetTmp);
        }
        catch (Exception e) {
            Logr.warn(className, "performAllZIPOperationsForThisTargetFile", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
        zipoutputstreamTargetTmp.flush();
        zipoutputstreamTargetTmp.close();
        this.ensureThisZipFileClosed(fTargetFileTmp);
        this.moveFile(fTargetFileTmp, fTargetFile);
    }

    @Override
    public long getSize(URI uriPath) throws IOException {
        if (ZIPFileSystem.isEntireFSBeingTargetted(uriPath)) {
            return ZIPFileSystem.getFileContainerForThisFS(uriPath).length();
        }
        Hashtable hashtableThisEntry = this.getZIPEntryForThisURI(uriPath);
        ZipEntry zipentryThis = (ZipEntry)hashtableThisEntry.get(S_ZIPENTRY_OBJECT);
        ZipInputStream inThis = (ZipInputStream)hashtableThisEntry.get(S_ZIPINPUTSTREAM_OBJECT);
        long nReturn = zipentryThis.getSize();
        inThis.close();
        return nReturn;
    }

    @Override
    public void setLastModifiedTime(URI uriPath, long lTime) throws IOException {
        if (ZIPFileSystem.isEntireFSBeingTargetted(uriPath)) {
            ZIPFileSystem.getFileContainerForThisFS(uriPath).setLastModified(lTime);
        } else {
            Hashtable hashtableThisEntry = this.getZIPEntryForThisURI(uriPath);
            ZipEntry zipentryThis = (ZipEntry)hashtableThisEntry.get(S_ZIPENTRY_OBJECT);
            ZipInputStream inThis = (ZipInputStream)hashtableThisEntry.get(S_ZIPINPUTSTREAM_OBJECT);
            zipentryThis.setTime(lTime);
            inThis.close();
        }
    }

    @Override
    public InputStream readEntry(URI uriPath) throws IOException {
        if (ZIPFileSystem.isEntireFSBeingTargetted(uriPath)) {
            return new FileInputStream(ZIPFileSystem.getFileContainerForThisFS(uriPath));
        }
        ZipFile zipfileThis = this.getZipFileForReading(uriPath);
        ZipEntry zipEntry = zipfileThis.getEntry(ZIPFileSystem.getEntryPathForThisURI(uriPath));
        if (zipEntry == null) {
            return null;
        }
        return zipfileThis.getInputStream(zipEntry);
    }

    @Override
    public OutputStream writeEntry(URI uriPath) throws IOException {
        if (ZIPFileSystem.isEntireFSBeingTargetted(uriPath)) {
            return new FileOutputStream(ZIPFileSystem.getFileContainerForThisFS(uriPath));
        }
        File fileContainer = ZIPFileSystem.getFileContainerForThisFS(uriPath);
        this.ensureThisZipFileClosed(fileContainer);
        ZipOutputStream zipoutputstreamThis = this.getZIPOutputStreamForAddingNewEntries(uriPath);
        zipoutputstreamThis.putNextEntry(new ZipEntry(ZIPFileSystem.getEntryPathForThisURI(uriPath)));
        return zipoutputstreamThis;
    }

    @Override
    public OutputStream writeEntry(URI uriPath, boolean fAppend) throws IOException {
        if (ZIPFileSystem.isEntireFSBeingTargetted(uriPath)) {
            if (!ZIPFileSystem.getFileContainerForThisFS(uriPath).exists()) {
                ZIPFileSystem.getFileContainerForThisFS(uriPath).getParentFile().mkdirs();
            }
            return new FileOutputStream(ZIPFileSystem.getFileContainerForThisFS(uriPath), fAppend);
        }
        if (!fAppend) {
            return this.writeEntry(uriPath);
        }
        File fileContainer = ZIPFileSystem.getFileContainerForThisFS(uriPath);
        this.ensureThisZipFileClosed(fileContainer);
        InputStream in = null;
        try {
            in = this.readEntry(uriPath);
        }
        catch (IOException iOException) {
            return this.writeEntry(uriPath);
        }
        File fileTemp = this.transferCurrentInputStreamToATempFile(in);
        this.deleteEntry(uriPath);
        OutputStream outReturn = this.transferContentsOfGivenTemporaryFileToGivenZIPEntry(uriPath, fileTemp);
        return outReturn;
    }

    @Override
    public void deleteEntry(URI uriPath) throws IOException {
        this.ensureThisZipFileClosed(ZIPFileSystem.getFileContainerForThisFS(uriPath));
        if (ZIPFileSystem.isEntireFSBeingTargetted(uriPath)) {
            if (!ZIPFileSystem.getFileContainerForThisFS(uriPath).delete() && ZIPFileSystem.getFileContainerForThisFS(uriPath).exists()) {
                throw new IOException(S_DELETE_FAILED + uriPath);
            }
            return;
        }
        this.reinitThisFSForReading(uriPath);
        File fileTmpDir = this.getUnifiedFileIOObject().createTempDir();
        this.extractThisZIPFileToThisDir(ZIPFileSystem.getFileContainerForThisFS(uriPath), fileTmpDir);
        if (!new File(fileTmpDir, ZIPFileSystem.getEntryPathForThisURI(uriPath)).delete()) {
            throw new IOException(S_DELETE_FAILED + uriPath);
        }
        File fileTmpZIP = File.createTempFile(S_TEMP_FILE_PREFIX, "zip");
        boolean fZipFileCreated = this.zipThisDirectoryToThisZIPFile(fileTmpDir, fileTmpZIP);
        new FileSystemEntry(fileTmpDir.toURI(), this.getInstallToolkitBridge()).deleteThisDirectoryRecursively();
        if (fZipFileCreated) {
            this.ensureThisZipFileClosed(ZIPFileSystem.getFileContainerForThisFS(uriPath));
            this.moveFile(fileTmpZIP, ZIPFileSystem.getFileContainerForThisFS(uriPath));
        } else {
            fileTmpZIP.deleteOnExit();
            if (!ZIPFileSystem.getFileContainerForThisFS(uriPath).delete()) {
                throw new IOException(S_DELETE_FAILED + ZIPFileSystem.getFileContainerForThisFS(uriPath).toString());
            }
        }
    }

    @Override
    public void deleteEntryOnExit(URI uriPath) throws IOException {
        this.ensureThisZipFileClosed(ZIPFileSystem.getFileContainerForThisFS(uriPath));
        if (ZIPFileSystem.isEntireFSBeingTargetted(uriPath)) {
            ZIPFileSystem.getFileContainerForThisFS(uriPath).deleteOnExit();
            return;
        }
        throw new IOException(S_DELETE_ENTRY_ON_EXIT_NOT_SUPPORTED);
    }

    @Override
    public void setPermissions(URI uriPath, int nPermissions) throws IOException {
        if (ZIPFileSystem.isEntireFSBeingTargetted(uriPath)) {
            this.setParentFSPermissions(uriPath, nPermissions);
        } else {
            Hashtable hashtableThisEntry = this.getZIPEntryForThisURI(uriPath);
            ZipEntry zipentryThis = (ZipEntry)hashtableThisEntry.get(S_ZIPENTRY_OBJECT);
            ZipInputStream inThis = (ZipInputStream)hashtableThisEntry.get(S_ZIPINPUTSTREAM_OBJECT);
            zipentryThis.setExtra(Integer.toString(nPermissions).getBytes(S_UTF_8));
            inThis.close();
        }
    }

    @Override
    public int getPermissions(URI uriPath) throws IOException {
        if (ZIPFileSystem.isEntireFSBeingTargetted(uriPath)) {
            return this.getParentFSPermissions(uriPath);
        }
        Hashtable hashtableThisEntry = this.getZIPEntryForThisURI(uriPath);
        ZipEntry zipentryThis = (ZipEntry)hashtableThisEntry.get(S_ZIPENTRY_OBJECT);
        ZipInputStream inThis = (ZipInputStream)hashtableThisEntry.get(S_ZIPINPUTSTREAM_OBJECT);
        String sPermissions = new String(zipentryThis.getExtra(), S_UTF_8);
        inThis.close();
        try {
            return Integer.parseInt(sPermissions);
        }
        catch (NumberFormatException e) {
            Logr.warn(className, "getPermissions", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void createSymbolicLink(URI uriSymbolicLinkPath, String sPathToLinkTo) throws IOException {
        if (!ZIPFileSystem.isEntireFSBeingTargetted(uriSymbolicLinkPath)) {
            throw new IOException(S_OPERATION_NOT_SUPPORTED);
        }
        this.createFSSymbolicLink(uriSymbolicLinkPath, sPathToLinkTo);
    }

    @Override
    public long getLastModified(URI uriPath) throws IOException {
        Hashtable hashtableThisEntry = this.getZIPEntryForThisURI(uriPath);
        ZipEntry zipentryThis = (ZipEntry)hashtableThisEntry.get(S_ZIPENTRY_OBJECT);
        ZipInputStream inThis = (ZipInputStream)hashtableThisEntry.get(S_ZIPINPUTSTREAM_OBJECT);
        long lLastModified = zipentryThis.getTime();
        inThis.close();
        return lLastModified;
    }

    @Override
    public URI getFSURI(URI uriParent, String sEntryPath) throws URISyntaxException {
        String sExistingPath;
        String sPathReturn = null;
        sPathReturn = ZIPFileSystem.getEntryPathForThisURI(uriParent) != null ? ((sExistingPath = ZIPFileSystem.getEntryPathForThisURI(uriParent)).endsWith("/") ? String.valueOf(sExistingPath) + sEntryPath : String.valueOf(sExistingPath) + "/" + sEntryPath) : sEntryPath;
        URI uriFS = ZIPFileSystem.getFSURIForThisEntry(uriParent);
        return ZIPFileSystem.getURIGivenFSURIAndEntryPath(uriFS, sPathReturn);
    }

    @Override
    public boolean exists(URI uriPath) {
        InputStream inputstreamThis;
        boolean fNeedCloseZipFile;
        File fContainer;
        block17: {
            ZipEntry zipEntry;
            ZipFile zipfileThis;
            block16: {
                String sEntryPath;
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                fContainer = ZIPFileSystem.getFileContainerForThisFS(uriPath);
                                if (fContainer.exists()) break block12;
                                return false;
                            }
                            if (!ZIPFileSystem.isEntireFSBeingTargetted(uriPath)) break block13;
                            return true;
                        }
                        fNeedCloseZipFile = !this.hasThisZipFileContainerBeenCached(uriPath);
                        zipfileThis = this.getZipFileForReading(uriPath);
                        if (zipfileThis != null) break block14;
                        return false;
                    }
                    sEntryPath = ZIPFileSystem.getEntryPathForThisURI(uriPath);
                    if (sEntryPath != null) break block15;
                    return false;
                }
                zipEntry = zipfileThis.getEntry(sEntryPath);
                if (zipEntry != null) break block16;
                return false;
            }
            inputstreamThis = zipfileThis.getInputStream(zipEntry);
            if (inputstreamThis == null || inputstreamThis.available() == 0) break block17;
            inputstreamThis.close();
            if (fNeedCloseZipFile) {
                this.ensureThisZipFileClosed(fContainer);
            }
            return true;
        }
        try {
            if (inputstreamThis != null) {
                inputstreamThis.close();
            }
            if (fNeedCloseZipFile) {
                this.ensureThisZipFileClosed(fContainer);
            }
            return false;
        }
        catch (ZipException zipException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public boolean isDirectory(URI uriPath) {
        return uriPath.toString().endsWith("/");
    }

    @Override
    public void mkdirs(URI uriPath) throws IOException {
        ZipOutputStream zipoutputstreamThis = this.getZIPOutputStreamForAddingNewEntries(uriPath);
        String sZIPEntryPath = ZIPFileSystem.getEntryPathForThisURI(uriPath);
        if (!sZIPEntryPath.substring(sZIPEntryPath.length() - 1).equals("/")) {
            sZIPEntryPath = String.valueOf(sZIPEntryPath) + "/";
        }
        zipoutputstreamThis.putNextEntry(new ZipEntry(sZIPEntryPath));
        zipoutputstreamThis.close();
    }

    @Override
    public URI getParent(URI uriPath) throws IOException {
        if (ZIPFileSystem.getEntryPathForThisURI(uriPath) != null) {
            String sPathThis = ZIPFileSystem.getEntryPathForThisURI(uriPath);
            try {
                String sParentPath = null;
                sParentPath = sPathThis.indexOf("/") != -1 ? String.valueOf(sPathThis.substring(0, sPathThis.lastIndexOf("/"))) + "/" : "/";
                return ZIPFileSystem.getURIGivenFSURIAndEntryPath(ZIPFileSystem.getFSURIForThisEntry(uriPath), sParentPath);
            }
            catch (URISyntaxException e) {
                Logr.warn(className, "copyThisEntryInThisSourceToThisZipFileWithThisName", e.getMessage(), e);
                throw new IOException(e.getMessage());
            }
        }
        return uriPath;
    }

    @Override
    public URI getParentDirOrFSRoot(URI uriPath) throws IOException {
        if (ZIPFileSystem.getEntryPathForThisURI(uriPath) != null) {
            String sPathThis = ZIPFileSystem.getEntryPathForThisURI(uriPath);
            if (sPathThis.endsWith("/")) {
                sPathThis = sPathThis.substring(0, sPathThis.length() - "/".length());
            }
            try {
                String sParentPath = null;
                if (sPathThis.indexOf("/") != -1) {
                    sParentPath = String.valueOf(sPathThis.substring(0, sPathThis.lastIndexOf("/"))) + "/";
                    return ZIPFileSystem.getURIGivenFSURIAndEntryPath(ZIPFileSystem.getFSURIForThisEntry(uriPath), sParentPath);
                }
                return new URI(uriPath.getScheme(), uriPath.getAuthority(), uriPath.getPath(), uriPath.getQuery(), null);
            }
            catch (URISyntaxException e) {
                Logr.warn(className, "getParent", e.getMessage(), e);
                throw new IOException(e.getMessage());
            }
        }
        return uriPath;
    }

    @Override
    public String getEntryName(URI uriPath) {
        if (ZIPFileSystem.getEntryPathForThisURI(uriPath) != null) {
            String sPathThis = ZIPFileSystem.getEntryPathForThisURI(uriPath);
            if (sPathThis.indexOf("/") != -1) {
                String sEntryName = sPathThis.substring(sPathThis.lastIndexOf("/"));
                return sEntryName;
            }
            return sPathThis;
        }
        return ZIPFileSystem.getFileContainerForThisFS(uriPath).getName();
    }

    @Override
    public String getCanonicalPath(URI uriPath) throws IOException {
        return new File(uriPath.getPath()).getCanonicalPath();
    }

    @Override
    public String getAbsolutePath(URI uriPath) {
        return new File(uriPath.getPath()).getAbsolutePath();
    }

    @Override
    public String getAbsolutePathWithFlagment(URI uriPath) {
        String sReturn = this.getAbsolutePath(uriPath);
        String sFragment = uriPath.getFragment();
        if (sFragment != null && !sFragment.equals(S_EMPTY)) {
            if (!sReturn.endsWith("#")) {
                sReturn = String.valueOf(sReturn) + "#";
            }
            sReturn = String.valueOf(sReturn) + sFragment;
        }
        return sReturn;
    }

    @Override
    public void renameTo(URI uriPath, URI uriPathTo) throws IOException {
        this.copyTo(uriPath, uriPathTo);
        this.deleteEntry(uriPath);
    }

    @Override
    public URI[] getDirectoryEntries(URI uriPath) {
        return this.getDirectoryEntries(uriPath, false);
    }

    public URI[] getDirectoryEntries(URI uriPath, boolean fDirectChildrenOnly) {
        try {
            ZipFile zipfileThis = this.getZipFileForReading(uriPath);
            Enumeration<? extends ZipEntry> enumerationZipEntries = zipfileThis.entries();
            String sPathThis = ZIPFileSystem.getEntryPathForThisURI(uriPath);
            if (sPathThis == null) {
                sPathThis = S_EMPTY;
            }
            if (!sPathThis.endsWith("/")) {
                sPathThis = String.valueOf(sPathThis) + "/";
            }
            if (!sPathThis.startsWith("/")) {
                sPathThis = "/" + sPathThis;
            }
            Vector<URI> vuris = new Vector<URI>();
            while (enumerationZipEntries.hasMoreElements()) {
                ZipEntry zipentryThis = enumerationZipEntries.nextElement();
                String sPathThisEntry = zipentryThis.getName();
                if (!sPathThisEntry.startsWith("/")) {
                    sPathThisEntry = "/" + sPathThisEntry;
                }
                if (!sPathThisEntry.startsWith(sPathThis) || sPathThisEntry.equals(sPathThis) || fDirectChildrenOnly && !this.isDirectChildren(sPathThis, sPathThisEntry)) continue;
                vuris.add(new URI(uriPath.getScheme(), uriPath.getAuthority(), uriPath.getPath(), null, sPathThisEntry));
            }
            URI[] auris = new URI[vuris.size()];
            int i = 0;
            while (i < vuris.size()) {
                auris[i] = (URI)vuris.elementAt(i);
                ++i;
            }
            return auris;
        }
        catch (ZipException zipException) {
            return new URI[0];
        }
        catch (IOException iOException) {
            return new URI[0];
        }
        catch (URISyntaxException uRISyntaxException) {
            return new URI[0];
        }
    }

    @Override
    public URI[] getEntriesDirectlyUnderThisDir(URI uriPath) {
        return this.getDirectoryEntries(uriPath, true);
    }

    @Override
    public String getSymbolicLinkTarget(URI uriPath) throws IOException {
        throw new IOException(S_OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void flushFileSystemFor(URI uriPath) throws IOException {
        this.reinitThisFSForReading(uriPath);
    }

    @Override
    public void setHidden(URI uriPath) {
        if (ZIPFileSystem.isEntireFSBeingTargetted(uriPath) && PlatformConstants.isCurrentPlatformWindows()) {
            String sPath = new File(uriPath).getAbsolutePath();
            String[] asCommandArguments = new String[]{S_ATTRIB_COMMAND, S_ATTR_HIDDEN, sPath};
            ExecEngine eeThis = new ExecEngine();
            eeThis.executeIncomingArgumentsAsync(asCommandArguments);
        }
    }

    @Override
    public void copyThisEntryInThisSourceToThisZipFileWithThisName(URI uriSourceFile, String sSourceEntryName, ZipOutputStream zopTo, String sTargetEntryName) throws IOException {
        try {
            ZipFile zipfileSource = this.getZipFileForReading(uriSourceFile);
            ZipEntry zipentrySource = new ZipEntry(sSourceEntryName);
            this.copyZipEntry(zipfileSource, zipentrySource, zopTo, sTargetEntryName);
        }
        catch (Exception e) {
            Logr.warn(className, "copyThisEntryInThisSourceToThisZipFileWithThisName", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
    }

    @Override
    protected String getSupportedScheme() {
        return "zip";
    }

    @Override
    protected void flush() throws IOException {
        this.closeAllCachedZIPOutputStreams();
        this.closeAllCachedZipFiles();
    }

    protected boolean isDirectChildren(String sParentEntry, String sChildEntry) {
        if (sParentEntry.startsWith("/")) {
            sParentEntry = sParentEntry.substring(1);
        }
        if (!sParentEntry.endsWith("/")) {
            sParentEntry = sParentEntry.substring(0, sParentEntry.length() - 1);
        }
        if (sChildEntry.startsWith("/")) {
            sChildEntry = sChildEntry.substring(1);
        }
        if (!sChildEntry.endsWith("/")) {
            sChildEntry = sChildEntry.substring(0, sChildEntry.length() - 1);
        }
        if (!sChildEntry.startsWith(sParentEntry)) {
            return false;
        }
        String sTail = sChildEntry.substring(sParentEntry.length());
        if (sTail.startsWith("/")) {
            sTail = sTail.substring(1);
        }
        if (sTail.endsWith("/")) {
            sTail = sTail.substring(0, sTail.length() - 1);
        }
        return sTail != null && !sTail.trim().equals(S_EMPTY) && sTail.indexOf("/") < 0;
    }

    private void moveFile(File fileToMove, File fileToMoveTo) throws IOException {
        if (fileToMoveTo.exists() && !fileToMoveTo.delete()) {
            throw new IOException(S_DELETE_FAILED + fileToMoveTo.toString());
        }
        if (!fileToMove.renameTo(fileToMoveTo)) {
            this.copyDiskFiles(fileToMove, fileToMoveTo);
            fileToMove.delete();
        }
    }

    private void copyDiskFiles(File fileSource, File fileDestination) throws IOException {
        FileInputStream in = new FileInputStream(fileSource);
        FileOutputStream out = new FileOutputStream(fileDestination);
        this.transferInputStreamToOutputStreamCompletely(in, out);
        in.close();
        out.close();
    }

    private ZipFile getZipFileForReading(URI uriPath) throws ZipException, IOException {
        this.reinitThisFSForReading(uriPath);
        File fileContainer = ZIPFileSystem.getFileContainerForThisFS(uriPath);
        ZipFile zipfileContainer = (ZipFile)this.m_hashtableZipFilesCached.get(fileContainer);
        if (zipfileContainer == null) {
            zipfileContainer = new ZipFile(fileContainer);
            this.m_hashtableZipFilesCached.put(fileContainer, zipfileContainer);
        }
        return zipfileContainer;
    }

    private boolean hasThisZipFileContainerBeenCached(URI uriPath) throws IOException {
        File fileContainer = ZIPFileSystem.getFileContainerForThisFS(uriPath);
        return this.m_hashtableZipFilesCached.get(fileContainer) != null;
    }

    private void ensureThisZipFileClosed(File file) throws IOException {
        ZipFile zipfileContainer = (ZipFile)this.m_hashtableZipFilesCached.get(file);
        if (zipfileContainer != null) {
            zipfileContainer.close();
            this.m_hashtableZipFilesCached.remove(file);
        }
    }

    private void closeAllCachedZipFiles() throws IOException {
        if (this.m_hashtableZipFilesCached == null) {
            return;
        }
        Enumeration enu = this.m_hashtableZipFilesCached.elements();
        while (enu.hasMoreElements()) {
            ZipFile zipfileThis = (ZipFile)enu.nextElement();
            zipfileThis.close();
        }
        this.m_hashtableZipFilesCached.clear();
    }

    private ZipOutputStream getZIPOutputStreamForAddingNewEntries(URI uriPath) throws IOException, FileNotFoundException {
        UnclosableZIPOutputStream zipoutputstream;
        if (!ZIPFileSystem.getFileContainerForThisFS(uriPath).getParentFile().exists()) {
            ZIPFileSystem.getFileContainerForThisFS(uriPath).getParentFile().mkdirs();
        }
        if ((zipoutputstream = this.getCachedZIPOutputStream(ZIPFileSystem.getFileContainerForThisFS(uriPath))) == null) {
            File fileTmpDir = this.getUnifiedFileIOObject().createTempDir();
            this.extractThisZIPFileToThisDirIfItExists(ZIPFileSystem.getFileContainerForThisFS(uriPath), fileTmpDir);
            FileOutputStream outputstreamZIPFile = new FileOutputStream(ZIPFileSystem.getFileContainerForThisFS(uriPath), false);
            zipoutputstream = new UnclosableZIPOutputStream((OutputStream)outputstreamZIPFile, ZIPFileSystem.getFileContainerForThisFS(uriPath));
            this.m_vuziposCached.add(zipoutputstream);
            this.zipThisDirectoryToThisZIPFile(fileTmpDir, zipoutputstream);
            new FileSystemEntry(fileTmpDir.toURI(), this.getInstallToolkitBridge()).deleteThisDirectoryRecursively();
        }
        return zipoutputstream;
    }

    private void reinitThisFSForReading(URI uriPath) throws IOException {
        UnclosableZIPOutputStream uzosThis = this.getCachedZIPOutputStream(ZIPFileSystem.getFileContainerForThisFS(uriPath));
        if (uzosThis != null) {
            uzosThis.closeWrappedStream();
            this.m_vuziposCached.remove(uzosThis);
        }
    }

    private UnclosableZIPOutputStream getCachedZIPOutputStream(File fileFSContainer) {
        int i = 0;
        while (i < this.m_vuziposCached.size()) {
            UnclosableZIPOutputStream uziposThis = (UnclosableZIPOutputStream)this.m_vuziposCached.elementAt(i);
            if (uziposThis.getParentZIPFile().equals(fileFSContainer)) {
                return uziposThis;
            }
            ++i;
        }
        return null;
    }

    private void closeAllCachedZIPOutputStreams() throws IOException {
        int i = 0;
        while (i < this.m_vuziposCached.size()) {
            UnclosableZIPOutputStream uziposThis = (UnclosableZIPOutputStream)this.m_vuziposCached.elementAt(i);
            uziposThis.closeWrappedStream();
            ++i;
        }
        this.m_vuziposCached.removeAllElements();
    }

    private boolean zipThisDirectoryToThisZIPFile(File fileDirToZip, File fileZIP) throws IOException, FileNotFoundException {
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(fileZIP)));
        if (this.zipThisDirectoryToThisZIPFile(fileDirToZip, out)) {
            out.close();
            return true;
        }
        out.flush();
        return false;
    }

    private boolean zipThisDirectoryToThisZIPFile(File fileDirToZip, ZipOutputStream out) throws IOException, FileNotFoundException {
        Vector vfileFilesToZip = this.getUnifiedFileIOObject().getFilesInDirectoryRecursive(fileDirToZip);
        int i = 0;
        while (i < vfileFilesToZip.size()) {
            File fileToZipThis = (File)vfileFilesToZip.elementAt(i);
            String sThisEntryName = this.getNormalizedRelativeNameZipEntryName(fileToZipThis, fileDirToZip);
            ZipEntry zipentryThis = new ZipEntry(sThisEntryName);
            out.putNextEntry(zipentryThis);
            if (!fileToZipThis.isDirectory()) {
                FileInputStream in = new FileInputStream(fileToZipThis);
                this.transferInputStreamToOutputStreamCompletely(in, out);
                in.close();
            }
            ++i;
        }
        return vfileFilesToZip.size() > 0;
    }

    private String getNormalizedRelativeNameZipEntryName(File fileToZip, File fileDirBeingZipped) {
        String sEntryName = fileToZip.getAbsolutePath().substring(fileDirBeingZipped.getAbsolutePath().toString().length());
        if (sEntryName.indexOf(92) >= 0) {
            sEntryName = sEntryName.replace('\\', '/');
        }
        if (sEntryName.startsWith("/")) {
            sEntryName = sEntryName.substring(1, sEntryName.length());
        }
        if (fileToZip.isDirectory()) {
            if (!sEntryName.substring(sEntryName.length() - 1).equals("/")) {
                sEntryName = String.valueOf(sEntryName) + "/";
            }
        } else if (sEntryName.endsWith("/")) {
            sEntryName = sEntryName.substring(0, sEntryName.length() - 1);
        }
        return sEntryName;
    }

    private void extractThisZIPFileToThisDirIfItExists(File fileZIP, File fileDirToExtractTo) throws ZipException, IOException, FileNotFoundException {
        if (fileZIP.exists()) {
            this.extractThisZIPFileToThisDir(fileZIP, fileDirToExtractTo);
        }
    }

    private void extractThisZIPFileToThisDir(File fileZIP, File fileDirToExtractTo) throws ZipException, IOException, FileNotFoundException {
        ZipFile zipfile = new ZipFile(fileZIP);
        Enumeration<? extends ZipEntry> enumeationZIPEntries = zipfile.entries();
        while (enumeationZIPEntries.hasMoreElements()) {
            ZipEntry zipentryThis = enumeationZIPEntries.nextElement();
            String sFileNameThis = zipentryThis.getName();
            if (zipentryThis.isDirectory()) {
                new File(fileDirToExtractTo, sFileNameThis).mkdirs();
                continue;
            }
            File fileThis = new File(fileDirToExtractTo, sFileNameThis);
            fileThis.getParentFile().mkdirs();
            InputStream in = zipfile.getInputStream(zipentryThis);
            FileOutputStream out = new FileOutputStream(fileThis);
            this.transferInputStreamToOutputStreamCompletely(in, out);
            in.close();
            ((OutputStream)out).close();
        }
        zipfile.close();
    }

    private OutputStream transferContentsOfGivenTemporaryFileToGivenZIPEntry(URI uriPath, File fileTemp) throws IOException, FileNotFoundException {
        OutputStream outReturn = this.writeEntry(uriPath);
        FileInputStream inTemp = new FileInputStream(fileTemp);
        this.transferInputStreamToOutputStreamCompletely(inTemp, outReturn);
        ((InputStream)inTemp).close();
        fileTemp.delete();
        return outReturn;
    }

    private File transferCurrentInputStreamToATempFile(InputStream in) throws IOException, FileNotFoundException {
        File fileTemp = File.createTempFile(S_TEMP_FILE_PREFIX, null);
        FileOutputStream out = new FileOutputStream(fileTemp);
        this.transferInputStreamToOutputStreamCompletely(in, out);
        ((OutputStream)out).close();
        in.close();
        return fileTemp;
    }

    private static String getEntryPathForThisURI(URI uriPath) {
        if (uriPath.getFragment() == null) {
            return null;
        }
        if (uriPath.getFragment().startsWith("/")) {
            return uriPath.getFragment().substring(1);
        }
        return uriPath.getFragment();
    }

    private static URI getURIGivenFSURIAndEntryPath(URI uriFS, String sEntryPath) throws URISyntaxException {
        return new URI(uriFS.getScheme(), uriFS.getAuthority(), uriFS.getPath(), uriFS.getQuery(), sEntryPath);
    }

    private static boolean isEntireFSBeingTargetted(URI uriPath) {
        return ZIPFileSystem.getEntryPathForThisURI(uriPath) == null;
    }

    private static File getFileContainerForThisFS(URI uriPath) {
        String sContainerPath = null;
        sContainerPath = uriPath.getAuthority() != null ? String.valueOf(uriPath.getAuthority()) + uriPath.getPath() : uriPath.getPath();
        return new File(sContainerPath);
    }

    private static URI getFSURIForThisEntry(URI uriEntry) throws URISyntaxException {
        return new URI(uriEntry.getScheme(), uriEntry.getAuthority(), uriEntry.getPath(), uriEntry.getQuery(), null);
    }

    private Hashtable getZIPEntryForThisURI(URI uriPath) throws IOException {
        Hashtable hashtableReturn = this.getZIPEntryForThisURIReturnNullIfNotFound(uriPath);
        if (hashtableReturn == null) {
            throw new IOException(S_FILE_NOT_FOUND + uriPath.toString());
        }
        return hashtableReturn;
    }

    private Hashtable getZIPEntryForThisURIReturnNullIfNotFound(URI uriPath) throws IOException {
        if (ZIPFileSystem.isEntireFSBeingTargetted(uriPath)) {
            return null;
        }
        this.reinitThisFSForReading(uriPath);
        try (ZipInputStream in = new ZipInputStream(new FileInputStream(ZIPFileSystem.getFileContainerForThisFS(uriPath)));){
            while (in.available() != 0) {
                ZipEntry zipentryThis = in.getNextEntry();
                if (zipentryThis == null || !zipentryThis.getName().equals(ZIPFileSystem.getEntryPathForThisURI(uriPath))) continue;
                Hashtable<String, ZipConstants> hashtableReturn = new Hashtable<String, ZipConstants>();
                hashtableReturn.put(S_ZIPENTRY_OBJECT, zipentryThis);
                hashtableReturn.put(S_ZIPINPUTSTREAM_OBJECT, in);
                Hashtable<String, ZipConstants> hashtable = hashtableReturn;
                return hashtable;
            }
        }
        return null;
    }

    private void setParentFSPermissions(URI uriPath, int nPermissions) throws IOException {
        try {
            if (PlatformConstants.isOS400Install()) {
                return;
            }
            this.getUnifiedFileIOObject().setPermissions(ZIPFileSystem.getFileContainerForThisFS(uriPath).getAbsolutePath(), nPermissions);
        }
        catch (InstallToolkitBridgeException e) {
            Logr.warn(className, "setParentFSPermissions", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
    }

    private int getParentFSPermissions(URI uriPath) throws IOException {
        block3: {
            try {
                if (!PlatformConstants.isOS400Install()) break block3;
                return 755;
            }
            catch (InstallToolkitBridgeException e) {
                Logr.warn(className, "getParentFSPermissions", e.getMessage(), e);
                throw new IOException(e.getMessage());
            }
        }
        return this.getUnifiedFileIOObject().getPermissions(ZIPFileSystem.getFileContainerForThisFS(uriPath).getAbsolutePath());
    }

    private void createFSSymbolicLink(URI uriSymbolicLinkPath, String sPathToLinkTo) throws IOException {
        File fileSymbolicLink;
        if (PlatformConstants.isOS400Install()) {
            return;
        }
        if (!uriSymbolicLinkPath.getScheme().equalsIgnoreCase(S_DISK_FS_SCHEME)) {
            throw new IOException(S_INVALID_FS_FOR_SYMLINK_ATTEMPT);
        }
        if (!ZIPFileSystem.getFileContainerForThisFS(this.getParent(uriSymbolicLinkPath)).exists()) {
            this.mkdirs(this.getParent(uriSymbolicLinkPath));
        }
        if ((fileSymbolicLink = ZIPFileSystem.getFileContainerForThisFS(uriSymbolicLinkPath)).exists()) {
            fileSymbolicLink.delete();
        }
        String sLink = ZIPFileSystem.getFileContainerForThisFS(uriSymbolicLinkPath).getAbsolutePath();
        String sLNCommand = this.getLNCommand();
        if (sLNCommand == null) {
            throw new IOException("Symbolic linking " + sLink + "->" + sPathToLinkTo + S_NO_LN_3);
        }
        String[] asArgs = new String[]{sLNCommand, S_SOFTLINK_OPTION, S_FORCE_OPTION, sPathToLinkTo, sLink};
        ExecEngine ee = new ExecEngine();
        ee.executeIncomingArguments(asArgs, NIFConstants.N_DEFAULT_PROCESS_TIME_OUT_TIME);
        if (ee.getProcessRetCode() != 0) {
            String err = "Symbolic linking " + sLink + "->" + sPathToLinkTo + S_GENERIC_FAILURE_3 + ee.getProcessStdErr();
            Logr.debug("createFSSymbolicLink : getProcessStdOut : " + ee.getProcessStdOut());
            Logr.warn(err);
            throw new IOException(err);
        }
    }

    private String getLNCommand() {
        String sLNCommand = null;
        if (new File(S_LN_LOCATION_1).exists()) {
            sLNCommand = S_LN_LOCATION_1;
        }
        if (new File(S_LN_LOCATION_2).exists()) {
            sLNCommand = S_LN_LOCATION_2;
        }
        return sLNCommand;
    }

    @Override
    public boolean isReadable(URI uriPath) {
        return new File(uriPath).canRead();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isWriteable(URI uriPath) {
        try {
            File testFile = new File(uriPath.getPath());
            while (true) {
                if (testFile.exists()) {
                    if (!testFile.isDirectory()) break;
                    return this.isThisPathWritable(testFile);
                }
                testFile = testFile.getParentFile();
            }
            if (!PlatformConstants.isCurrentPlatformWindows()) {
                return testFile.canWrite();
            }
            try {
                FileOutputStream fileoutputstreamThisFile = new FileOutputStream(testFile, true);
                fileoutputstreamThisFile.close();
                return true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private boolean isThisPathWritable(File dir) {
        try {
            File fTemp = File.createTempFile("_write_", "_test_", dir);
            fTemp.delete();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private void copyZipEntry(ZipFile fromFile, ZipEntry from, ZipOutputStream toFile, String targetName) throws IOException {
        this.copyZipEntry(fromFile, from, toFile, targetName, false);
    }

    private void copyZipEntry(ZipFile fromFile, ZipEntry from, ZipOutputStream toFile, String targetName, boolean fKeepTimestamp) throws IOException {
        ZipEntry to = new ZipEntry(targetName);
        if (fKeepTimestamp) {
            byte[] abyteExtra;
            String sComment;
            long lTime = from.getTime();
            if (lTime != -1L) {
                to.setTime(lTime);
            }
            if ((sComment = from.getComment()) != null) {
                to.setComment(sComment);
            }
            if ((abyteExtra = from.getExtra()) != null) {
                to.setExtra(abyteExtra);
            }
        }
        toFile.putNextEntry(to);
        this.copyZipEntry(fromFile.getInputStream(from), toFile);
        toFile.closeEntry();
    }

    private void copyZipEntry(InputStream from, ZipOutputStream to) throws IOException {
        int length;
        byte[] data = new byte[1000];
        while ((length = from.read(data)) > 0) {
            to.write(data, 0, length);
        }
        from.close();
    }

    private boolean isThisZipEntryTargetedByTheseOperations(String sEntryName, Vector vZIPFileOperations) {
        int i = 0;
        while (i < vZIPFileOperations.size()) {
            ZIPFileOperation operationThis = (ZIPFileOperation)vZIPFileOperations.elementAt(i);
            if (operationThis.getEntryName().equals(sEntryName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private File createTempFileForThisFile(File f) throws IOException {
        String sFileTmp = String.valueOf(f.getPath()) + S_DOT_TMP;
        File fFileTmp = new File(sFileTmp);
        if (fFileTmp.exists() && !fFileTmp.delete()) {
            throw new IOException(S_DELETE_FAILED + fFileTmp.getAbsolutePath());
        }
        return fFileTmp;
    }

    private void moveAllEntriesFromThisZipFileToAnotherOneUnlessItIsToBeUpdated(ZipFile zipfileFrom, ZipOutputStream zopTo, Vector vZIPFileOperations) throws IOException {
        Enumeration<? extends ZipEntry> enu = zipfileFrom.entries();
        while (enu.hasMoreElements()) {
            ZipEntry zipentryThis = enu.nextElement();
            String sEntryThis = zipentryThis.getName();
            if (this.isThisZipEntryTargetedByTheseOperations(sEntryThis, vZIPFileOperations)) continue;
            this.copyZipEntry(zipfileFrom, zipentryThis, zopTo, zipentryThis.getName(), true);
        }
    }

    private void applyZIPFileOperationsToZIPFile(Vector vZIPFileOperations, ZipOutputStream zopTo) throws IOException, ClassNotFoundException, SAXException, ParserConfigurationException, IllegalAccessException, InstantiationException, FileSystemNotSupportedException {
        int i = 0;
        while (i < vZIPFileOperations.size()) {
            ZIPFileOperation zfoThis = (ZIPFileOperation)vZIPFileOperations.elementAt(i);
            if (!zfoThis.getOperation().equalsIgnoreCase("zip-remove")) {
                FileSystem fsSource = FileSystem.getFileSystem(zfoThis.getSourceFile(), this.getInstallToolkitBridge());
                fsSource.copyThisEntryInThisSourceToThisZipFileWithThisName(zfoThis.getSourceFile(), zfoThis.getSourceEntryName(), zopTo, zfoThis.getEntryName());
            }
            ++i;
        }
    }
}

