/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.fileactions;

import com.ibm.ws.pak.internal.utils.URIUtils;
import com.ibm.ws.pak.internal.utils.fileactions.FileActionPlugin;
import com.ibm.ws.pak.internal.utils.fileactions.NIFFileActionIOException;
import com.ibm.ws.pak.internal.utils.fileactions.ZIPFileOperationController;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class ZIPReplaceFileActionPlugin
extends FileActionPlugin {
    private static final String S_FILE_ACTION_ID = "zip-replace";
    private static final String S_INVERSE_FILE_ACTION_ID = "zip-replace";
    private static final String S_ZIP_REMOVE_FILE_ACTION_ID = "zip-remove";
    private static final String S_EXTENSIONS_PARAM = "extensions";
    private static final String[] AS_REQUIRED_PARAMS = new String[]{"extensions"};
    private static final String S_SEMI_COLON = ";";
    private static final String S_INVALID_ENTRY_PATH = "Invalid entry path: ";
    private static final String className = "ZIPReplaceFileActionPlugin";

    @Override
    public void execute(Hashtable hashtableFileDetails) throws IOException {
        if (this.isThisReallyABackupForAnAddOperation(hashtableFileDetails)) {
            return;
        }
        if (FileActionPlugin.isBackupFlagActive(hashtableFileDetails)) {
            FileSystemEntry fseFrom = this.resolveSourceFileSystemEntry(hashtableFileDetails);
            FileSystemEntry fseTo = this.resolveTargetFileSystemEntry(hashtableFileDetails);
            if (FileActionPlugin.isCheckPermissionsNeeded(hashtableFileDetails)) {
                FileActionPlugin.checkWritePermissions(fseFrom);
            }
            try {
                Logr.debug("ZIPReplaceFileAction - fseFrom :" + fseFrom.getAbsolutePath() + " fseTo :" + fseTo.getAbsolutePath());
                fseFrom.copyTo(fseTo);
            }
            catch (IOException e) {
                Logr.warn(className, "execute", e.getMessage(), e);
                throw new NIFFileActionIOException(e, fseTo.getURI().getPath());
            }
        } else {
            this.registerThisZIPFileOperation(hashtableFileDetails);
        }
    }

    @Override
    protected boolean isChecksumUpdateRequired(Hashtable hashtableFileDetails) {
        return true;
    }

    @Override
    protected boolean isThisFileActionAcceptable(Hashtable hashtableFileDetails) {
        String sFileActionID = FileActionPlugin.getFileActionID(hashtableFileDetails);
        return "zip-replace".equals(sFileActionID);
    }

    @Override
    protected String[] getRequiredParams() {
        return AS_REQUIRED_PARAMS;
    }

    @Override
    protected String getInverseFileActionID(Hashtable hashtableFileDetails) {
        if (this.isThisReallyABackupForAnAddOperation(hashtableFileDetails)) {
            return S_ZIP_REMOVE_FILE_ACTION_ID;
        }
        return "zip-replace";
    }

    private FileSystemEntry getInstallFileSystemEntry(Hashtable hashtableFileDetails) throws IOException {
        String sRelativeFilePath = hashtableFileDetails.get("relativepath").toString();
        FileSystemEntry fseInstallLocation = (FileSystemEntry)hashtableFileDetails.get("installlocation");
        String sInstallLocationPath = fseInstallLocation.getURI().getPath();
        int nFSRelativePathStopPosition = this.getFSRelativePathStopPosition(sRelativeFilePath);
        String sZIPFSPath = sRelativeFilePath.substring(0, nFSRelativePathStopPosition);
        String sZIPFSRelativePath = sRelativeFilePath.substring(nFSRelativePathStopPosition + 1);
        try {
            URI uriTarget = URIUtils.convertPathToDefaultTargetMachineFSURI(String.valueOf(sInstallLocationPath) + "/" + sZIPFSPath, this.getInstallToolkitBridge());
            FileSystemEntry fse = new FileSystemEntry(uriTarget, sZIPFSRelativePath, this.getInstallToolkitBridge());
            return fse;
        }
        catch (URISyntaxException e) {
            Logr.warn(className, "getInstallFileSystemEntry", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
    }

    private FileSystemEntry getTargetRootFileSystemEntry(Hashtable hashtableFileDetails) throws IOException {
        String sRelativeFilePath = hashtableFileDetails.get("relativepath").toString();
        FileSystemEntry fseInstallLocation = (FileSystemEntry)hashtableFileDetails.get("installlocation");
        String sInstallLocationPath = fseInstallLocation.getURI().getPath();
        int nFSRelativePathStopPosition = this.getFSRelativePathStopPosition(sRelativeFilePath);
        String sZIPFSPath = sRelativeFilePath.substring(0, nFSRelativePathStopPosition);
        try {
            URI uriTarget = URIUtils.convertPathToDefaultTargetMachineFSURI(String.valueOf(sInstallLocationPath) + "/" + sZIPFSPath, this.getInstallToolkitBridge());
            FileSystemEntry fse = new FileSystemEntry(uriTarget, this.getInstallToolkitBridge());
            return fse;
        }
        catch (URISyntaxException e) {
            Logr.warn(className, "getTargetRootFileSystemEntry", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
    }

    private String getEntryNameFromFSRelativePath(String sRelativePath) throws IOException {
        int nFSRelativePathStopPosition = this.getFSRelativePathStopPosition(sRelativePath);
        String entryNameFromFSRelativePath = sRelativePath.substring(nFSRelativePathStopPosition + 1);
        return entryNameFromFSRelativePath;
    }

    private int getFSRelativePathStopPosition(String sRelativePath) throws IOException {
        String sExtensions = this.getParamValue(S_EXTENSIONS_PARAM);
        StringTokenizer st = new StringTokenizer(sExtensions, S_SEMI_COLON);
        while (st.hasMoreTokens()) {
            String sExtensionThis = "." + st.nextToken();
            if (sRelativePath.indexOf(sExtensionThis) == -1) continue;
            int fsRelativePathStopPosition = sRelativePath.indexOf(sExtensionThis) + sExtensionThis.length();
            return fsRelativePathStopPosition;
        }
        throw new IOException(S_INVALID_ENTRY_PATH + sRelativePath);
    }

    private FileSystemEntry resolveSourceFileSystemEntry(Hashtable hashtableFileDetails) throws IOException {
        if (FileActionPlugin.isBackupFlagActive(hashtableFileDetails)) {
            FileSystemEntry fse = this.getInstallFileSystemEntry(hashtableFileDetails);
            return fse;
        }
        FileSystemEntry fseSourceRepository = (FileSystemEntry)hashtableFileDetails.get("sourcerepository");
        String sRelativePath = hashtableFileDetails.get("relativepath").toString();
        FileSystemEntry fse = new FileSystemEntry(fseSourceRepository.getURI(), sRelativePath, this.getInstallToolkitBridge());
        return fse;
    }

    private FileSystemEntry resolveTargetFileSystemEntry(Hashtable hashtableFileDetails) throws IOException {
        if (FileActionPlugin.isBackupFlagActive(hashtableFileDetails)) {
            FileSystemEntry fseBackupRepository = (FileSystemEntry)hashtableFileDetails.get("backuprepository");
            String sRelativePath = hashtableFileDetails.get("relativepath").toString();
            FileSystemEntry fse = new FileSystemEntry(fseBackupRepository.getURI(), sRelativePath, this.getInstallToolkitBridge());
            return fse;
        }
        FileSystemEntry fse = this.getInstallFileSystemEntry(hashtableFileDetails);
        return fse;
    }

    private boolean isThisReallyABackupForAnAddOperation(Hashtable hashtableFileDetails) {
        try {
            return !this.resolveSourceFileSystemEntry(hashtableFileDetails).exists() && FileActionPlugin.isBackupFlagActive(hashtableFileDetails);
        }
        catch (IOException iOException) {
            return FileActionPlugin.isBackupFlagActive(hashtableFileDetails);
        }
    }

    private void registerThisZIPFileOperation(Hashtable hashtableFileDetails) throws IOException {
        URI uriTargetFile = this.getTargetRootFileSystemEntry(hashtableFileDetails).getURI();
        String sRelativePath = hashtableFileDetails.get("relativepath").toString();
        String sEntryName = this.getEntryNameFromFSRelativePath(sRelativePath);
        String sOperation = "zip-replace";
        URI uriSourceRepository = ((FileSystemEntry)hashtableFileDetails.get("sourcerepository")).getURI();
        URI uriSourceFile = this.getSourceRootURIFromSourceRepository(uriSourceRepository);
        FileSystemEntry fseSourceEntry = new FileSystemEntry(uriSourceRepository, sRelativePath, this.getInstallToolkitBridge());
        String sSourceEntryName = this.getEntryNameFromFSRelativePath(URLDecoder.decode(fseSourceEntry.getURI().toString(), "UTF-8"));
        ZIPFileOperationController.add(uriTargetFile, sEntryName, sOperation, uriSourceFile, sSourceEntryName);
    }

    private URI getSourceRootURIFromSourceRepository(URI uriSourceRepository) throws IOException {
        FileSystemEntry fse = new FileSystemEntry(uriSourceRepository, this.getInstallToolkitBridge());
        return fse.getParentDirOrFSRoot().getParentDirOrFSRoot().getURI();
    }
}

