/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.fileactions;

import com.ibm.ws.pak.internal.utils.URIUtils;
import com.ibm.ws.pak.internal.utils.fileactions.FileActionPlugin;
import com.ibm.ws.pak.internal.utils.fileactions.NIFFileActionIOException;
import com.ibm.ws.pak.internal.utils.fileactions.ZIPFileOperationController;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class ZIPRemoveFileActionPlugin
extends FileActionPlugin {
    private static final String S_FILE_ACTION_ID = "zip-remove";
    private static final String S_INVERSE_FILE_ACTION_ID = "zip-add";
    private static final String S_EXTENSIONS_PARAM = "extensions";
    private static final String[] AS_REQUIRED_PARAMS = new String[]{"extensions"};
    private static final String S_SEMI_COLON = ";";
    private static final String S_INVALID_ENTRY_PATH = "Invalid entry path: ";
    private static final String className = "ZIPRemoveFileActionPlugin";

    @Override
    public void execute(Hashtable hashtableFileDetails) throws IOException {
        if (!this.getTargetFileSystemEntry(hashtableFileDetails).exists()) {
            Logr.debug("File doesn't exist; nop.");
            return;
        }
        if (FileActionPlugin.isBackupFlagActive(hashtableFileDetails)) {
            FileSystemEntry fseBackupRepositoryPath = (FileSystemEntry)hashtableFileDetails.get("backuprepository");
            String sRelativeFilePath = hashtableFileDetails.get("relativepath").toString();
            FileSystemEntry fseFrom = this.getTargetFileSystemEntry(hashtableFileDetails);
            FileSystemEntry fseTo = new FileSystemEntry(fseBackupRepositoryPath.getURI(), sRelativeFilePath, this.getInstallToolkitBridge());
            if (FileActionPlugin.isCheckPermissionsNeeded(hashtableFileDetails)) {
                FileActionPlugin.checkWritePermissions(fseFrom);
            }
            try {
                Logr.debug("ZIPRemoveFileAction - fseFrom :" + fseFrom.getAbsolutePath() + " fseTo :" + fseTo.getAbsolutePath());
                fseFrom.copyTo(fseTo);
            }
            catch (IOException e) {
                Logr.warn(className, "execute", e.getMessage(), e);
                throw new NIFFileActionIOException(e, fseTo.getURI().getPath());
            }
        } else {
            this.registerThisZIPFileOperation(hashtableFileDetails);
        }
    }

    @Override
    protected boolean isThisFileActionAcceptable(Hashtable hashtableFileDetails) {
        String sFileActionID = FileActionPlugin.getFileActionID(hashtableFileDetails);
        return S_FILE_ACTION_ID.equals(sFileActionID);
    }

    @Override
    protected boolean isChecksumUpdateRequired(Hashtable hashtableFileDetails) {
        return true;
    }

    @Override
    protected String[] getRequiredParams() {
        return AS_REQUIRED_PARAMS;
    }

    @Override
    protected String getInverseFileActionID(Hashtable hashtableFileDetails) {
        try {
            if (!this.getTargetFileSystemEntry(hashtableFileDetails).exists()) {
                return "nop";
            }
            return S_INVERSE_FILE_ACTION_ID;
        }
        catch (IOException e) {
            Logr.warn(className, "getInverseFileActionID", e.getMessage(), e);
            return "nop";
        }
    }

    private FileSystemEntry getTargetFileSystemEntry(Hashtable hashtableFileDetails) throws IOException {
        String sRelativeFilePath = hashtableFileDetails.get("relativepath").toString();
        FileSystemEntry fseInstallLocation = (FileSystemEntry)hashtableFileDetails.get("installlocation");
        String sInstallLocationPath = fseInstallLocation.getURI().getPath();
        int nFSRelativePathStopPosition = this.getFSRelativePathStopPosition(sRelativeFilePath);
        String sZIPFSPath = sRelativeFilePath.substring(0, nFSRelativePathStopPosition);
        String sZIPFSRelativePath = sRelativeFilePath.substring(nFSRelativePathStopPosition + 1);
        try {
            URI uriTarget = URIUtils.convertPathToDefaultTargetMachineFSURI(String.valueOf(sInstallLocationPath) + "/" + sZIPFSPath, this.getInstallToolkitBridge());
            FileSystemEntry fse = new FileSystemEntry(uriTarget, sZIPFSRelativePath, this.getInstallToolkitBridge());
            return fse;
        }
        catch (URISyntaxException e) {
            Logr.warn(className, "getTargetFileSystemEntry", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
    }

    private String getEntryNameFromFSRelativePath(String sRelativePath) throws IOException {
        int nFSRelativePathStopPosition = this.getFSRelativePathStopPosition(sRelativePath);
        String entryNameFromFSRelativePath = sRelativePath.substring(nFSRelativePathStopPosition + 1);
        return entryNameFromFSRelativePath;
    }

    private int getFSRelativePathStopPosition(String sRelativePath) throws IOException {
        String sExtensions = this.getParamValue(S_EXTENSIONS_PARAM);
        StringTokenizer st = new StringTokenizer(sExtensions, S_SEMI_COLON);
        while (st.hasMoreTokens()) {
            String sExtensionThis = "." + st.nextToken();
            if (sRelativePath.indexOf(sExtensionThis) == -1) continue;
            int fsRelativePathStopPosition = sRelativePath.indexOf(sExtensionThis) + sExtensionThis.length();
            return fsRelativePathStopPosition;
        }
        throw new IOException(S_INVALID_ENTRY_PATH + sRelativePath);
    }

    private void registerThisZIPFileOperation(Hashtable hashtableFileDetails) throws IOException {
        URI uriTargetFile = this.getTargetRootFileSystemEntry(hashtableFileDetails).getURI();
        String sRelativePath = hashtableFileDetails.get("relativepath").toString();
        String sEntryName = this.getEntryNameFromFSRelativePath(sRelativePath);
        ZIPFileOperationController.add(uriTargetFile, sEntryName, S_FILE_ACTION_ID, null, null);
    }

    private FileSystemEntry getTargetRootFileSystemEntry(Hashtable hashtableFileDetails) throws IOException {
        String sRelativeFilePath = hashtableFileDetails.get("relativepath").toString();
        FileSystemEntry fseInstallLocation = (FileSystemEntry)hashtableFileDetails.get("installlocation");
        String sInstallLocationPath = fseInstallLocation.getURI().getPath();
        int nFSRelativePathStopPosition = this.getFSRelativePathStopPosition(sRelativeFilePath);
        String sZIPFSPath = sRelativeFilePath.substring(0, nFSRelativePathStopPosition);
        try {
            URI uriTarget = URIUtils.convertPathToDefaultTargetMachineFSURI(String.valueOf(sInstallLocationPath) + "/" + sZIPFSPath, this.getInstallToolkitBridge());
            FileSystemEntry fse = new FileSystemEntry(uriTarget, this.getInstallToolkitBridge());
            return fse;
        }
        catch (URISyntaxException e) {
            Logr.methodExit(className, "execute");
            throw new IOException(e.getMessage());
        }
    }
}

