/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.fileactions;

import com.ibm.ws.pak.internal.NIFConstants;
import com.ibm.ws.pak.internal.NIFPlugin;
import com.ibm.ws.pak.internal.PakCoreMessages;
import com.ibm.ws.pak.internal.utils.NIFPluginUtils;
import com.ibm.ws.pak.internal.utils.SimpleXMLParser;
import com.ibm.ws.pak.internal.utils.URIUtils;
import com.ibm.ws.pak.internal.utils.XMLUtils;
import com.ibm.ws.pak.internal.utils.fileactions.NIFFileActionIOException;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.installtoolkitbridge.InstallToolkitBridge;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public abstract class FileActionPlugin
extends NIFPlugin {
    public static final String S_FILE_ACTION_ID_KEY = "installoperation";
    public static final String S_RELATIVE_PATH_KEY = "relativepath";
    public static final String S_PERMISSIONS_KEY = "permissions";
    public static final String S_CHECKSUMS_KEY = "checksum";
    public static final String S_SOURCE_REPOSITORY_PATH_KEY = "sourcerepository";
    public static final String S_INSTALL_LOCATION_PATH_KEY = "installlocation";
    public static final String S_BACKUP_REPOSITORY_PATH_KEY = "backuprepository";
    public static final String S_IS_BACKUP_OPERATION_KEY = "isbackupoperation";
    public static final String S_IS_CHECK_PERMISSIONS_NEEDED = "checkpermissions";
    public static final String S_NOP_FILE_ACTION_ID = "nop";
    private static FileActionPlugin[] m_afapAvailable = null;
    private static final String[] AS_EMPTY = new String[0];
    private static final String S_FILE_ACTION_ID_MISSING = "File action ID missing.";
    private static final String S_UNKNOWN_FILE_ACTION = "Unknown file action: ";
    private static final String S_CAN_NOT_WRITE = "Can not write to file: ";
    private static final String className = "FileActionPlugin";

    public static void executeFileAction(Hashtable hashtableFileDetails, InstallToolkitBridge itb) throws IOException {
        try {
            FileActionPlugin.registerAvailableFileActions(itb);
            FileActionPlugin.getFileActionPluginForThisFile(hashtableFileDetails).execute(hashtableFileDetails);
            return;
        }
        catch (InstantiationException e) {
            Logr.warn(className, "executeFileAction", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            Logr.warn(className, "executeFileAction", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
        catch (URISyntaxException e) {
            Logr.warn(className, "executeFileAction", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            Logr.warn(className, "executeFileAction", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            Logr.warn(className, "executeFileAction", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            Logr.warn(className, "executeFileAction", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
    }

    public static boolean isChecksumUpdateRequired(Hashtable hashtableFileDetails, InstallToolkitBridge itb) throws IOException {
        try {
            FileActionPlugin.registerAvailableFileActions(itb);
            FileActionPlugin flapThisFile = FileActionPlugin.getFileActionPluginForThisFile(hashtableFileDetails);
            return flapThisFile.isChecksumUpdateRequired(hashtableFileDetails);
        }
        catch (InstantiationException e) {
            Logr.warn(className, "isChecksumUpdateRequired", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            Logr.warn(className, "isChecksumUpdateRequired", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
        catch (URISyntaxException e) {
            Logr.warn(className, "isChecksumUpdateRequired", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            Logr.warn(className, "isChecksumUpdateRequired", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            Logr.warn(className, "isChecksumUpdateRequired", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            Logr.warn(className, "isChecksumUpdateRequired", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
    }

    public static Hashtable getInverseFileAction(Hashtable hashtableFileDetails, InstallToolkitBridge itb) throws IOException {
        try {
            FileActionPlugin.registerAvailableFileActions(itb);
            FileActionPlugin flapThisFile = FileActionPlugin.getFileActionPluginForThisFile(hashtableFileDetails);
            return flapThisFile.getInverseFileAction(hashtableFileDetails);
        }
        catch (InstantiationException e) {
            Logr.warn(className, "getInverseFileAction", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            Logr.warn(className, "getInverseFileAction", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
        catch (URISyntaxException e) {
            Logr.warn(className, "getInverseFileAction", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            Logr.warn(className, "getInverseFileAction", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            Logr.warn(className, "getInverseFileAction", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            Logr.warn(className, "getInverseFileAction", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
    }

    public abstract void execute(Hashtable var1) throws IOException;

    protected abstract boolean isThisFileActionAcceptable(Hashtable var1);

    protected abstract String getInverseFileActionID(Hashtable var1) throws IOException;

    protected Hashtable getInverseFileAction(Hashtable hashtableFileDetails) throws IOException {
        String sInverseAction = this.getInverseFileActionID(hashtableFileDetails);
        Hashtable<String, String> hashtableReturn = new Hashtable<String, String>(hashtableFileDetails);
        hashtableReturn.put(S_FILE_ACTION_ID_KEY, sInverseAction);
        return hashtableReturn;
    }

    @Override
    protected String[] getRequiredParams() {
        return AS_EMPTY;
    }

    @Override
    protected String[] getOptionalParams() {
        return AS_EMPTY;
    }

    protected static String getFileActionID(Hashtable hashtableFileDetails) {
        Object oFileActionID = hashtableFileDetails.get(S_FILE_ACTION_ID_KEY);
        if (oFileActionID == null) {
            return null;
        }
        return oFileActionID.toString();
    }

    protected static boolean isBackupFlagActive(Hashtable hashtableFileDetails) {
        return new Boolean(hashtableFileDetails.get(S_IS_BACKUP_OPERATION_KEY).toString());
    }

    protected static boolean isCheckPermissionsNeeded(Hashtable hashtableFileDetails) {
        return new Boolean(hashtableFileDetails.get(S_IS_CHECK_PERMISSIONS_NEEDED).toString());
    }

    protected static void checkWritePermissions(FileSystemEntry fse) throws NIFFileActionIOException {
        if (!fse.writeable()) {
            throw new NIFFileActionIOException(S_CAN_NOT_WRITE + fse.getURI().getPath(), PakCoreMessages.bind((String)PakCoreMessages.PAK_CORE_S_CAN_NOT_WRITE, (Object)fse.getURI().getPath()), fse.getURI().getPath());
        }
    }

    protected FileSystemEntry getCurrentFileSystemEntry(Hashtable hashtableFileDetails) throws IOException {
        try {
            FileSystemEntry fseInstallLocationPath = (FileSystemEntry)hashtableFileDetails.get(S_INSTALL_LOCATION_PATH_KEY);
            String sRelativePath = (String)hashtableFileDetails.get(S_RELATIVE_PATH_KEY);
            return new FileSystemEntry(fseInstallLocationPath.getURI(), sRelativePath, this.getInstallToolkitBridge());
        }
        catch (Exception e) {
            Logr.warn(className, "getCurrentFileSystemEntry", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
    }

    protected boolean isChecksumUpdateRequired(Hashtable hashtableFileDetails) {
        return false;
    }

    private static FileActionPlugin getFileActionPluginForThisFile(Hashtable hashtableFileDetails) throws IOException {
        String sFileActionID = FileActionPlugin.getFileActionID(hashtableFileDetails);
        if (sFileActionID == null) {
            throw new IOException(S_FILE_ACTION_ID_MISSING);
        }
        FileActionPlugin[] fileActionPluginArray = m_afapAvailable;
        int n = m_afapAvailable.length;
        int n2 = 0;
        while (n2 < n) {
            FileActionPlugin element = fileActionPluginArray[n2];
            if (element.isThisFileActionAcceptable(hashtableFileDetails)) {
                return element;
            }
            ++n2;
        }
        throw new IOException(S_UNKNOWN_FILE_ACTION + sFileActionID);
    }

    private static void registerAvailableFileActions(InstallToolkitBridge itb) throws IOException, ParserConfigurationException, SAXException, InstantiationException, IllegalAccessException, ClassNotFoundException, URISyntaxException {
        if (m_afapAvailable != null) {
            return;
        }
        URI uriFileActionDB = URIUtils.convertPathToDefaultSourceMachineFSURI(String.valueOf(NIFConstants.getMetadataDirectory()) + "/" + "framework/fileactions.xml", itb);
        FileSystemEntry fseFileActionDB = new FileSystemEntry(uriFileActionDB, itb);
        SimpleXMLParser sxpFileActionDB = XMLUtils.getSimpleXMLParserFromFileSystemEntry(fseFileActionDB);
        NIFPlugin[] anifpFileActions = NIFPlugin.createPlugins(sxpFileActionDB.getDocument(), "file-actions/file-action", itb);
        NIFPluginUtils.enforceAllThesePluginsAssignableFromThisClass(FileActionPlugin.class, anifpFileActions);
        m_afapAvailable = new FileActionPlugin[anifpFileActions.length];
        int i = 0;
        while (i < anifpFileActions.length) {
            FileActionPlugin.m_afapAvailable[i] = (FileActionPlugin)anifpFileActions[i];
            ++i;
        }
    }
}

