/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.events;

import com.ibm.ws.pak.internal.utils.StringUtils;
import com.ibm.ws.pak.internal.utils.events.NIFEvent;
import java.util.Hashtable;

public class ComponentActionFileEvent
extends NIFEvent {
    public static final int N_COMPONENT_FILE_ACTION_EVENT_TYPE = 1;
    public static final String S_COMPONENT_FILE_ACTION_EVENT_FILE_RELATIVE_PATH = "FILE_RELATIVE_PATH";
    public static final String S_COMPONENT_FILE_ACTION_EVENT_FILE_NUMBER = "FILE_NUMBER";
    public static final String S_COMPONENT_FILE_ACTION_EVENT_TOTAL_FILES = "TOTAL_FILES";
    private final Hashtable m_hashtableEventProperties = new Hashtable();

    public ComponentActionFileEvent(String sFileRelativePath, int nCurrentFileNumber, int nTotalFiles) {
        this.m_hashtableEventProperties.put(S_COMPONENT_FILE_ACTION_EVENT_FILE_RELATIVE_PATH, sFileRelativePath);
        this.m_hashtableEventProperties.put(S_COMPONENT_FILE_ACTION_EVENT_FILE_NUMBER, new Integer(nCurrentFileNumber));
        this.m_hashtableEventProperties.put(S_COMPONENT_FILE_ACTION_EVENT_TOTAL_FILES, new Integer(nTotalFiles));
    }

    @Override
    public int getEventType() {
        return 1;
    }

    @Override
    public Hashtable getEventProperties() {
        return this.m_hashtableEventProperties;
    }

    @Override
    public Object getEventProperty(Object oPropertyKey) {
        return this.m_hashtableEventProperties.get(oPropertyKey);
    }

    public String getRelativeFilePath() {
        return StringUtils.returnObjectToStringOrNullIfObjectIsNull(this.getEventProperty(S_COMPONENT_FILE_ACTION_EVENT_FILE_RELATIVE_PATH));
    }

    public int getFileNumber() {
        Integer integerFileNumber = (Integer)this.getEventProperty(S_COMPONENT_FILE_ACTION_EVENT_FILE_NUMBER);
        if (integerFileNumber != null) {
            return integerFileNumber;
        }
        return -1;
    }

    public int getTotalFiles() {
        Integer integerTotalFiles = (Integer)this.getEventProperty(S_COMPONENT_FILE_ACTION_EVENT_TOTAL_FILES);
        if (integerTotalFiles != null) {
            return integerTotalFiles;
        }
        return -1;
    }
}

