/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.componentactions;

import com.ibm.ws.pak.internal.install.metadata.NIFPackageEntry;
import com.ibm.ws.pak.internal.install.metadata.NIFStack;
import com.ibm.ws.pak.internal.utils.DependsOnUtils;
import com.ibm.ws.pak.internal.utils.StringUtils;
import com.ibm.ws.pak.internal.utils.componentactions.CommonComponent;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.TreeMap;
import java.util.Vector;

public class UninstallCommonComponentInfo {
    private static final String className = "UninstallCommonComponentInfo";
    private Vector allNIFStackElements = new Vector();
    private String commonComponentRequiresFromPrimaryPak = null;
    private String primaryPakName = null;
    private String allUninstallableCommonComponentBackupPaksURIs = "";
    private final Vector allUninstallableNIFPackageList = new Vector();
    private final LinkedHashMap commonComponentInfoMap = new LinkedHashMap();
    private static HashMap uninstallCCInfoMap = new HashMap();

    public static UninstallCommonComponentInfo getUninstallCommonComponentInfoInstance(Vector allNIFPackageEntries, String commonComponentRequires, String currentPrimaryPakName) {
        UninstallCommonComponentInfo retInstance = (UninstallCommonComponentInfo)uninstallCCInfoMap.get(currentPrimaryPakName);
        if (retInstance == null) {
            retInstance = new UninstallCommonComponentInfo(allNIFPackageEntries, commonComponentRequires, currentPrimaryPakName);
            uninstallCCInfoMap.put(currentPrimaryPakName, retInstance);
        }
        return retInstance;
    }

    private UninstallCommonComponentInfo(Vector allNIFPackageEntries, String commonComponentRequires, String currentPrimaryPakName) {
        this.setAllNIFStackElements(allNIFPackageEntries);
        this.setCommonComponentRequiresFromPrimaryPak(commonComponentRequires);
        this.setPrimaryPakName(currentPrimaryPakName);
        this.init();
    }

    public Vector getAllNIFStackElements() {
        return this.allNIFStackElements;
    }

    public void setAllNIFStackElements(Vector allNIFStackElements) {
        this.allNIFStackElements = allNIFStackElements;
    }

    public String getCommonComponentRequiresFromPrimaryPak() {
        return this.commonComponentRequiresFromPrimaryPak;
    }

    public void setCommonComponentRequiresFromPrimaryPak(String commonComponentRequiresFromPrimaryPak) {
        this.commonComponentRequiresFromPrimaryPak = commonComponentRequiresFromPrimaryPak;
    }

    public String getPrimaryPakName() {
        return this.primaryPakName;
    }

    public void setPrimaryPakName(String primaryPakName) {
        this.primaryPakName = primaryPakName;
    }

    public String getAllUninstallableCommonComponentBackupPaksURIs() {
        Logr.methodEntry(className, "getAllUninstallableCommonComponentBackupPaksURIs");
        String sMsg = "The uninstallable backup package URIs is: " + this.allUninstallableCommonComponentBackupPaksURIs;
        Logr.debug(sMsg);
        Logr.methodReturn(className, "getAllUninstallableCommonComponentBackupPaksURIs", this.allUninstallableCommonComponentBackupPaksURIs);
        return this.allUninstallableCommonComponentBackupPaksURIs;
    }

    public Vector getAllUninstallableNIFPackageList() {
        return this.allUninstallableNIFPackageList;
    }

    private void init() {
        Logr.methodEntry(className, "init");
        String sMsg = null;
        String[] commonComponentDependsOnString = StringUtils.convertStringToTokenArray(this.commonComponentRequiresFromPrimaryPak, ";");
        HashSet<String> ccIDSetFromPrimaryPakUninstall = new HashSet<String>();
        String[] stringArray = commonComponentDependsOnString;
        int n = commonComponentDependsOnString.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            String currentCCID = DependsOnUtils.getPayloadid(element);
            sMsg = "Current CCID from commoncomponentrequires param: " + currentCCID;
            Logr.debug(sMsg);
            if (!ccIDSetFromPrimaryPakUninstall.contains(currentCCID)) {
                CommonComponent currentCommonComponentObj = new CommonComponent(currentCCID);
                this.commonComponentInfoMap.put(currentCCID, currentCommonComponentObj);
            } else {
                sMsg = "There are more than one CCID-version pairs for CCID: " + currentCCID + " in commoncomponentrequires parameter. This pair: " + element + "  is ignored.";
                Logr.debug(sMsg);
            }
            ccIDSetFromPrimaryPakUninstall.add(currentCCID);
            ++n2;
        }
        Vector stackElementsWithoutCurrentPrimaryPak = new Vector();
        stackElementsWithoutCurrentPrimaryPak.addAll(this.allNIFStackElements);
        NIFPackageEntry currentPrimaryPakEntry = NIFStack.getElementWithThisNIFPackageName(this.primaryPakName);
        sMsg = "The primary pak file name to be uninstalled or rollback is: " + this.primaryPakName;
        Logr.debug(sMsg);
        if (currentPrimaryPakEntry == null) {
            sMsg = "Current primary pak with name: " + this.primaryPakName + " does not exist in the stack.";
            Logr.debug(sMsg);
            return;
        }
        sMsg = "Remove the current primary pak with name: " + this.primaryPakName + " from the cloned stack.";
        Logr.debug(sMsg);
        stackElementsWithoutCurrentPrimaryPak.remove(currentPrimaryPakEntry);
        for (NIFPackageEntry currentPackageEntry : stackElementsWithoutCurrentPrimaryPak) {
            if (currentPackageEntry.getParamValue("wasinstalledasprimary").equals(Boolean.TRUE.toString())) {
                String currentCCRequiresThisPrimaryPak = currentPackageEntry.getParamValue("commonComponentRequires");
                sMsg = "commoncomponentrequires param value of current primary pak: " + currentPackageEntry.getNIFPackageName() + ", is: " + currentCCRequiresThisPrimaryPak;
                Logr.debug(sMsg);
                String[] currentPrimaryPakCCDependsOnString = StringUtils.convertStringToTokenArray(currentCCRequiresThisPrimaryPak, ";");
                HashSet<String> ccIDSetFromCurrentCCRequiresThisPrimaryPak = new HashSet<String>();
                String[] stringArray2 = currentPrimaryPakCCDependsOnString;
                int n3 = currentPrimaryPakCCDependsOnString.length;
                int n4 = 0;
                while (n4 < n3) {
                    String element = stringArray2[n4];
                    String currentCCID = DependsOnUtils.getPayloadid(element);
                    if (!ccIDSetFromCurrentCCRequiresThisPrimaryPak.contains(currentCCID)) {
                        if (this.commonComponentInfoMap.keySet().contains(currentCCID)) {
                            String currentCCVersion = DependsOnUtils.getBaseVersion(DependsOnUtils.getComparingString(element));
                            CommonComponent commonComponentObjThisCCID = (CommonComponent)this.commonComponentInfoMap.get(currentCCID);
                            commonComponentObjThisCCID.setMinRequiredVersion(currentCCVersion);
                            this.commonComponentInfoMap.put(currentCCID, commonComponentObjThisCCID);
                            sMsg = "This CCID: " + currentCCID + " at this version: " + currentCCVersion + " is required by the current primary pak.";
                            Logr.debug(sMsg);
                        }
                    } else {
                        sMsg = "There are more than one CCID-version pairs for CCID: " + currentCCID + " in commoncomponentrequires parameter in this primary pak: " + currentPackageEntry.getNIFPackageName() + ". This pair: " + element + "  is ignored.";
                        Logr.debug(sMsg);
                    }
                    ccIDSetFromCurrentCCRequiresThisPrimaryPak.add(currentCCID);
                    ++n4;
                }
                continue;
            }
            String targetSubProductIDString = currentPackageEntry.getParamValue("targetsubproductids");
            Vector targetSubProductIDList = StringUtils.convertStringToTokenVector(targetSubProductIDString, ";");
            if (targetSubProductIDList.retainAll(ccIDSetFromPrimaryPakUninstall) || targetSubProductIDList.isEmpty()) continue;
            String currentCCID = (String)targetSubProductIDList.elementAt(0);
            CommonComponent commonComponentObjThisCCID = (CommonComponent)this.commonComponentInfoMap.get(currentCCID);
            commonComponentObjThisCCID.addCommonComponentPackEntry(currentPackageEntry);
            this.commonComponentInfoMap.put(currentCCID, commonComponentObjThisCCID);
            sMsg = "The current satellite pak with name: " + currentPackageEntry.getNIFPackageName() + " is a common component with CCID:  " + currentCCID;
            Logr.debug(sMsg);
        }
        TreeMap allUninstallableCCBackupPackagesURIsMap = new TreeMap();
        TreeMap allUninstallableNIFPackageEntryMap = new TreeMap();
        for (String currentCCID : this.commonComponentInfoMap.keySet()) {
            TreeMap uninstallableCCBackupPakURIMapPerCCID = ((CommonComponent)this.commonComponentInfoMap.get(currentCCID)).getUninstallableBackupPackagesURIsMap();
            allUninstallableCCBackupPackagesURIsMap.putAll(uninstallableCCBackupPakURIMapPerCCID);
            allUninstallableNIFPackageEntryMap.putAll(((CommonComponent)this.commonComponentInfoMap.get(currentCCID)).getUninstallableNIFPackageEntryMap());
        }
        Vector allUninstallableCCBackupPackagesURIs = new Vector();
        allUninstallableCCBackupPackagesURIs.addAll(allUninstallableCCBackupPackagesURIsMap.values());
        String[] URIsInDecendingOrder = new String[allUninstallableCCBackupPackagesURIs.size()];
        int i = 0;
        while (i < allUninstallableCCBackupPackagesURIs.size()) {
            URIsInDecendingOrder[i] = (String)allUninstallableCCBackupPackagesURIs.elementAt(allUninstallableCCBackupPackagesURIs.size() - i - 1);
            ++i;
        }
        this.allUninstallableCommonComponentBackupPaksURIs = StringUtils.convertStringArrayToTokenString(URIsInDecendingOrder, ";");
        this.allUninstallableNIFPackageList.addAll(allUninstallableNIFPackageEntryMap.values());
        Logr.methodExit(className, "init");
    }
}

