/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.componentactions;

import com.ibm.ws.pak.internal.utils.componentactions.ComponentizedRepositoryConstants;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.installtoolkitbridge.InstallToolkitBridge;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;

public class ComponentMapParser {
    private FileSystemEntry m_fseComponentMapPath = null;
    private String m_sComponentMapContents = null;

    public ComponentMapParser(FileSystemEntry fseComponentMapPath, InstallToolkitBridge itb) {
        this.m_fseComponentMapPath = fseComponentMapPath;
    }

    public String getFeatureID() throws IOException {
        String sComponentMapContents = this.getComponentMapContents();
        Matcher matcherFeatureID = ComponentizedRepositoryConstants.PATTERN_FEATURE_ID.matcher(sComponentMapContents);
        if (matcherFeatureID.find()) {
            return matcherFeatureID.group(1);
        }
        return null;
    }

    public void addComponent(String sComponentName) throws IOException {
        if (this.getSetOfComponentsInThisComponentMap().contains(sComponentName)) {
            return;
        }
        String sComponentMapContents = this.getComponentMapContents();
        Matcher matcherAppender = ComponentizedRepositoryConstants.PATTERN_TO_APPEND_TO_COMPONENT_MAP.matcher(sComponentMapContents);
        sComponentMapContents = matcherAppender.replaceFirst("\t\t<component>" + sComponentName + "</component>\n\t</feature>");
        this.m_fseComponentMapPath.writeUTF8(sComponentMapContents, false);
        this.refreshComponentMapContents();
    }

    public Set getSetOfComponentsInThisComponentMap() throws IOException {
        String sComponentMapContents = this.getComponentMapContents();
        Matcher matcherComponents = ComponentizedRepositoryConstants.PATTERN_COMPONENT_LIST.matcher(sComponentMapContents);
        TreeSet<String> setComponents = new TreeSet<String>();
        while (matcherComponents.find()) {
            String sComponentNameThis = matcherComponents.group(1);
            setComponents.add(sComponentNameThis);
        }
        return setComponents;
    }

    public Set getSetOfFeaturesInThisComponentMap() throws IOException {
        String sComponentMapContents = this.getComponentMapContents();
        Matcher matcherComponents = ComponentizedRepositoryConstants.PATTERN_FEATURE_ID.matcher(sComponentMapContents);
        TreeSet<String> setComponents = new TreeSet<String>();
        while (matcherComponents.find()) {
            String sComponentNameThis = matcherComponents.group(1);
            setComponents.add(sComponentNameThis);
        }
        return setComponents;
    }

    private String getComponentMapContents() throws IOException {
        if (this.m_sComponentMapContents == null) {
            this.m_sComponentMapContents = this.m_fseComponentMapPath.getContents();
        }
        return this.m_sComponentMapContents;
    }

    private void refreshComponentMapContents() throws IOException {
        this.m_sComponentMapContents = null;
        this.getComponentMapContents();
    }
}

