/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Checksum {
    private static final String S_EMPTY = "";
    private static final int N_IO_BUFFER_SIZE = 4096;
    static char[] A_C_HEX_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String getChecksum(File filePath, String sAlgorithm) throws NoSuchAlgorithmException, FileNotFoundException, IOException {
        return Checksum.getChecksum(new FileInputStream(filePath), sAlgorithm);
    }

    public static String getChecksum(InputStream in, String sAlgorithm) throws NoSuchAlgorithmException, FileNotFoundException, IOException {
        MessageDigest messagedigest = MessageDigest.getInstance(sAlgorithm);
        byte[] abBuffer = new byte[4096];
        int nBytesRead = in.read(abBuffer);
        while (nBytesRead != -1) {
            messagedigest.update(abBuffer, 0, nBytesRead);
            nBytesRead = in.read(abBuffer);
        }
        in.close();
        return Checksum.convertByteArrayToHexString(messagedigest.digest());
    }

    private static String convertByteArrayToHexString(byte[] ab) {
        String sHex = S_EMPTY;
        byte[] byArray = ab;
        int n = ab.length;
        int n2 = 0;
        while (n2 < n) {
            byte element = byArray[n2];
            int nHighNibble = (element & 0xF0) >>> 4;
            int nLowNibble = element & 0xF;
            sHex = String.valueOf(sHex) + A_C_HEX_CHAR[nHighNibble] + A_C_HEX_CHAR[nLowNibble];
            ++n2;
        }
        return sHex;
    }
}

