/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.install.registry;

import com.ibm.ws.pak.internal.install.registry.NIFRegistryProductInfo;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NIFRegistryProductFile {
    private FileSystemEntry m_fseProductFile = null;
    private final Vector m_vProductInfoVec = new Vector(1);
    private static final String PATTERN_PRODUCT_NODE = "<product\\s*(.*?)\\s*</product>";
    private static final String PATTERN_NAME = "name=\"(.*?)\"";
    private static final String PATTERN_ID = "<id>\\s*(.*?)\\s*</id>";
    private static final String PATTERN_VERSION = "<version>\\s*(.*?)\\s*</version>";
    private static final String PATTERN_DATE = "date=\"(.*?)\"";
    private static final String PATTERN_LEVEL = "level=\"(.*?)\"";
    private final String className = "NIFRegistryProductFile";

    public NIFRegistryProductFile(FileSystemEntry fseProductFile) {
        this.m_fseProductFile = fseProductFile;
        this.parse();
    }

    public NIFRegistryProductInfo[] getProductInfoArray() {
        NIFRegistryProductInfo[] awaspiThis = new NIFRegistryProductInfo[this.m_vProductInfoVec.size()];
        int i = 0;
        while (i < awaspiThis.length) {
            awaspiThis[i] = (NIFRegistryProductInfo)this.m_vProductInfoVec.elementAt(i);
            ++i;
        }
        return awaspiThis;
    }

    private void parse() {
        String sFileContent = this.readFile(this.m_fseProductFile);
        if (sFileContent == null) {
            return;
        }
        Pattern productPattern = Pattern.compile(PATTERN_PRODUCT_NODE, 32);
        Matcher productMatcher = productPattern.matcher(sFileContent);
        while (productMatcher.find()) {
            String productString = productMatcher.group();
            this.parseProductString(productString);
        }
    }

    private void parseProductString(String productString) {
        String name = "";
        String id = "";
        String version = "";
        String date = "";
        String level = "";
        Pattern pattern = Pattern.compile(PATTERN_NAME, 32);
        Matcher matcher = pattern.matcher(productString);
        if (matcher.find()) {
            String nameString = matcher.group();
            name = nameString.substring(nameString.indexOf(34) + 1, nameString.lastIndexOf(34));
        }
        if ((matcher = (pattern = Pattern.compile(PATTERN_ID, 32)).matcher(productString)).find()) {
            String idString = matcher.group();
            id = idString.substring(idString.indexOf("<id>") + 4, idString.indexOf("</id>"));
        }
        if ((matcher = (pattern = Pattern.compile(PATTERN_VERSION, 32)).matcher(productString)).find()) {
            String versionString = matcher.group();
            version = versionString.substring(versionString.indexOf("<version>") + 9, versionString.indexOf("</version>"));
        }
        if ((matcher = (pattern = Pattern.compile(PATTERN_DATE, 32)).matcher(productString)).find()) {
            String dateString = matcher.group();
            date = dateString.substring(dateString.indexOf(34) + 1, dateString.lastIndexOf(34));
        }
        if ((matcher = (pattern = Pattern.compile(PATTERN_LEVEL, 32)).matcher(productString)).find()) {
            String levelString = matcher.group();
            level = levelString.substring(levelString.indexOf(34) + 1, levelString.lastIndexOf(34));
        }
        NIFRegistryProductInfo info = new NIFRegistryProductInfo(name, id, version, date, level);
        this.m_vProductInfoVec.addElement(info);
    }

    private String readFile(FileSystemEntry fseProductFile) {
        String fileContents = null;
        try {
            InputStream inputStream = fseProductFile.getInputStream();
            byte[] abTotal = new byte[inputStream.available()];
            inputStream.read(abTotal);
            fileContents = new String(abTotal, "UTF-8");
            inputStream.close();
        }
        catch (IOException e) {
            Logr.warn("NIFRegistryProductFile", "readFile", e.getMessage(), e);
        }
        return fileContents;
    }
}

