/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.install.registry;

import com.ibm.ws.pak.internal.utils.SimpleXMLParser;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NIFRegistryObjectEntry {
    private String m_sNIFRegistryObjectName = null;
    private final LinkedHashMap m_linkedhashmapAttributes = new LinkedHashMap();
    private final LinkedHashMap m_linkedhashmapParams = new LinkedHashMap();

    public NIFRegistryObjectEntry() {
    }

    public NIFRegistryObjectEntry(Node nodeObjectEntry) {
        this.m_sNIFRegistryObjectName = nodeObjectEntry.getNodeName();
        NamedNodeMap namednodemapAttributes = nodeObjectEntry.getAttributes();
        int nNumberOfAttributes = namednodemapAttributes.getLength();
        int i = 0;
        while (i < nNumberOfAttributes) {
            String sAttribName = namednodemapAttributes.item(i).getNodeName();
            String sAttribValue = namednodemapAttributes.item(i).getNodeValue();
            this.m_linkedhashmapAttributes.put(sAttribName, sAttribValue);
            ++i;
        }
        this.setLinkedHashMapParamsForThisNode(nodeObjectEntry);
    }

    public void addThisNIFRegistryEntryToThisDocument(Node nodeParent) throws ParserConfigurationException {
        Element elementThisRegistryEntry = null;
        if (!this.m_linkedhashmapAttributes.isEmpty()) {
            elementThisRegistryEntry = SimpleXMLParser.addNestedElement(this.m_sNIFRegistryObjectName, null, new Hashtable(this.m_linkedhashmapAttributes), nodeParent);
        }
        if (!this.m_linkedhashmapParams.isEmpty()) {
            for (String sParamName : this.m_linkedhashmapParams.keySet()) {
                Object oParamAttributes = this.m_linkedhashmapParams.get(sParamName);
                if (oParamAttributes.getClass().getName().equals(Vector.class.getName())) {
                    for (Hashtable hashtableAttributes : (Vector)oParamAttributes) {
                        SimpleXMLParser.addNestedElement("param", null, hashtableAttributes, elementThisRegistryEntry);
                    }
                    continue;
                }
                Hashtable hashtableAttributes = (Hashtable)oParamAttributes;
                SimpleXMLParser.addNestedElement("param", null, hashtableAttributes, elementThisRegistryEntry);
            }
        }
    }

    public boolean doesThisNodeRepresentThisRegistryEntry(Node nodeThis) {
        Map mapRegistryAttributes = this.getAttributesMap();
        for (String sAttributeNameFromRegistryEntry : mapRegistryAttributes.keySet()) {
            String sAttributeValueFromRegistryEntry = this.getAttribute(sAttributeNameFromRegistryEntry);
            String sAttributeValueFromNode = SimpleXMLParser.getNodeAttributeValue(nodeThis, sAttributeNameFromRegistryEntry);
            if (sAttributeValueFromNode != null && sAttributeValueFromNode.equals(sAttributeValueFromRegistryEntry)) continue;
            return false;
        }
        return true;
    }

    public String getNIFRegistryObjectName() {
        return this.m_sNIFRegistryObjectName;
    }

    protected void setNIFRegistryObjectName(String sObjectName) {
        this.m_sNIFRegistryObjectName = sObjectName;
    }

    protected String getAttribute(String sAttribName) {
        return (String)this.m_linkedhashmapAttributes.get(sAttribName);
    }

    protected void setAttribute(String sAttribName, String sAttribValue) {
        this.m_linkedhashmapAttributes.put(sAttribName, sAttribValue);
    }

    protected String removeAttribute(String sAttribName) {
        return this.m_linkedhashmapAttributes.remove(sAttribName).toString();
    }

    protected Map getAttributesMap() {
        return this.m_linkedhashmapAttributes;
    }

    protected void SetAttributesMap(Map mapAttributes) {
        this.m_linkedhashmapAttributes.putAll(mapAttributes);
    }

    protected Hashtable[] getParameterValues(String sParamName) {
        Object oParamValues = this.m_linkedhashmapParams.get(sParamName);
        if (oParamValues != null) {
            Vector vParamValue = (Vector)oParamValues;
            int nNumOfParamWithThisName = vParamValue.size();
            Hashtable[] ahashtableReturn = new Hashtable[nNumOfParamWithThisName];
            int i = 0;
            while (i < nNumOfParamWithThisName) {
                ahashtableReturn[i] = (Hashtable)vParamValue.elementAt(i);
                ++i;
            }
            return ahashtableReturn;
        }
        return null;
    }

    protected boolean addParameterValue(String sParamName, Hashtable hashtableParamAttributes) {
        return this.addThisParamAttributesToExistingAttributes(this.m_linkedhashmapParams, sParamName, hashtableParamAttributes);
    }

    protected boolean updateParameterValue(String sParamName, Hashtable hashtableAttributesSource, Hashtable hashtableAttributesTarget) {
        return this.updateThisParamAttributesFromExistingAttributes(this.m_linkedhashmapParams, sParamName, hashtableAttributesSource, hashtableAttributesTarget);
    }

    protected boolean removeParameterValue(String sParamName, Hashtable hashtableParamAttributes) {
        return this.removeThisParamAttributesFromExistingAttributes(this.m_linkedhashmapParams, sParamName, hashtableParamAttributes);
    }

    private boolean addThisParamAttributesToExistingAttributes(LinkedHashMap linkedhashmapParams, String sParamName, Hashtable hashtableParamAttributes) {
        if (sParamName != null) {
            Vector vAttributes = new Vector();
            Object oExistingAttributes = linkedhashmapParams.get(sParamName);
            if (oExistingAttributes != null) {
                vAttributes = (Vector)oExistingAttributes;
                vAttributes.add(hashtableParamAttributes);
            } else {
                vAttributes.add(hashtableParamAttributes);
            }
            linkedhashmapParams.put(sParamName, vAttributes);
            return true;
        }
        return false;
    }

    private boolean updateThisParamAttributesFromExistingAttributes(LinkedHashMap linkedhashmapParams, String sParamName, Hashtable hashtableAttributesSource, Hashtable hashtableAttributesTarget) {
        if (sParamName != null) {
            int nIndexThisAttrib;
            Vector vAttributes = new Vector();
            Object oExistingAttributes = linkedhashmapParams.get(sParamName);
            if (oExistingAttributes != null && (nIndexThisAttrib = (vAttributes = (Vector)oExistingAttributes).indexOf(hashtableAttributesSource)) > -1) {
                vAttributes.setElementAt(hashtableAttributesTarget, nIndexThisAttrib);
                linkedhashmapParams.put(sParamName, vAttributes);
                return true;
            }
        }
        return false;
    }

    private boolean removeThisParamAttributesFromExistingAttributes(LinkedHashMap linkedhashmapParams, String sParamName, Hashtable hashtableParamAttributes) {
        if (sParamName != null) {
            Vector vAttributes = new Vector();
            Object oExistingAttributes = linkedhashmapParams.get(sParamName);
            if (oExistingAttributes != null) {
                vAttributes = (Vector)oExistingAttributes;
                vAttributes.remove(hashtableParamAttributes);
                if (!vAttributes.isEmpty()) {
                    linkedhashmapParams.put(sParamName, vAttributes);
                } else {
                    linkedhashmapParams.remove(sParamName);
                }
                return true;
            }
        }
        return false;
    }

    private Hashtable getAttributesFromParamNode(Node nodeParamThis) {
        Hashtable<String, String> hashtableAttributesThisParamNode = new Hashtable<String, String>();
        NamedNodeMap namednodemapAttributesThisParamNode = nodeParamThis.getAttributes();
        int nNumberOfAttributes = namednodemapAttributesThisParamNode.getLength();
        int i = 0;
        while (i < nNumberOfAttributes) {
            String sAttribName = namednodemapAttributesThisParamNode.item(i).getNodeName();
            String sAttribValue = namednodemapAttributesThisParamNode.item(i).getNodeValue();
            hashtableAttributesThisParamNode.put(sAttribName, sAttribValue);
            ++i;
        }
        return hashtableAttributesThisParamNode;
    }

    private void setLinkedHashMapParamsForThisNode(Node nodeThis) {
        Vector vnodesParams = SimpleXMLParser.getAllNamedChildNodes(nodeThis, "param");
        int i = 0;
        while (i < vnodesParams.size()) {
            Node nodeParamThis = (Node)vnodesParams.elementAt(i);
            String sParamName = SimpleXMLParser.getNodeAttributeValue(nodeParamThis, "name");
            Hashtable hashtableParamNodeAttributes = this.getAttributesFromParamNode(nodeParamThis);
            this.addThisParamAttributesToExistingAttributes(this.m_linkedhashmapParams, sParamName, hashtableParamNodeAttributes);
            ++i;
        }
    }
}

