/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.install.metadata;

import com.ibm.ws.pak.internal.install.metadata.NIFPackageEntry;
import com.ibm.ws.pak.internal.utils.DependsOnUtils;
import com.ibm.ws.pak.internal.utils.SimpleXMLParser;
import com.ibm.ws.pak.internal.utils.StringUtils;
import com.ibm.ws.pak.internal.utils.VersionUtils;
import com.ibm.ws.pak.internal.utils.XMLUtils;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.installtoolkitbridge.InstallToolkitBridge;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class NIFStack {
    private static Vector m_vnifpeContainer = null;
    private static FileSystemEntry m_fseBackupRepositoryDir = null;
    private static FileSystemEntry m_fseStackXml = null;
    private static boolean m_fIsOpen = false;
    private static boolean m_fIsFeaturesSet = false;
    private static final String S_PATH_MAINTENANCE = "maintenance-stack/maintenance";
    private static final String S_EMPTY = "";
    private static final String className = "NIFStack";

    public static void open(FileSystemEntry fseUPDIBackupRepositoryDir, InstallToolkitBridge itb) throws IOException, ParserConfigurationException, SAXException {
        Logr.methodEntry(className, "open");
        if (m_fseBackupRepositoryDir != null && m_fseBackupRepositoryDir.equals(fseUPDIBackupRepositoryDir)) {
            return;
        }
        m_fseBackupRepositoryDir = fseUPDIBackupRepositoryDir;
        m_fseStackXml = NIFStack.createStackXMLFileSystemEntry(m_fseBackupRepositoryDir, itb);
        NIFStack.readStack();
        NIFStack.sortStackElementContainer();
        m_fIsFeaturesSet = false;
        m_fIsOpen = true;
        Logr.methodExit(className, "open");
    }

    public static void reset(InstallToolkitBridge itb) throws IOException, ParserConfigurationException, SAXException {
        Logr.methodEntry(className, "reset");
        if (NIFStack.isOpen()) {
            NIFStack.open(m_fseBackupRepositoryDir, itb);
        }
    }

    public static void setParamValue(String sTargetMaintenanceName, String sTargetParam, String sTargetValue) throws IOException, ParserConfigurationException {
        Logr.methodEntry(className, "setParamValue");
        NIFPackageEntry nifpeTargetEntry = NIFStack.find(sTargetMaintenanceName);
        if (nifpeTargetEntry == null) {
            return;
        }
        String sExistingValue = nifpeTargetEntry.getParamValue(sTargetParam);
        if (sExistingValue == null || !sExistingValue.equals(sTargetValue)) {
            nifpeTargetEntry.setParam(sTargetParam, sTargetValue);
            NIFStack.commit();
        }
        Logr.methodExit(className, "setParamValue");
    }

    public static void setParamValue(String sTargetMaintenanceName, String sTargetParam, String sTargetValue, boolean fTreatMaintenanceNameAsARegexp) throws IOException, ParserConfigurationException {
        Logr.methodEntry(className, "setParamValue");
        if (!fTreatMaintenanceNameAsARegexp) {
            NIFStack.setParamValue(sTargetMaintenanceName, sTargetParam, sTargetValue);
            return;
        }
        NIFPackageEntry[] anifpeTargetEntry = NIFStack.findAllEntriesWhoseNamesMatchThisRegrep(sTargetMaintenanceName);
        if (anifpeTargetEntry == null || anifpeTargetEntry.length == 0) {
            return;
        }
        boolean fNeedCommit = false;
        NIFPackageEntry[] nIFPackageEntryArray = anifpeTargetEntry;
        int n = anifpeTargetEntry.length;
        int n2 = 0;
        while (n2 < n) {
            NIFPackageEntry element = nIFPackageEntryArray[n2];
            String sExistingValue = element.getParamValue(sTargetParam);
            if (sExistingValue == null || !sExistingValue.equals(sTargetValue)) {
                element.setParam(sTargetParam, sTargetValue);
                fNeedCommit = true;
            }
            ++n2;
        }
        if (fNeedCommit) {
            NIFStack.commit();
        }
        Logr.methodExit(className, "setParamValue");
    }

    private static NIFPackageEntry[] findAllEntriesWhoseNamesMatchThisRegrep(String sNameRegrep) {
        Logr.methodEntry(className, "findAllEntriesWhoseNamesMatchThisRegrep");
        if (m_vnifpeContainer == null || m_vnifpeContainer.size() == 0) {
            return new NIFPackageEntry[0];
        }
        Vector<NIFPackageEntry> vnifpeReturn = new Vector<NIFPackageEntry>();
        int i = 0;
        while (i < m_vnifpeContainer.size()) {
            NIFPackageEntry nifpeThis = (NIFPackageEntry)m_vnifpeContainer.elementAt(i);
            String sNameThis = nifpeThis.getNIFPackageName();
            if (Pattern.matches(sNameRegrep, sNameThis)) {
                vnifpeReturn.add(nifpeThis);
            }
            ++i;
        }
        Logr.methodExit(className, "findAllEntriesWhoseNamesMatchThisRegrep");
        return vnifpeReturn.toArray(new NIFPackageEntry[vnifpeReturn.size()]);
    }

    public static String getFilenameOfHighestPrimaryPAK() {
        Logr.methodEntry(className, "getFilenameOfHighestPrimaryPAK");
        NIFStack.sortStackElementContainer();
        int i = m_vnifpeContainer.size() - 1;
        while (i >= 0) {
            NIFPackageEntry nifpeThis = (NIFPackageEntry)m_vnifpeContainer.elementAt(i);
            String sIsPrimary = nifpeThis.getParamValue("wasinstalledasprimary");
            if (sIsPrimary == null || !sIsPrimary.equalsIgnoreCase(Boolean.FALSE.toString())) {
                Logr.methodReturn(className, "getFilenameOfHighestPrimaryPAK", nifpeThis.getParamValue("filename"));
                return nifpeThis.getParamValue("filename");
            }
            --i;
        }
        Logr.methodReturn(className, "getFilenameOfHighestPrimaryPAK", null);
        return null;
    }

    public static String getFilenameOfHighestMaintenancePrimaryPAK() {
        Logr.methodEntry(className, "getFilenameOfHighestMaintenancePrimaryPAK");
        NIFStack.sortStackElementContainer();
        int i = m_vnifpeContainer.size() - 1;
        while (i >= 0) {
            String sIsInstalledAsMaintenance;
            NIFPackageEntry nifpeThis = (NIFPackageEntry)m_vnifpeContainer.elementAt(i);
            String sIsPrimary = nifpeThis.getParamValue("wasinstalledasprimary");
            if (!(sIsPrimary != null && sIsPrimary.equalsIgnoreCase(Boolean.FALSE.toString()) || (sIsInstalledAsMaintenance = nifpeThis.getParamValue("wasinstalledasmaintenance")) != null && sIsInstalledAsMaintenance.trim().equalsIgnoreCase(Boolean.FALSE.toString()))) {
                Logr.methodReturn(className, "getFilenameOfHighestMaintenancePrimaryPAK", nifpeThis.getParamValue("filename"));
                return nifpeThis.getParamValue("filename");
            }
            --i;
        }
        Logr.methodReturn(className, "getFilenameOfHighestMaintenancePrimaryPAK", null);
        return null;
    }

    public static boolean isFeatureInStack(String sFeatureId) {
        Logr.methodEntry(className, "isFeatureInStack");
        boolean b = NIFStack.findAllFeaturesInStack().contains(sFeatureId);
        Logr.methodReturn(className, "isFeatureInStack", new Boolean(b).toString());
        return b;
    }

    public static boolean isNIFPackage1InstalledBeforeNIFPackage2(String sNIFPackage1, String sNIFPackage2) {
        Logr.methodEntry(className, "isNIFPackage1InstalledBeforeNIFPackage2");
        int index1 = NIFStack.getIndexOf(sNIFPackage1);
        int index2 = NIFStack.getIndexOf(sNIFPackage2);
        Logr.methodReturn(className, "isNIFPackage1InstalledBeforeNIFPackage2", new Boolean(index1 < index2).toString());
        return index1 < index2;
    }

    public static NIFPackageEntry setAndEnsureItWithHighestOrder(String sName, String sTargetproductids, String sTargetsubproductids, String sIsofficialfix, String sApars, String sIsbackuppackage, String sIscopyjdkrequired, String sAutouninstallable, String sBuilddate, String sSupercedes, String sSupercedesapars, String sHasprofileupdates, String sInfo, String sFilename, String sUninstallableByUPDI, String sWasinstalledasprimary, String sPackagetype, String sWasinstalledasmainetance, String sPayloadid, String sPakversion, String sIsenablingifix, String sUritoreinstall, String sDependson, String sTargetOSandArchs, String sProductType, String sCommonComponentRequires) {
        Logr.methodEntry(className, "setAndEnsureItWithHighestOrder");
        int i = 0;
        while (i < m_vnifpeContainer.size()) {
            NIFPackageEntry meEntryThis = (NIFPackageEntry)m_vnifpeContainer.elementAt(i);
            String sNameThis = meEntryThis.getNIFPackageName();
            if (sName.equals(sNameThis)) {
                meEntryThis.setOrder(m_vnifpeContainer.size());
                NIFStack.sortStackElementContainer();
                return meEntryThis;
            }
            ++i;
        }
        NIFPackageEntry meEntry = new NIFPackageEntry(sName, m_vnifpeContainer.size());
        if (sTargetproductids != null) {
            meEntry.addParam("targetproductids", sTargetproductids);
        }
        if (sTargetsubproductids != null) {
            meEntry.addParam("targetsubproductids", sTargetsubproductids);
        }
        if (sIsofficialfix != null) {
            meEntry.addParam("isofficialfix", sIsofficialfix);
        }
        if (sApars != null) {
            meEntry.addParam("apars", sApars);
        }
        if (sIsbackuppackage != null) {
            meEntry.addParam("isbackuppackage", sIsbackuppackage);
        }
        if (sIscopyjdkrequired != null) {
            meEntry.addParam("iscopyjdkrequired", sIscopyjdkrequired);
        }
        if (sAutouninstallable != null) {
            meEntry.addParam("autouninstallable", sAutouninstallable);
        }
        if (sBuilddate != null) {
            meEntry.addParam("builddate", sBuilddate);
        }
        if (sSupercedes != null) {
            meEntry.addParam("supercedes", sSupercedes);
        }
        if (sSupercedesapars != null) {
            meEntry.addParam("supercedesapars", sSupercedesapars);
        }
        if (sHasprofileupdates != null) {
            meEntry.addParam("hasprofileupdates", sHasprofileupdates);
        }
        if (sInfo != null) {
            meEntry.addParam("info", sInfo);
        }
        if (sFilename != null) {
            meEntry.addParam("filename", sFilename);
        }
        if (sUninstallableByUPDI != null) {
            meEntry.addParam("uninstallablebyupdi", sUninstallableByUPDI);
        }
        if (sWasinstalledasprimary != null) {
            meEntry.addParam("wasinstalledasprimary", sWasinstalledasprimary);
        }
        if (sPackagetype != null) {
            meEntry.addParam("packagetype", sPackagetype);
        }
        if (sWasinstalledasmainetance != null) {
            meEntry.addParam("wasinstalledasmaintenance", sWasinstalledasmainetance);
        }
        if (sPayloadid != null) {
            meEntry.addParam("payloadid", sPayloadid);
        }
        if (sPakversion != null) {
            meEntry.addParam("pakversion", sPakversion);
        }
        if (sProductType != null) {
            meEntry.addParam("producttype", sProductType);
        }
        if (sIsenablingifix != null) {
            meEntry.addParam("isenablingifix", sIsenablingifix);
        }
        if (sUritoreinstall != null) {
            meEntry.addParam("uritoreinstall", sUritoreinstall);
        }
        if (sDependson != null) {
            meEntry.addParam("dependsOn", sDependson);
        }
        if (sTargetOSandArchs != null) {
            meEntry.addParam("targetOSandArchs", sTargetOSandArchs);
        }
        if (sCommonComponentRequires != null) {
            meEntry.addParam("commonComponentRequires", sCommonComponentRequires);
        }
        m_vnifpeContainer.add(meEntry);
        Logr.methodExit(className, "setAndEnsureItWithHighestOrder");
        return meEntry;
    }

    public static void addParamEntryToHighestOrderElement(String sParamName, String sParamValue) {
        Logr.methodEntry(className, "addParamEntryToHighestOrderElement");
        if (m_vnifpeContainer.size() == 0) {
            return;
        }
        NIFPackageEntry nifpe = (NIFPackageEntry)m_vnifpeContainer.lastElement();
        nifpe.addParam(sParamName, sParamValue);
        Logr.methodExit(className, "addParamEntryToHighestOrderElement");
    }

    public static boolean isElementAlreadyThere(NIFPackageEntry nifpeElement) {
        Logr.methodEntry(className, "isElementAlreadyThere");
        int nIndex = NIFStack.getIndexOf(nifpeElement);
        return nIndex != -1;
    }

    public static boolean isElementAlreadyThere(String sNIFPackageName) {
        Logr.methodEntry(className, "isElementAlreadyThere");
        int nIndex = NIFStack.getIndexOf(sNIFPackageName);
        return nIndex != -1;
    }

    public static boolean isEntryUninstallableByUPDI(String sFilename) {
        Logr.methodEntry(className, "isEntryUninstallableByUPDI");
        int i = 0;
        while (i < m_vnifpeContainer.size()) {
            NIFPackageEntry mseThis = (NIFPackageEntry)m_vnifpeContainer.elementAt(i);
            String sFilenameThis = mseThis.getParamValue("filename");
            if (sFilenameThis != null && sFilenameThis.equals(sFilename)) {
                String sUninstallableByUPDI = mseThis.getParamValue("uninstallablebyupdi");
                if (sUninstallableByUPDI == null) {
                    return true;
                }
                return new Boolean(sUninstallableByUPDI);
            }
            ++i;
        }
        Logr.methodExit(className, "isEntryUninstallableByUPDI");
        return true;
    }

    public static String getMaintenanceName(String sFilename) {
        Logr.methodEntry(className, "getMaintenanceName");
        int i = m_vnifpeContainer.size() - 1;
        while (i >= 0) {
            NIFPackageEntry mseThis = (NIFPackageEntry)m_vnifpeContainer.elementAt(i);
            String sFilenameThis = mseThis.getParamValue("filename");
            if (sFilenameThis != null && sFilenameThis.equals(sFilename)) {
                Logr.methodReturn(className, "getMaintenanceName", mseThis.getNIFPackageName());
                return mseThis.getNIFPackageName();
            }
            --i;
        }
        Logr.methodReturn(className, "getMaintenanceName", null);
        return null;
    }

    public static NIFPackageEntry getElementWithThisNIFPackageName(String sNIFPackageName) {
        Logr.methodEntry(className, "getElementWithThisNIFPackageName");
        int i = 0;
        while (i < m_vnifpeContainer.size()) {
            NIFPackageEntry nifpeThis = (NIFPackageEntry)m_vnifpeContainer.elementAt(i);
            if (nifpeThis.getNIFPackageName().equals(sNIFPackageName)) {
                return nifpeThis;
            }
            ++i;
        }
        Logr.methodExit(className, "getElementWithThisNIFPackageName");
        return null;
    }

    public static void remove(String sNIFPackageName) {
        Logr.methodEntry(className, "remove");
        if (NIFStack.isElementAlreadyThere(sNIFPackageName)) {
            int nIndexOf = NIFStack.getIndexOf(sNIFPackageName);
            m_vnifpeContainer.removeElementAt(nIndexOf);
        }
        Logr.methodExit(className, "remove");
    }

    public static Vector getAllNIFStackElements() {
        return m_vnifpeContainer;
    }

    public static int getNextAvailableOrder() {
        Logr.methodEntry(className, "getNextAvailableOrder");
        int nHighest = -1;
        int i = 0;
        while (i < m_vnifpeContainer.size()) {
            int nOrderThis = ((NIFPackageEntry)m_vnifpeContainer.elementAt(i)).getOrder();
            if (nOrderThis > nHighest) {
                nHighest = nOrderThis;
            }
            ++i;
        }
        Logr.methodExit(className, "getNextAvailableOrder");
        return nHighest + 1;
    }

    public static void commitAndClose() throws IOException, ParserConfigurationException {
        Logr.methodEntry(className, "commitAndClose");
        NIFStack.commit();
        NIFStack.close();
        Logr.methodExit(className, "commitAndClose");
    }

    public static void commit() throws ParserConfigurationException, IOException {
        Logr.methodEntry(className, "commit");
        if (m_vnifpeContainer == null) {
            return;
        }
        Document documentThis = SimpleXMLParser.createNewDocument();
        Element elementRoot = SimpleXMLParser.addNestedElement("maintenance-stack", null, null, documentThis);
        int i = 0;
        while (i < m_vnifpeContainer.size()) {
            NIFPackageEntry nifpeElementThis = (NIFPackageEntry)m_vnifpeContainer.elementAt(i);
            nifpeElementThis.setOrder(i);
            nifpeElementThis.addToThisDocument(elementRoot);
            ++i;
        }
        XMLUtils.saveDocument(documentThis, m_fseStackXml, true);
        Logr.methodExit(className, "commit");
    }

    public static void close() {
        Logr.methodEntry(className, "close");
        m_fseBackupRepositoryDir = null;
        m_fseStackXml = null;
        m_vnifpeContainer = null;
        m_fIsFeaturesSet = true;
        m_fIsOpen = false;
        Logr.methodExit(className, "close");
    }

    public static boolean isOpen() {
        return m_fIsOpen;
    }

    public static boolean isFeaturesSet() {
        return m_fIsFeaturesSet;
    }

    public static void setFeatures(String sFeatures) {
        Logr.methodEntry(className, "setFeatures");
        NIFStack.addParamEntryToHighestOrderElement("features", sFeatures);
        m_fIsFeaturesSet = true;
        Logr.methodExit(className, "setFeatures");
    }

    public static Vector getAllTempIfixNamesForThisProduct(String sProductId) {
        Logr.methodEntry(className, "getAllTempIfixNamesForThisProduct");
        return NIFStack.getAllTempIfixNamesForTheseProducts(sProductId);
    }

    public static Vector getAllTempIfixNamesForTheseProducts(String sProductIds) {
        Logr.methodEntry(className, "getAllTempIfixNamesForTheseProducts");
        Vector<String> vsTempIfixEntries = new Vector<String>();
        int i = 0;
        while (i < m_vnifpeContainer.size()) {
            NIFPackageEntry nifeThis = (NIFPackageEntry)m_vnifpeContainer.elementAt(i);
            boolean fIsIfix = new Boolean(nifeThis.getParamValue("autouninstallable"));
            String sTargetProductIds = nifeThis.getParamValue("targetproductids");
            boolean fIsApplicable = sTargetProductIds != null && StringUtils.doesTheseStringsShareTokens(sTargetProductIds, sProductIds, ";");
            boolean fIsOfficialFix = new Boolean(nifeThis.getParamValue("isofficialfix"));
            if (fIsIfix && fIsApplicable && !fIsOfficialFix) {
                vsTempIfixEntries.add(nifeThis.getNIFPackageName());
            }
            ++i;
        }
        Logr.methodExit(className, "getAllTempIfixNamesForTheseProducts");
        return vsTempIfixEntries;
    }

    public static boolean isThisMaintenanceInstalledAsAFixpack(String sMaintenance) {
        Logr.methodEntry(className, "isThisMaintenanceInstalledAsAFixpack");
        NIFPackageEntry nifpeEntry = NIFStack.find(sMaintenance);
        if (nifpeEntry == null) {
            return false;
        }
        String sPackagetype = nifpeEntry.getParamValue("packagetype");
        if (sPackagetype != null && (sPackagetype.equalsIgnoreCase("FIXPACK") || sPackagetype.equalsIgnoreCase("REFRESHPACK") || sPackagetype.equalsIgnoreCase("JDKFIXPACK"))) {
            return true;
        }
        String sAutoUninstallable = nifpeEntry.getParamValue("autouninstallable");
        Logr.methodExit(className, "isThisMaintenanceInstalledAsAFixpack");
        return new Boolean(sAutoUninstallable) == false;
    }

    public static boolean isTherePrimaryMaintenanceInstalledOnTopOfThisMaintenance(String sMaintenance) {
        Logr.methodEntry(className, "isTherePrimaryMaintenanceInstalledOnTopOfThisMaintenance");
        NIFStack.sortStackElementContainer();
        NIFPackageEntry nifpeEntry = NIFStack.find(sMaintenance);
        if (nifpeEntry == null) {
            return false;
        }
        String sTargetProductIds = nifpeEntry.getParamValue("targetproductids");
        String sTargetSubproductIds = nifpeEntry.getParamValue("targetsubproductids");
        if (sTargetProductIds == null || sTargetProductIds.trim().equals(S_EMPTY) || sTargetSubproductIds == null || sTargetSubproductIds.trim().equals(S_EMPTY)) {
            return false;
        }
        int i = m_vnifpeContainer.size() - 1;
        while (i >= 0) {
            NIFPackageEntry nifpeThis = (NIFPackageEntry)m_vnifpeContainer.elementAt(i);
            if (nifpeThis.getNIFPackageName().equals(sMaintenance)) {
                return false;
            }
            String sWasInstalledAsPrimary = nifpeThis.getParamValue("wasinstalledasprimary");
            if (sWasInstalledAsPrimary == null || sWasInstalledAsPrimary.equals(S_EMPTY) || new Boolean(sWasInstalledAsPrimary).booleanValue() && !new Boolean(nifpeThis.getParamValue("isenablingifix")).booleanValue()) {
                String sTargetProductIdsThis = nifpeThis.getParamValue("targetproductids");
                String sTargetSubproductIdsThis = nifpeThis.getParamValue("targetsubproductids");
                if (StringUtils.doesTheseStringsShareTokens(sTargetProductIds, sTargetProductIdsThis, ";") && StringUtils.doesTheseStringsShareTokens(sTargetSubproductIds, sTargetSubproductIdsThis, ";")) {
                    return true;
                }
            }
            --i;
        }
        Logr.methodExit(className, "isTherePrimaryMaintenanceInstalledOnTopOfThisMaintenance");
        return false;
    }

    public static String getPakversionOfPayload(String sPayloadid) {
        Logr.methodEntry(className, "getPakversionOfPayload");
        return NIFStack.getPakversionOfPayload(m_vnifpeContainer, sPayloadid);
    }

    public static String getPakversionOfPayload(Vector vnifpeContainer, String sPayloadid) {
        Logr.methodEntry(className, "getPakversionOfPayload");
        if (vnifpeContainer == null) {
            Logr.debug("getPakversionOfPayload : vnifpeContainer == null");
            Logr.methodReturn(className, "getPakversionOfPayload", "0.0.0.0");
            return "0.0.0.0";
        }
        int i = vnifpeContainer.size() - 1;
        while (i >= 0) {
            NIFPackageEntry nifpeThis = (NIFPackageEntry)vnifpeContainer.elementAt(i);
            String sPayloadidThis = nifpeThis.getParamValue("payloadid");
            if (sPayloadidThis != null && sPayloadidThis.equals(sPayloadid)) {
                Logr.methodReturn(className, "getPakversionOfPayload", nifpeThis.getParamValue("pakversion"));
                return nifpeThis.getParamValue("pakversion");
            }
            --i;
        }
        Logr.methodReturn(className, "getPakversionOfPayload", "0.0.0.0");
        return "0.0.0.0";
    }

    public static String getMaintenanceNameOfPayload(String sPayloadid) {
        Logr.methodEntry(className, "getMaintenanceNameOfPayload");
        String s = NIFStack.getMaintenanceNameOfPayload(m_vnifpeContainer, sPayloadid);
        Logr.methodReturn(className, "getMaintenanceNameOfPayload", s);
        return s;
    }

    public static String getMaintenanceNameOfPayload(Vector vnifpeContainer, String sPayloadid) {
        Logr.methodEntry(className, "getMaintenanceNameOfPayload");
        int i = vnifpeContainer.size() - 1;
        while (i >= 0) {
            NIFPackageEntry nifpeThis = (NIFPackageEntry)vnifpeContainer.elementAt(i);
            String sPayloadidThis = nifpeThis.getParamValue("payloadid");
            if (sPayloadidThis != null && sPayloadidThis.equals(sPayloadid)) {
                Logr.methodReturn(className, "getMaintenanceNameOfPayload", nifpeThis.getNIFPackageName());
                return nifpeThis.getNIFPackageName();
            }
            --i;
        }
        Logr.methodReturn(className, "getMaintenanceNameOfPayload", S_EMPTY);
        return S_EMPTY;
    }

    public static Vector findFeaturePackDependenciesOnThisPayloadidAndPakversion(String sPayloadidToBeChecked, String sPakversionToBeChecked) {
        Logr.methodEntry(className, "findFeaturePackDependenciesOnThisPayloadidAndPakversion");
        Vector<NIFPackageEntry> vsNIFPackageOtherPaksDependOn = new Vector<NIFPackageEntry>();
        int i = m_vnifpeContainer.size() - 1;
        while (i >= 0) {
            NIFPackageEntry nifpeThis = (NIFPackageEntry)m_vnifpeContainer.elementAt(i);
            String[] asDepends = StringUtils.convertStringToTokenArray(nifpeThis.getParamValue("dependsOn"), ";");
            int x = 0;
            while (asDepends != null && x < asDepends.length) {
                String[] asADependency = StringUtils.convertStringToTokenArray(asDepends[x], ":");
                if (asADependency.length == 2 && asADependency[0].equals(sPayloadidToBeChecked) && VersionUtils.isVersionAcceptableToTheseVersionParams(sPakversionToBeChecked, asADependency[1]) && !new Boolean(nifpeThis.getParamValue("isenablingifix")).booleanValue()) {
                    vsNIFPackageOtherPaksDependOn.add(nifpeThis);
                }
                ++x;
            }
            --i;
        }
        if (vsNIFPackageOtherPaksDependOn.size() == 0) {
            return null;
        }
        Logr.methodExit(className, "findFeaturePackDependenciesOnThisPayloadidAndPakversion");
        return vsNIFPackageOtherPaksDependOn;
    }

    public static String[] findAllDependenciesOnThisPayloadid(String sPayloadidToBeChecked) {
        Logr.methodEntry(className, "findAllDependenciesOnThisPayloadid");
        Vector<String> vsPakversionsOtherPaksDependOn = new Vector<String>();
        int i = m_vnifpeContainer.size() - 1;
        while (i >= 0) {
            NIFPackageEntry nifpeThis = (NIFPackageEntry)m_vnifpeContainer.elementAt(i);
            String[] asDepends = StringUtils.convertStringToTokenArray(nifpeThis.getParamValue("dependsOn"), ";");
            int x = 0;
            while (asDepends != null && x < asDepends.length) {
                String sPayloadidThis = DependsOnUtils.getPayloadid(asDepends[x]);
                if (sPayloadidThis != null && sPayloadidThis.equals(sPayloadidToBeChecked)) {
                    String sComparingStringThis = DependsOnUtils.getComparingString(asDepends[x]);
                    vsPakversionsOtherPaksDependOn.add(sComparingStringThis);
                }
                ++x;
            }
            --i;
        }
        if (vsPakversionsOtherPaksDependOn.size() == 0) {
            return new String[]{"<0.0.0.0"};
        }
        Logr.methodExit(className, "findAllDependenciesOnThisPayloadid");
        return vsPakversionsOtherPaksDependOn.toArray(new String[vsPakversionsOtherPaksDependOn.size()]);
    }

    public static boolean checkStackDependency(String sPayloadidToBeChecked, String sPakversionsRequired, Vector vnifpeContainer) {
        Logr.methodEntry(className, "checkStackDependency");
        String sVersionFound = NIFStack.getPakversionOfPayload(vnifpeContainer, sPayloadidToBeChecked);
        Logr.methodExit(className, "checkStackDependency");
        return VersionUtils.isVersionAcceptableToTheseVersionParams(sVersionFound, sPakversionsRequired);
    }

    private static int getIndexOf(NIFPackageEntry nifpeElement) {
        int i = 0;
        while (i < m_vnifpeContainer.size()) {
            NIFPackageEntry nifpeThis = (NIFPackageEntry)m_vnifpeContainer.elementAt(i);
            if (nifpeElement.getNIFPackageName().equals(nifpeThis.getNIFPackageName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static int getIndexOf(String sNIFPackageName) {
        int i = 0;
        while (i < m_vnifpeContainer.size()) {
            NIFPackageEntry mseThis = (NIFPackageEntry)m_vnifpeContainer.elementAt(i);
            if (mseThis.getNIFPackageName().equals(sNIFPackageName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static NIFPackageEntry find(String sNIFPackageName) {
        Logr.methodEntry(className, "find");
        int i = m_vnifpeContainer.size() - 1;
        while (i >= 0) {
            NIFPackageEntry mseThis = (NIFPackageEntry)m_vnifpeContainer.elementAt(i);
            if (mseThis.getNIFPackageName().equals(sNIFPackageName)) {
                return mseThis;
            }
            --i;
        }
        Logr.methodExit(className, "find");
        return null;
    }

    private static FileSystemEntry createStackXMLFileSystemEntry(FileSystemEntry fseUPDIBackupRepositoryDir, InstallToolkitBridge itb) throws IOException {
        Logr.methodEntry(className, "createStackXMLFileSystemEntry");
        FileSystemEntry fseStack = new FileSystemEntry(fseUPDIBackupRepositoryDir.getURI(), "NIFStack.xml", itb);
        FileSystemEntry fseStackLegacy = new FileSystemEntry(fseUPDIBackupRepositoryDir.getURI(), "maintenanceStack.xml", itb);
        if (!fseStack.exists() && fseStackLegacy.exists()) {
            return fseStackLegacy;
        }
        return fseStack;
    }

    private static void readStack() throws IOException, ParserConfigurationException, SAXException {
        Logr.methodEntry(className, "readStack");
        m_vnifpeContainer = new Vector();
        if (!m_fseStackXml.exists()) {
            return;
        }
        SimpleXMLParser sxpParser = null;
        sxpParser = XMLUtils.getSimpleXMLParserFromFileSystemEntry(m_fseStackXml);
        Vector vnodeContainer = sxpParser.getNodes(S_PATH_MAINTENANCE);
        int i = 0;
        while (i < vnodeContainer.size()) {
            Node nodeThis = (Node)vnodeContainer.elementAt(i);
            m_vnifpeContainer.addElement(new NIFPackageEntry(nodeThis));
            ++i;
        }
        Logr.methodExit(className, "readStack");
    }

    private static void sortStackElementContainer() {
        Logr.methodEntry(className, "sortStackElementContainer");
        Vector<NIFPackageEntry> vmseContainer = new Vector<NIFPackageEntry>();
        while (m_vnifpeContainer != null && m_vnifpeContainer.size() > 0) {
            NIFPackageEntry mseNextElement = NIFStack.extractNextElement();
            mseNextElement.setOrder(vmseContainer.size());
            vmseContainer.add(mseNextElement);
        }
        m_vnifpeContainer = vmseContainer;
        Logr.methodExit(className, "sortStackElementContainer");
    }

    private static NIFPackageEntry extractNextElement() {
        Logr.methodEntry(className, "extractNextElement");
        NIFPackageEntry mseNextElement = (NIFPackageEntry)m_vnifpeContainer.elementAt(0);
        int nNextOrder = mseNextElement.getOrder();
        int nNextIndex = 0;
        int i = 1;
        while (i < m_vnifpeContainer.size()) {
            NIFPackageEntry nifpeThis = (NIFPackageEntry)m_vnifpeContainer.elementAt(i);
            if (nifpeThis.getOrder() < nNextOrder) {
                mseNextElement = nifpeThis;
                nNextOrder = mseNextElement.getOrder();
                nNextIndex = i;
            }
            ++i;
        }
        m_vnifpeContainer.removeElementAt(nNextIndex);
        Logr.methodExit(className, "extractNextElement");
        return mseNextElement;
    }

    public static Vector findAllFeaturesInStack() {
        return NIFStack.findAllFeaturesInStackForThisOffering(null);
    }

    public static Vector findAllFeaturesInStackForThisOffering(String sOffering) {
        Logr.methodEntry(className, "findAllFeaturesInStackForThisOffering");
        Vector<String> vsAllFeatures = new Vector<String>();
        int i = 0;
        while (i < m_vnifpeContainer.size()) {
            String sFeaturesThis;
            NIFPackageEntry meThis = (NIFPackageEntry)m_vnifpeContainer.elementAt(i);
            if (NIFStack.isThisEntryForThisProduct(meThis, sOffering) && (sFeaturesThis = meThis.getParamValue("features")) != null) {
                StringTokenizer st = new StringTokenizer(sFeaturesThis, ";");
                while (st.hasMoreTokens()) {
                    String sFeatureId = st.nextToken();
                    if (vsAllFeatures.contains(sFeatureId)) continue;
                    vsAllFeatures.add(sFeatureId);
                }
            }
            ++i;
        }
        Logr.methodExit(className, "findAllFeaturesInStackForThisOffering");
        return vsAllFeatures;
    }

    public static boolean syncFeaturesInRepositoryWithStack(Vector vsComponentmapFeatures) {
        Logr.methodEntry(className, "syncFeaturesInRepositoryWithStack");
        Vector vsAllFeaturesInStack = NIFStack.findAllFeaturesInStack();
        String sInstalledFeatures = NIFStack.getStringRepresentation(vsComponentmapFeatures);
        if (!vsAllFeaturesInStack.containsAll(vsComponentmapFeatures)) {
            int i = 0;
            while (i < m_vnifpeContainer.size()) {
                NIFPackageEntry nifpe = (NIFPackageEntry)m_vnifpeContainer.elementAt(i);
                nifpe.updateOrAddParam("features", sInstalledFeatures);
                ++i;
            }
            return true;
        }
        return false;
    }

    public static String getStringRepresentation(Vector vsTokens) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < vsTokens.size()) {
            sb = sb.append(vsTokens.elementAt(i));
            if (i < vsTokens.size() - 1) {
                sb = sb.append(";");
            }
            ++i;
        }
        return sb.toString();
    }

    private static boolean isThisEntryForThisProduct(NIFPackageEntry mseThis, String sOffering) {
        Logr.methodEntry(className, "isThisEntryForThisProduct");
        if (sOffering == null || sOffering.trim().equals(S_EMPTY)) {
            return true;
        }
        String sTargetProductIds = mseThis.getParamValue("targetproductids");
        if (sTargetProductIds == null || sTargetProductIds.trim().equals(S_EMPTY) || sTargetProductIds.trim().equals("NA")) {
            return true;
        }
        if ((";" + sTargetProductIds.trim() + ";").indexOf(";" + sOffering.trim() + ";") >= 0) {
            return true;
        }
        Logr.methodExit(className, "isThisEntryForThisProduct");
        return false;
    }
}

