/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.install.metadata;

import com.ibm.ws.pak.internal.NIFException;
import com.ibm.ws.pak.internal.NIFPlugin;
import com.ibm.ws.pak.internal.install.metadata.ModifyNIFMetaDataPlugin;
import com.ibm.ws.pak.internal.utils.StringUtils;
import com.ibm.ws.pak.internal.utils.XMLUtils;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ModifyNIFPlugin
extends ModifyNIFMetaDataPlugin {
    private static final String S_MODE_PARAM = "mode";
    private static final String S_PLUGINPATH_PARAM = "pluginpath";
    private static final String S_PLUGINID_PARAM = "pluginid";
    private static final String S_PARAMNAME_PARAM = "paramname";
    private static final String S_PARAMVALUES_PARAM = "paramvalues";
    private static final String S_PARAMVALUE_PARAM = "paramvalue";
    private static final String S_NIFMETADATAROOTURI_PARAM = "nifmatadatarooturi";
    private static final String S_NIFMETADATAENTRYNAME_PARAM = "nifmatadataentryname";
    private static final String[] AS_EMPTY = new String[0];
    private static final String S_EMPTY = "";
    private static final String[] AS_OPTIONAL_PARAMS = new String[]{"paramvalues", "paramvalue", "nifmatadatarooturi", "nifmatadataentryname", "mode"};
    private static final String[] AS_REQUIRED_PARAMS = new String[]{"pluginpath", "pluginid", "paramname"};
    private static final String S_MODE_NEW = "new";
    private static final String S_MODE_REMOVE = "remove";
    private static final String S_MODE_PREFIX = "prefix";
    private static final String S_MODE_APPEND = "append";
    private static final String className = "ModifyNIFPlugin";

    @Override
    protected String[] getRequiredParams() {
        return AS_REQUIRED_PARAMS;
    }

    @Override
    protected String[] getOptionalParams() {
        return AS_OPTIONAL_PARAMS;
    }

    @Override
    public FileSystemEntry getMetaDataFileSystemEntry() throws IOException, URISyntaxException {
        return new FileSystemEntry(new URI(this.getNIFMetaDataRootURI()), this.getParamValue(S_NIFMETADATAENTRYNAME_PARAM), this.getInstallToolkitBridge());
    }

    @Override
    protected void modifyMetaData(Document docThis) throws NIFException {
        this.transformNIFDocument(docThis);
    }

    @Override
    public void modifyMetaData() throws IOException, URISyntaxException, NIFException, ParserConfigurationException, SAXException {
        Logr.methodEntry(className, "modifyMetaData");
        FileSystemEntry fseMaintenanceMetaDataTo = new FileSystemEntry(new URI(this.getNIFMetaDataRootURI()), this.getParamValue(S_NIFMETADATAENTRYNAME_PARAM), this.getInstallToolkitBridge());
        Document documentThis = null;
        if (fseMaintenanceMetaDataTo.exists()) {
            documentThis = (Document)XMLUtils.getSimpleXMLParserFromFileSystemEntry(fseMaintenanceMetaDataTo).getDocument().cloneNode(true);
            fseMaintenanceMetaDataTo.delete();
        } else {
            documentThis = (Document)this.getPluginDefinitionDocument().cloneNode(true);
        }
        this.transformNIFDocument(documentThis);
        XMLUtils.saveDocument(documentThis, fseMaintenanceMetaDataTo);
        Logr.methodExit(className, "modifyMetaData");
    }

    public void modifyMetaData(boolean fRefreshCache) throws IOException, URISyntaxException, NIFException, ParserConfigurationException, SAXException {
        this.modifyMetaData();
        if (fRefreshCache) {
            this.transformNIFDocument(this.getPluginDefinitionDocument());
        }
    }

    private void transformNIFDocument(Document document) throws NIFException {
        try {
            Logr.methodEntry(className, "transformNIFDocument");
            String[] asParamValues = this.getParamValuesToSet();
            NIFPlugin.setPluginParamInThisDocument(document, this.getParamValue(S_PLUGINPATH_PARAM), this.getParamValue(S_PLUGINID_PARAM), this.getParamValue(S_PARAMNAME_PARAM), asParamValues);
            Logr.methodExit(className, "transformNIFDocument");
        }
        catch (SAXException e) {
            Logr.warn(className, "transformNIFDocument", e.getMessage(), e);
            throw new NIFException(e);
        }
    }

    private String[] getParamValuesToSet() throws SAXException {
        if (this.getParamValue(S_PARAMVALUE_PARAM) != null) {
            return new String[]{this.getParamValueToSet(this.getParamValue(S_PARAMVALUE_PARAM))};
        }
        if (this.getParamValue(S_PARAMVALUES_PARAM) != null) {
            return StringUtils.getCollectionAsStringArray(this.getExpandedParams(this.getParamValue(S_PARAMVALUE_PARAM)));
        }
        return AS_EMPTY;
    }

    private String getParamValueToSet(String sValueIncoming) throws SAXException {
        String sMode = this.getMode();
        if (sMode.equalsIgnoreCase(S_MODE_REMOVE)) {
            return S_EMPTY;
        }
        if (sMode.equalsIgnoreCase(S_MODE_NEW)) {
            return sValueIncoming;
        }
        String[] asValueCurrent = this.getParamValuesForThisNode(this.getPluginDefinitionDocument(), this.getParamValue(S_PLUGINPATH_PARAM), this.getParamValue(S_PLUGINID_PARAM), this.getParamValue(S_PARAMNAME_PARAM));
        if (asValueCurrent == null || asValueCurrent.length == 0 || asValueCurrent[0] == null || asValueCurrent[0].trim().length() == 0) {
            return sValueIncoming;
        }
        String sValueCurrent = asValueCurrent[0];
        if (sMode.equalsIgnoreCase(S_MODE_PREFIX)) {
            return String.valueOf(sValueIncoming) + ";" + sValueCurrent;
        }
        if (sMode.equalsIgnoreCase(S_MODE_APPEND)) {
            return String.valueOf(sValueCurrent) + ";" + sValueIncoming;
        }
        return sValueIncoming;
    }

    public String getMode() {
        String sMode = this.getParamValue(S_MODE_PARAM);
        if (sMode == null || sMode.trim().length() == 0) {
            sMode = S_MODE_NEW;
        }
        return sMode;
    }

    public String getNIFMetaDataRootURI() {
        return this.getParamValue(S_NIFMETADATAROOTURI_PARAM);
    }
}

