/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.install.metadata;

import com.ibm.ws.pak.internal.NIFException;
import com.ibm.ws.pak.internal.NIFPlugin;
import com.ibm.ws.pak.internal.utils.NIFPluginUtils;
import com.ibm.ws.pak.internal.utils.XMLUtils;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ModifyNIFMetaDataPlugin
extends NIFPlugin {
    private ModifyNIFMetaDataPlugin[] m_amnifmdp = null;
    private static final String S_PRE_BACKUP = "prebackup";
    private static final String S_POST_BACKUP = "postbackup";
    private static final String S_PRE_INSTALL = "preinstall";
    private static final String S_POST_INSTALL = "postinstall";
    private static final String S_PRE_UNINSTALL = "preuninstall";
    private static final String S_POST_UNINSTALL = "postuninstall";
    private static final String S_CHILDPLUGINSRELATIVEPATH_PARAM = "childpluginsrelativepath";
    private static final String S_STAGE_PARAM = "stage";
    private static final String[] AS_OPTIONAL_PARAMS = new String[0];
    private static final String[] AS_REQUIRED_PARAMS = new String[]{"childpluginsrelativepath", "stage"};
    private static final String className = "ModifyNIFMetaDataPlugin";

    public final void modifyNIFMetaData() throws IOException, URISyntaxException, ParserConfigurationException, SAXException, InstantiationException, IllegalAccessException, ClassNotFoundException, NIFException {
        Logr.methodEntry(className, "modifyNIFMetaData");
        this.initChildPlugins();
        Hashtable htOFvOFmnifmdp = this.group(this.m_amnifmdp);
        Enumeration enu = htOFvOFmnifmdp.keys();
        while (enu.hasMoreElements()) {
            String sURIThis = (String)enu.nextElement();
            Vector vOFmnifmdp = (Vector)htOFvOFmnifmdp.get(sURIThis);
            FileSystemEntry fseThis = new FileSystemEntry(new URI(sURIThis), this.getInstallToolkitBridge());
            Document documentThis = this.getMetaDataDocument(fseThis);
            int i = 0;
            while (i < vOFmnifmdp.size()) {
                ModifyNIFMetaDataPlugin mnifmdpThis = (ModifyNIFMetaDataPlugin)vOFmnifmdp.elementAt(i);
                mnifmdpThis.modifyMetaData(documentThis);
                ++i;
            }
            XMLUtils.saveDocument(documentThis, fseThis);
        }
        Logr.methodExit(className, "modifyNIFMetaData");
    }

    public FileSystemEntry getMetaDataFileSystemEntry() throws IOException, URISyntaxException {
        return null;
    }

    public int getStage() {
        String sStage = this.getParamValue(S_STAGE_PARAM);
        if (sStage.equals(S_PRE_BACKUP)) {
            return 1;
        }
        if (sStage.equals(S_POST_BACKUP)) {
            return 2;
        }
        if (sStage.equals(S_PRE_INSTALL)) {
            return 3;
        }
        if (sStage.equals(S_POST_INSTALL)) {
            return 4;
        }
        if (sStage.equals(S_PRE_UNINSTALL)) {
            return 5;
        }
        if (sStage.equals(S_POST_UNINSTALL)) {
            return 6;
        }
        return 0;
    }

    @Override
    protected String[] getRequiredParams() {
        return AS_REQUIRED_PARAMS;
    }

    @Override
    protected String[] getOptionalParams() {
        return AS_OPTIONAL_PARAMS;
    }

    protected void modifyMetaData() throws NIFException, IOException, URISyntaxException, ParserConfigurationException, SAXException, IllegalAccessException, InstantiationException, ClassNotFoundException {
    }

    protected void modifyMetaData(Document docThis) throws NIFException, IOException, URISyntaxException, ParserConfigurationException, SAXException, IllegalAccessException, InstantiationException, ClassNotFoundException {
    }

    private Hashtable group(ModifyNIFMetaDataPlugin[] amnifmdp) throws IOException, URISyntaxException {
        Hashtable<String, Vector<ModifyNIFMetaDataPlugin>> htOFvOFmnifmdp = new Hashtable<String, Vector<ModifyNIFMetaDataPlugin>>();
        if (amnifmdp == null || amnifmdp.length == 0) {
            return htOFvOFmnifmdp;
        }
        ModifyNIFMetaDataPlugin[] modifyNIFMetaDataPluginArray = amnifmdp;
        int n = amnifmdp.length;
        int n2 = 0;
        while (n2 < n) {
            ModifyNIFMetaDataPlugin element = modifyNIFMetaDataPluginArray[n2];
            FileSystemEntry fseThis = element.getMetaDataFileSystemEntry();
            if (fseThis != null) {
                Object oThis = htOFvOFmnifmdp.get(fseThis.getURI().toString());
                Vector<ModifyNIFMetaDataPlugin> vOFmnifmdp = null;
                vOFmnifmdp = oThis == null ? new Vector<ModifyNIFMetaDataPlugin>(5) : (Vector<ModifyNIFMetaDataPlugin>)oThis;
                vOFmnifmdp.add(element);
                htOFvOFmnifmdp.put(fseThis.getURI().toString(), vOFmnifmdp);
            }
            ++n2;
        }
        return htOFvOFmnifmdp;
    }

    private Document getMetaDataDocument(FileSystemEntry fseMaintenanceMetaDataTo) throws SAXException, IOException, ParserConfigurationException {
        Logr.methodEntry(className, "getMetaDataDocument");
        Document documentThis = null;
        if (fseMaintenanceMetaDataTo.exists()) {
            documentThis = (Document)XMLUtils.getSimpleXMLParserFromFileSystemEntry(fseMaintenanceMetaDataTo).getDocument().cloneNode(true);
            fseMaintenanceMetaDataTo.delete();
        } else {
            documentThis = (Document)this.getPluginDefinitionDocument().cloneNode(true);
        }
        Logr.methodExit(className, "getMetaDataDocument");
        return documentThis;
    }

    private void initChildPlugins() throws IOException, ParserConfigurationException, SAXException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        Logr.methodEntry(className, "initChildPlugins");
        if (this.m_amnifmdp != null) {
            return;
        }
        NIFPlugin[] anifp = NIFPlugin.createChildPlugins(this, this.getParamValue(S_CHILDPLUGINSRELATIVEPATH_PARAM), this.getInstallToolkitBridge());
        NIFPluginUtils.enforceAllThesePluginsAssignableFromThisClass(ModifyNIFMetaDataPlugin.class, anifp);
        this.m_amnifmdp = new ModifyNIFMetaDataPlugin[anifp.length];
        int i = 0;
        while (i < anifp.length) {
            this.m_amnifmdp[i] = (ModifyNIFMetaDataPlugin)anifp[i];
            ++i;
        }
        Logr.methodExit(className, "initChildPlugins");
    }
}

