/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.install.failurerecovery;

import com.ibm.ws.pak.internal.NIFConstants;
import com.ibm.ws.pak.internal.NIFException;
import com.ibm.ws.pak.internal.NIFPlugin;
import com.ibm.ws.pak.internal.install.failurerecovery.UpdateStatusEntry;
import com.ibm.ws.pak.internal.install.failurerecovery.UpdateStatusFile;
import com.ibm.ws.pak.internal.install.failurerecovery.UpdateStatusStage;
import com.ibm.ws.pak.internal.utils.NIFPluginUtils;
import com.ibm.ws.pak.internal.utils.SimpleXMLParser;
import com.ibm.ws.pak.internal.utils.StringUtils;
import com.ibm.ws.pak.internal.utils.URIUtils;
import com.ibm.ws.pak.internal.utils.XMLUtils;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.installtoolkitbridge.InstallToolkitBridge;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import com.ibm.ws.pak.internal.utils.macroresolvers.MacroResolver;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class FailureRecoveryPlugin
extends NIFPlugin {
    private static final String className = "FailureRecoveryPlugin";
    private FileSystemEntry m_fseRecoveryRepository = null;
    private static final String S_PARAM_CHILDPLUGINSRELATIVEPATH = "childpluginsrelativepath";
    private static final String S_PARAM_FAILURERECOVERYMETADATAURI = "failurerecoverymetadatauri";
    private static final String S_PARAM_BACKUPREPOSITORYURI = "backupRepositoryUri";
    private static final String S_PARAM_ENABLED = "enabled";
    private static final String S_PARAM_INSTALLROOT = "installroot";
    private static final String S_PARAM_TIMESTAMPFORMAT = "timestampformat";
    private static final String S_RECOVERYREPOSITORY = "recovered/";
    private static final String S_DEFAULT_TIMESTAMPFORMAT = "yyMMddHHmmss";
    private static final String[] AS_REQUIRED_PARAMS = new String[0];
    private static final String[] AS_OPTIONAL_PARAMS = new String[]{"childpluginsrelativepath", "failurerecoverymetadatauri", "backupRepositoryUri", "enabled", "installroot"};

    public static FailureRecoveryPlugin getFailureRecoveryPlugin(InstallToolkitBridge itb) throws IOException, URISyntaxException, ParserConfigurationException, SAXException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        Logr.methodEntry(className, "getFailureRecoveryPlugin");
        FileSystemEntry fseFailureRecovery = new FileSystemEntry(NIFConstants.getMetadataDirectoryURI(itb), "framework/failurerecovery.xml", itb);
        Logr.debug("Failure Recovery metadata file : " + fseFailureRecovery.getAbsolutePath());
        SimpleXMLParser sxp = XMLUtils.getSimpleXMLParserFromFileSystemEntry(fseFailureRecovery);
        NIFPlugin[] anifp = NIFPlugin.createPlugins(sxp.getDocument(), "failure-recovery-plugins/failure-recovery", itb);
        NIFPluginUtils.enforceAllThesePluginsAssignableFromThisClass(FailureRecoveryPlugin.class, anifp);
        Logr.methodReturn(className, "getFailureRecoveryPlugin", anifp[0]);
        return (FailureRecoveryPlugin)anifp[0];
    }

    public void resetMetaData() throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        Logr.methodEntry(className, "resetMetaData");
        this.getUpdateStatusFile().resetUpdateStatusFile(this.getInstallToolkitBridge());
        Logr.methodExit(className, "resetMetaData");
    }

    public boolean isEnabled() {
        Boolean enabled = new Boolean(this.getParamValue(S_PARAM_ENABLED));
        Logr.methodReturn(className, "isEnabled", enabled.toString());
        return enabled;
    }

    public String getInstallroot() {
        return this.getParamValue(S_PARAM_INSTALLROOT);
    }

    public boolean hasFailure() throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        if (!this.isEnabled()) {
            Logr.methodReturn(className, "hasFailure", "false");
            return false;
        }
        UpdateStatusFile usfMetaData = this.getUpdateStatusFile();
        boolean failures = usfMetaData.hasFailure();
        Logr.methodReturn(className, "hasFailure", new Boolean(failures).toString());
        return failures;
    }

    public boolean hasFailure(String sBackupRepository) throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        if (!this.isEnabled()) {
            Logr.methodReturn(className, "hasFailure", "false");
            return false;
        }
        UpdateStatusFile usfMetaData = this.getUpdateStatusFile(sBackupRepository);
        boolean failures = usfMetaData.hasFailure();
        Logr.methodReturn(className, "hasFailure", new Boolean(failures).toString());
        return failures;
    }

    public String getHasFailure() throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        Logr.methodReturn(className, "getHasFailure", new Boolean(this.hasFailure()).toString());
        return new Boolean(this.hasFailure()).toString();
    }

    public String getPackageNameOfTheLastestFailedOne() throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        UpdateStatusFile usfMetaData = this.getUpdateStatusFile();
        Logr.methodReturn(className, "getPackageNameOfTheLastestFailedOne", usfMetaData.getPackageNameOfTheLastestFailedOne());
        return usfMetaData.getPackageNameOfTheLastestFailedOne();
    }

    public String getPackageNameOfTheLastestFailedOne(String sBackupRepositoryDir) throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        UpdateStatusFile usfMetaData = this.getUpdateStatusFile(sBackupRepositoryDir);
        Logr.methodReturn(className, "getPackageNameOfTheLastestFailedOne", usfMetaData.getPackageNameOfTheLastestFailedOne());
        return usfMetaData.getPackageNameOfTheLastestFailedOne();
    }

    public String[] findMaintenanceNamesToBeCleaned(UpdateStatusEntry useEntry) throws NIFException {
        Logr.methodEntry(className, "findMaintenanceNamesToBeCleaned");
        if (useEntry.hasBeenModified()) {
            String sReturn = useEntry.getAttributeValue("MaintenanceNamesOfPackagesToBeCleaned");
            sReturn = MacroResolver.resolveMacro(sReturn, this.getInstallToolkitBridge(), this.getPluginDefinitionDocument());
            Logr.methodReturn(className, "findMaintenanceNamesToBeCleaned", sReturn);
            return StringUtils.convertStringToTokenArray(sReturn, ";");
        }
        String[] asReturn = this.findApplicableFailureRecoveryPlugin(useEntry).findMaintenanceNamesOfPackagesToBeCleaned(useEntry);
        if (asReturn != null) {
            String[] stringArray = asReturn;
            int n = asReturn.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                Logr.debug("Maintenance to be cleaned : " + element);
                ++n2;
            }
        }
        return MacroResolver.resolveMacros(asReturn, this.getInstallToolkitBridge(), this.getPluginDefinitionDocument());
    }

    public String[] findURIsToBeCleaned(UpdateStatusEntry useEntry) throws NIFException {
        Logr.methodEntry(className, "findURIsToBeCleaned");
        if (useEntry.hasBeenModified()) {
            String sReturn = useEntry.getAttributeValue("URIsOfPackagesToBeCleaned");
            sReturn = MacroResolver.resolveMacro(sReturn, this.getInstallToolkitBridge(), this.getPluginDefinitionDocument());
            Logr.methodReturn(className, "findURIsToBeCleaned", sReturn);
            return StringUtils.convertStringToTokenArray(sReturn, ";");
        }
        String[] asReturn = this.findApplicableFailureRecoveryPlugin(useEntry).findURIsOfPackagesToBeCleaned(useEntry);
        if (asReturn != null) {
            String[] stringArray = asReturn;
            int n = asReturn.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                Logr.debug("Maintenance URIs to be cleaned : " + element);
                ++n2;
            }
        }
        return MacroResolver.resolveMacros(asReturn, this.getInstallToolkitBridge(), this.getPluginDefinitionDocument());
    }

    public String[] findURIsToBeExecuted(UpdateStatusEntry useEntry) throws NIFException {
        Logr.methodEntry(className, "findURIsToBeExecuted");
        if (useEntry.hasBeenModified()) {
            String sReturn = useEntry.getAttributeValue("URIsOfPackagesToBeExecuted");
            sReturn = MacroResolver.resolveMacro(sReturn, this.getInstallToolkitBridge(), this.getPluginDefinitionDocument());
            Logr.methodExit(className, "findURIsToBeExecuted");
            return StringUtils.convertStringToTokenArray(sReturn, ";");
        }
        String[] asReturn = this.findApplicableFailureRecoveryPlugin(useEntry).findURIsOfPackagesToBeExecuted(useEntry);
        Logr.methodExit(className, "findURIsToBeExecuted");
        return MacroResolver.resolveMacros(asReturn, this.getInstallToolkitBridge(), this.getPluginDefinitionDocument());
    }

    public FailureRecoveryPlugin findApplicableFailureRecoveryPlugin(UpdateStatusEntry useFailedOne) throws NIFException {
        Logr.methodEntry(className, "findApplicableFailureRecoveryPlugin");
        try {
            UpdateStatusStage ussFailedStage = useFailedOne.getFailedStage();
            String sFailedStage = ussFailedStage.getStageName();
            Logr.debug("Failed stage : " + sFailedStage);
            NIFPlugin[] anifp = NIFPlugin.createChildPlugins(this, this.getParamValue(S_PARAM_CHILDPLUGINSRELATIVEPATH), this.getInstallToolkitBridge());
            NIFPluginUtils.enforceAllThesePluginsAssignableFromThisClass(FailureRecoveryPlugin.class, anifp);
            NIFPlugin[] nIFPluginArray = anifp;
            int n = anifp.length;
            int n2 = 0;
            while (n2 < n) {
                NIFPlugin element = nIFPluginArray[n2];
                if (((FailureRecoveryPlugin)element).isApplicable(sFailedStage)) {
                    Logr.methodExit(className, "findApplicableFailureRecoveryPlugin");
                    return (FailureRecoveryPlugin)element;
                }
                ++n2;
            }
        }
        catch (IOException e) {
            Logr.warn(className, "findApplicableFailureRecoveryPlugin", e.getMessage(), e);
            throw new NIFException(e, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Logr.warn(className, "findApplicableFailureRecoveryPlugin", e.getMessage(), e);
            throw new NIFException(e, (Throwable)e);
        }
        catch (SAXException e) {
            Logr.warn(className, "findApplicableFailureRecoveryPlugin", e.getMessage(), e);
            throw new NIFException(e, (Throwable)e);
        }
        catch (InstantiationException e) {
            Logr.warn(className, "findApplicableFailureRecoveryPlugin", e.getMessage(), e);
            throw new NIFException(e, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            Logr.warn(className, "findApplicableFailureRecoveryPlugin", e.getMessage(), e);
            throw new NIFException(e, (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            Logr.warn(className, "findApplicableFailureRecoveryPlugin", e.getMessage(), e);
            throw new NIFException(e, (Throwable)e);
        }
        Logr.methodReturn(className, "findApplicableFailureRecoveryPlugin", null);
        return null;
    }

    protected boolean isApplicable(String sStage) {
        return false;
    }

    protected String[] findMaintenanceNamesOfPackagesToBeCleaned(UpdateStatusEntry useEntry) {
        return new String[0];
    }

    protected String[] findURIsOfPackagesToBeCleaned(UpdateStatusEntry useEntry) {
        return new String[0];
    }

    protected String[] findURIsOfPackagesToBeExecuted(UpdateStatusEntry useEntry) {
        return new String[0];
    }

    @Override
    protected String[] getRequiredParams() {
        return AS_REQUIRED_PARAMS;
    }

    @Override
    protected String[] getOptionalParams() {
        return AS_OPTIONAL_PARAMS;
    }

    public UpdateStatusFile getUpdateStatusFile(String sBackupRepository) throws SAXException, IOException, ParserConfigurationException, URISyntaxException {
        FileSystemEntry fseBackupRepositoryDir = URIUtils.convertPathToDefaultTargetMachineFSE(sBackupRepository, null);
        return UpdateStatusFile.getInstance(fseBackupRepositoryDir.getURI(), this.getInstallToolkitBridge());
    }

    public UpdateStatusFile getUpdateStatusFile() throws SAXException, IOException, ParserConfigurationException, URISyntaxException {
        return UpdateStatusFile.getInstance(new URI(this.getParamValue(S_PARAM_BACKUPREPOSITORYURI)), this.getInstallToolkitBridge());
    }

    public FileSystemEntry getRecoveryRepository() throws IOException, URISyntaxException {
        if (this.m_fseRecoveryRepository == null) {
            String sTimestamp = new SimpleDateFormat(this.getTimestampformat()).format(Calendar.getInstance().getTime());
            this.m_fseRecoveryRepository = new FileSystemEntry(new URI(this.getParamValue(S_PARAM_BACKUPREPOSITORYURI)), S_RECOVERYREPOSITORY + sTimestamp, this.getInstallToolkitBridge());
            if (!this.m_fseRecoveryRepository.exists()) {
                this.m_fseRecoveryRepository.mkdirs();
            }
        }
        Logr.methodReturn(className, "getRecoveryRepository", this.m_fseRecoveryRepository.getAbsolutePath());
        return this.m_fseRecoveryRepository;
    }

    public FileSystemEntry getBackupRepositoryDir() throws IOException, URISyntaxException {
        return new FileSystemEntry(new URI(this.getParamValue(S_PARAM_BACKUPREPOSITORYURI)), this.getInstallToolkitBridge());
    }

    public String getTimestampformat() {
        String s = this.getParamValue(S_PARAM_TIMESTAMPFORMAT);
        if (s == null) {
            s = S_DEFAULT_TIMESTAMPFORMAT;
        }
        return s;
    }
}

