/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.install.failurerecovery;

import com.ibm.ws.pak.internal.NIFException;
import com.ibm.ws.pak.internal.NIFPlugin;
import com.ibm.ws.pak.internal.install.failurerecovery.ICleaningPackagesPlugin;
import com.ibm.ws.pak.internal.install.metadata.NIFStack;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class CleaningStackPlugin
extends NIFPlugin
implements ICleaningPackagesPlugin {
    private static final String className = "CleaningStackPlugin";
    private static final String S_PARAM_BACKUPREPOSITORYURI = "backupRepositoryUri";
    private static final String S_PARAM_MAINTENANCENAMESOFPACKAGESTOBECLEANED = "maintenanceNamesOfPackagesToBeCleaned";
    private static final String[] AS_REQUIRED_PARAMS = new String[]{"backupRepositoryUri", "maintenanceNamesOfPackagesToBeCleaned"};
    private static final String[] AS_OPTIONAL_PARAMS = new String[0];

    @Override
    public void clean() throws NIFException {
        Logr.methodEntry(className, "clean");
        try {
            if (!NIFStack.isOpen()) {
                NIFStack.open(new FileSystemEntry(new URI(this.getParamValue(S_PARAM_BACKUPREPOSITORYURI)), this.getInstallToolkitBridge()), this.getInstallToolkitBridge());
                String[] asMaintenanceNames = this.getListOfParamValues(S_PARAM_MAINTENANCENAMESOFPACKAGESTOBECLEANED);
                if (asMaintenanceNames == null) {
                    Logr.debug("No maintenance to be cleaned.");
                    return;
                }
                String[] stringArray = asMaintenanceNames;
                int n = asMaintenanceNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String asMaintenanceName = stringArray[n2];
                    Logr.debug("Removing maintenance from NIFStack.xml : " + asMaintenanceName);
                    NIFStack.remove(asMaintenanceName);
                    ++n2;
                }
            }
        }
        catch (SAXException e) {
            Logr.warn(className, "clean", e.getMessage(), e);
            throw new NIFException(e, (Throwable)e);
        }
        catch (IOException e) {
            Logr.warn(className, "clean", e.getMessage(), e);
            throw new NIFException(e, (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            Logr.warn(className, "clean", e.getMessage(), e);
            throw new NIFException(e, (Throwable)e);
        }
        catch (URISyntaxException e) {
            Logr.warn(className, "clean", e.getMessage(), e);
            throw new NIFException(e, (Throwable)e);
        }
        Logr.methodExit(className, "clean");
    }

    @Override
    protected String[] getRequiredParams() {
        return AS_REQUIRED_PARAMS;
    }

    @Override
    protected String[] getOptionalParams() {
        return AS_OPTIONAL_PARAMS;
    }
}

