/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.install;

import com.ibm.ws.pak.internal.NIFConstants;
import com.ibm.ws.pak.internal.NIFException;
import com.ibm.ws.pak.internal.NIFPlugin;
import com.ibm.ws.pak.internal.install.NIFInstallPlugin;
import com.ibm.ws.pak.internal.install.NIFPackageApplicationPluginHelper;
import com.ibm.ws.pak.internal.install.failurerecovery.UpdateStatusFile;
import com.ibm.ws.pak.internal.install.metadata.MaintenanceInfoPlugin;
import com.ibm.ws.pak.internal.install.metadata.ModifyNIFMetaDataPlugin;
import com.ibm.ws.pak.internal.install.metadata.NIFHistory;
import com.ibm.ws.pak.internal.install.metadata.NIFPackageEntry;
import com.ibm.ws.pak.internal.install.metadata.NIFStack;
import com.ibm.ws.pak.internal.install.registry.NIFRegistryPlugin;
import com.ibm.ws.pak.internal.utils.NIFPluginUtils;
import com.ibm.ws.pak.internal.utils.URIUtils;
import com.ibm.ws.pak.internal.utils.componentactions.ComponentAction;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystem;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class NIFPackageApplicationPlugin
extends NIFInstallPlugin {
    protected NIFPackageEntry m_nifpeHistoryEntry = null;
    protected NIFPackageEntry m_nifpeStackEntry = null;
    protected NIFPackageApplicationPluginHelper m_nifpaph = null;
    protected boolean m_fUninstallableByUPDI = true;
    protected int m_nReturnCode = 0;
    protected boolean m_fUninstallSucceeded = false;
    private final String className = "NIFPackageApplicationPlugin";
    private static final String S_INSTALLPACKAGEURI_PARAM = "installpackageuri";
    private static final String S_METADATANAME_PARAM = "metadataname";
    private static final String S_BACKUPPACKAGEURI_PARAM = "backuppackageuri";
    private static final String S_BACKUPFLAG_PARAM = "backupflag";
    private static final String S_INFOPLUGINID_PARAM = "infopluginid";
    private static final String S_ISBACKUPPACKAGE_PARAM = "isbackuppackage";
    private static final String S_GENERATEBACKUPMETADATAPLUGINPATH_PARAM = "generatebackupmetadatapluginpath";
    private static final String S_INSTALLCONDITION_PARAM = "installcondition";
    private static final String S_UNINSTALLCONDITION_PARAM = "uninstallcondition";
    private static final String[] AS_EMPTY = new String[0];
    private static final String S_EMPTY = "";
    private static final String S_NULL = "null";
    private static final String[] AS_REQUIRED_PARAMS = new String[]{"installpackageuri", "metadataname", "backuppackageuri", "backupflag", "infopluginid", "isbackuppackage", "generatebackupmetadatapluginpath"};

    @Override
    public void init() {
        Logr.methodEntry("NIFPackageApplicationPlugin", "init");
        super.init();
        this.m_nifpaph = null;
        this.m_fUninstallSucceeded = false;
        Logr.methodExit("NIFPackageApplicationPlugin", "init");
    }

    protected boolean hasNIFPackageApplicationPluginHelperBeenInitialized() {
        Logr.methodEntry("NIFPackageApplicationPlugin", "hasNIFPackageApplicationPluginHelperBeenInitialized");
        Logr.methodReturn("NIFPackageApplicationPlugin", "hasNIFPackageApplicationPluginHelperBeenInitialized", new Boolean(this.m_nifpaph != null).toString());
        return this.m_nifpaph != null;
    }

    protected void initializeNIFPackageApplicationPluginHelper() {
        Logr.methodEntry("NIFPackageApplicationPlugin", "initializeNIFPackageApplicationPluginHelper");
        this.m_nifpaph = new NIFPackageApplicationPluginHelper(true, new Boolean(this.getParamValue(S_ISBACKUPPACKAGE_PARAM)));
        Logr.methodExit("NIFPackageApplicationPlugin", "initializeNIFPackageApplicationPluginHelper");
    }

    @Override
    public int execute() throws NIFException {
        Logr.methodEntry("NIFPackageApplicationPlugin", "execute");
        if (!this.hasNIFPackageApplicationPluginHelperBeenInitialized()) {
            this.initializeNIFPackageApplicationPluginHelper();
        }
        String sUpdateMode = System.getProperty("installmode");
        int nReturnCode = 0;
        this.m_nifpaph.startTrappingAndPublishingInstallEvents();
        if (sUpdateMode == null || sUpdateMode.equals("unknown")) {
            nReturnCode = this.executeInBackwardCompatibleMode();
        } else if (sUpdateMode.equals("backup")) {
            this.backupIfNecessary();
        } else if (sUpdateMode.equals("install")) {
            this.performUpgrade();
        } else if (sUpdateMode.equals("installconfig")) {
            if (!this.isBackupPackage()) {
                nReturnCode = 0;
            }
        } else if (sUpdateMode.equals("uninstallconfig")) {
            if (this.isBackupPackage()) {
                nReturnCode = 0;
            }
        } else if (sUpdateMode.equals("finishing")) {
            this.performTasksAfterUpgrade();
        }
        this.m_nifpaph.stopTrappingAndPublishingInstallEvents();
        this.m_nReturnCode = NIFConstants.getTheReturnCodeOfHigherPriority(this.m_nReturnCode, nReturnCode);
        Logr.methodReturn("NIFPackageApplicationPlugin", "execute", new Integer(this.m_nReturnCode).toString());
        return this.m_nReturnCode;
    }

    public boolean getCondition() {
        Logr.methodEntry("NIFPackageApplicationPlugin", "getCondition");
        if (this.isBackupPackage()) {
            return this.getUninstallcondition();
        }
        return this.getInstallcondition();
    }

    protected boolean getInstallcondition() {
        Logr.methodEntry("NIFPackageApplicationPlugin", "getInstallcondition");
        String sCondition = this.getParamValue(S_INSTALLCONDITION_PARAM);
        Logr.debug("NIFPackageApplicationPlugin.getInstallcondition() : Condition=" + sCondition);
        if (sCondition == null || sCondition.trim().equals(S_EMPTY) || sCondition.trim().equals(S_NULL)) {
            return true;
        }
        return new Boolean(sCondition);
    }

    protected boolean getUninstallcondition() {
        Logr.methodEntry("NIFPackageApplicationPlugin", "getUninstallcondition");
        String sCondition = this.getParamValue(S_UNINSTALLCONDITION_PARAM);
        Logr.debug("NIFPackageApplicationPlugin.getUninstallcondition() : Condition=" + sCondition);
        if (sCondition == null || sCondition.trim().equals(S_EMPTY)) {
            return true;
        }
        return new Boolean(sCondition);
    }

    private int executeInBackwardCompatibleMode() throws NIFException {
        Logr.methodEntry("NIFPackageApplicationPlugin", "executeInBackwardCompatibleMode");
        try {
            try {
                Logr.debug("NIFPackageApplicationPlugin.executeInBackwardCompatibleMode(): call backupIfNecessary()");
                this.backupIfNecessary();
            }
            finally {
                try {
                    FileSystem.flushAllFileSystems();
                }
                catch (IOException e) {
                    this.m_nReturnCode = 1;
                    Logr.warn("NIFPackageApplicationPlugin", "executeInBackwardCompatibleMode", e.getMessage(), e);
                    throw new NIFException(e, (Throwable)e);
                }
            }
            Logr.debug("NIFPackageApplicationPlugin.executeInBackwardCompatibleMode(): call performUpgrade()");
            this.performUpgrade();
        }
        finally {
            try {
                Logr.debug("NIFPackageApplicationPlugin.executeInBackwardCompatibleMode(): call performTasksAfterUpgrade()");
                this.performTasksAfterUpgrade();
            }
            finally {
                try {
                    FileSystem.flushAllFileSystems();
                }
                catch (IOException e) {
                    this.m_nReturnCode = 1;
                    Logr.warn("NIFPackageApplicationPlugin", "executeInBackwardCompatibleMode", e.getMessage(), e);
                    throw new NIFException(e, (Throwable)e);
                }
            }
        }
        Logr.methodReturn("NIFPackageApplicationPlugin", "executeInBackwardCompatibleMode", new Integer(this.m_nReturnCode).toString());
        return this.m_nReturnCode;
    }

    public String getBackupflag() {
        Logr.methodEntry("NIFPackageApplicationPlugin", "getBackupflag");
        if (new Boolean(this.getParamValue(S_ISBACKUPPACKAGE_PARAM)).booleanValue()) {
            return Boolean.FALSE.toString();
        }
        return this.getParamValue(S_BACKUPFLAG_PARAM);
    }

    public boolean isBackupPackage() {
        Logr.methodEntry("NIFPackageApplicationPlugin", "isBackupPackage");
        return new Boolean(this.getParamValue(S_ISBACKUPPACKAGE_PARAM));
    }

    public String getBackuppackageuri() {
        Logr.methodEntry("NIFPackageApplicationPlugin", "getBackuppackageuri");
        return this.getParamValue(S_BACKUPPACKAGEURI_PARAM);
    }

    public String getInstallpackageuri() {
        Logr.methodEntry("NIFPackageApplicationPlugin", "getInstallpackageuri");
        return this.getParamValue(S_INSTALLPACKAGEURI_PARAM);
    }

    public void setBackuppackageuri(URI uriBackuppackageuri) {
        Logr.methodEntry("NIFPackageApplicationPlugin", "setBackuppackageuri");
        this.setPluginParam(S_BACKUPPACKAGEURI_PARAM, new String[]{uriBackuppackageuri.toString()});
        Logr.methodExit("NIFPackageApplicationPlugin", "setBackuppackageuri");
    }

    public void setInstallpackageuri(URI uriInstallpackageuri) {
        Logr.methodEntry("NIFPackageApplicationPlugin", "setInstallpackageuri");
        this.setPluginParam(S_INSTALLPACKAGEURI_PARAM, new String[]{uriInstallpackageuri.toString()});
        Logr.methodExit("NIFPackageApplicationPlugin", "setInstallpackageuri");
    }

    @Override
    protected String[] getRequiredParams() {
        return AS_REQUIRED_PARAMS;
    }

    @Override
    protected String[] getOptionalParams() {
        return AS_EMPTY;
    }

    protected FileSystemEntry getBackupRepositoryDirEntry() throws IOException, URISyntaxException {
        Logr.methodEntry("NIFPackageApplicationPlugin", "getBackupRepositoryDirEntry");
        String sBackupZipFilePath = new URI(this.getBackuppackageuri()).getPath();
        if (sBackupZipFilePath.endsWith("/")) {
            sBackupZipFilePath = sBackupZipFilePath.substring(0, sBackupZipFilePath.length() - 1);
        }
        String sParent = sBackupZipFilePath.substring(0, sBackupZipFilePath.lastIndexOf("/"));
        FileSystemEntry fseBackupRepository = new FileSystemEntry(URIUtils.convertPathToDefaultTargetMachineFSURI(sParent, this.getInstallToolkitBridge()), this.getInstallToolkitBridge());
        Logr.methodReturn("NIFPackageApplicationPlugin", "getBackupRepositoryDirEntry", fseBackupRepository);
        return fseBackupRepository;
    }

    protected void performTasksBeforeUpgrade() {
        Logr.methodEntry("NIFPackageApplicationPlugin", "performTasksBeforeUpgrade");
    }

    protected void backupIfNecessary() throws NIFException {
        Logr.methodEntry("NIFPackageApplicationPlugin", "backupIfNecessary");
        this.initializeThisPackageInStatusRecord();
        try {
            if (new Boolean(this.getBackupflag()).booleanValue()) {
                this.updateHistoryXML();
                this.updateStackXML();
                UpdateStatusFile.setMode(this.getCachedMaintenanceInfoPlugin().getName(), "installbackup");
                this.modifyNIFMetataData(1);
                ComponentAction.executeBackupComponentActions(this.getPluginDefinitionDocument(), this.getInstallToolkitBridge());
                this.modifyNIFMetataData(2);
            }
        }
        catch (IOException e) {
            Logr.warn("NIFPackageApplicationPlugin", "backupIfNecessary", e.getMessage(), e);
            this.m_nReturnCode = 1;
            throw new NIFException(e, (Throwable)e);
        }
        catch (SAXException e) {
            Logr.warn("NIFPackageApplicationPlugin", "backupIfNecessary", e.getMessage(), e);
            this.m_nReturnCode = 1;
            throw new NIFException(e, (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            Logr.warn("NIFPackageApplicationPlugin", "backupIfNecessary", e.getMessage(), e);
            this.m_nReturnCode = 1;
            throw new NIFException(e, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            Logr.warn("NIFPackageApplicationPlugin", "backupIfNecessary", e.getMessage(), e);
            this.m_nReturnCode = 1;
            throw new NIFException(e, (Throwable)e);
        }
        catch (InstantiationException e) {
            Logr.warn("NIFPackageApplicationPlugin", "backupIfNecessary", e.getMessage(), e);
            this.m_nReturnCode = 1;
            throw new NIFException(e, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Logr.warn("NIFPackageApplicationPlugin", "backupIfNecessary", e.getMessage(), e);
            this.m_nReturnCode = 1;
            throw new NIFException(e, (Throwable)e);
        }
        catch (URISyntaxException e) {
            Logr.warn("NIFPackageApplicationPlugin", "backupIfNecessary", e.getMessage(), e);
            this.m_nReturnCode = 1;
            throw new NIFException(e, (Throwable)e);
        }
        Logr.methodExit("NIFPackageApplicationPlugin", "backupIfNecessary");
    }

    private void initializeThisPackageInStatusRecord() throws NIFException {
        try {
            Logr.methodEntry("NIFPackageApplicationPlugin", "initializeThisPackageInStatusRecord");
            MaintenanceInfoPlugin mipPackageThis = this.getCachedMaintenanceInfoPlugin();
            String sFilename = new FileSystemEntry(new URI(this.getBackuppackageuri()), this.getInstallToolkitBridge()).getEntryName();
            UpdateStatusFile.initializeThisPackageInCurrentStage(sFilename, mipPackageThis.getName(), mipPackageThis.getUritoreinstall(), this.getBackuppackageuri(), new Boolean(mipPackageThis.getWasinstalledasprimary()));
            Logr.methodExit("NIFPackageApplicationPlugin", "initializeThisPackageInStatusRecord");
        }
        catch (URISyntaxException e) {
            this.m_nReturnCode = 1;
            throw new NIFException(e, (Throwable)e);
        }
        catch (IOException e) {
            this.m_nReturnCode = 1;
            throw new NIFException(e, (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            this.m_nReturnCode = 1;
            throw new NIFException(e, (Throwable)e);
        }
    }

    protected void performTasksAfterUpgrade() throws NIFException {
        Logr.methodEntry("NIFPackageApplicationPlugin", "performTasksAfterUpgrade");
        try {
            this.updateStackXMLAfterUpgrade();
            this.updateHistoryXMLAfterUpgrade();
        }
        catch (ParserConfigurationException e) {
            Logr.warn("NIFPackageApplicationPlugin", "performTasksAfterUpgrade", e.getMessage(), e);
            throw new NIFException(e);
        }
        catch (IOException e) {
            Logr.warn("NIFPackageApplicationPlugin", "performTasksAfterUpgrade", e.getMessage(), e);
            throw new NIFException(e);
        }
        Logr.methodExit("NIFPackageApplicationPlugin", "performTasksAfterUpgrade");
    }

    protected void performUpgrade() throws NIFException {
        try {
            Logr.methodEntry("NIFPackageApplicationPlugin", "performUpgrade");
            this.updateHistoryXML();
            this.updateStackXML();
            int nReturnCode = 0;
            this.m_nReturnCode = NIFConstants.getTheReturnCodeOfHigherPriority(this.m_nReturnCode, nReturnCode);
            if (this.m_nReturnCode != 1) {
                if (this.isBackupPackage()) {
                    this.modifyNIFMetataData(5);
                    UpdateStatusFile.setMode(this.getCachedMaintenanceInfoPlugin().getName(), "uninstallupdate");
                } else {
                    this.modifyNIFMetataData(3);
                    UpdateStatusFile.setMode(this.getCachedMaintenanceInfoPlugin().getName(), "installupdate");
                }
                ComponentAction.executeComponentActions(this.getPluginDefinitionDocument(), this.getInstallToolkitBridge());
                this.deleteCurrentInstallPackageIfItsABackup();
                if (new Boolean(this.getParamValue(S_BACKUPFLAG_PARAM)).booleanValue()) {
                    NIFRegistryPlugin nifrp = NIFRegistryPlugin.getNIFRegistryPlugin(this.getInstallToolkitBridge());
                    nifrp.processThisPAKRegistryEntry(this.getCachedMaintenanceInfoPlugin().getName(), this.getBackuppackageuri(), this.isBackupPackage());
                }
                nReturnCode = 0;
                this.m_nReturnCode = NIFConstants.getTheReturnCodeOfHigherPriority(this.m_nReturnCode, nReturnCode);
                if (this.isBackupPackage()) {
                    this.m_fUninstallSucceeded = true;
                    this.modifyNIFMetataData(6);
                } else {
                    this.modifyNIFMetataData(4);
                }
                if (this.m_nReturnCode != 1) {
                    UpdateStatusFile.setMode(this.getCachedMaintenanceInfoPlugin().getName(), "complete");
                }
            }
            Logr.methodExit("NIFPackageApplicationPlugin", "performUpgrade");
            return;
        }
        catch (IOException e) {
            Logr.warn("NIFPackageApplicationPlugin", "performUpgrade", e.getMessage(), e);
            this.m_nReturnCode = 1;
            throw new NIFException(e, (Throwable)e);
        }
        catch (SAXException e) {
            Logr.warn("NIFPackageApplicationPlugin", "performUpgrade", e.getMessage(), e);
            this.m_nReturnCode = 1;
            throw new NIFException(e, (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            Logr.warn("NIFPackageApplicationPlugin", "performUpgrade", e.getMessage(), e);
            this.m_nReturnCode = 1;
            throw new NIFException(e, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            Logr.warn("NIFPackageApplicationPlugin", "performUpgrade", e.getMessage(), e);
            this.m_nReturnCode = 1;
            throw new NIFException(e, (Throwable)e);
        }
        catch (InstantiationException e) {
            Logr.warn("NIFPackageApplicationPlugin", "performUpgrade", e.getMessage(), e);
            this.m_nReturnCode = 1;
            throw new NIFException(e, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Logr.warn("NIFPackageApplicationPlugin", "performUpgrade", e.getMessage(), e);
            this.m_nReturnCode = 1;
            throw new NIFException(e, (Throwable)e);
        }
        catch (URISyntaxException e) {
            Logr.warn("NIFPackageApplicationPlugin", "performUpgrade", e.getMessage(), e);
            this.m_nReturnCode = 1;
            throw new NIFException(e, (Throwable)e);
        }
    }

    protected void modifyNIFMetataData(int nStage) throws IOException, URISyntaxException, SAXException, IllegalAccessException, ParserConfigurationException, InstantiationException, ClassNotFoundException, NIFException {
        Logr.methodEntry("NIFPackageApplicationPlugin", "modifyNIFMetataData");
        NIFPlugin[] anifp = NIFPlugin.createPlugins(this.getPluginDefinitionDocument(), this.getParamValue(S_GENERATEBACKUPMETADATAPLUGINPATH_PARAM), this.getInstallToolkitBridge());
        NIFPluginUtils.enforceAllThesePluginsAssignableFromThisClass(ModifyNIFMetaDataPlugin.class, anifp);
        NIFPlugin[] nIFPluginArray = anifp;
        int n = anifp.length;
        int n2 = 0;
        while (n2 < n) {
            NIFPlugin element = nIFPluginArray[n2];
            ModifyNIFMetaDataPlugin mnifmdpThis = (ModifyNIFMetaDataPlugin)element;
            if (mnifmdpThis.getStage() == nStage) {
                mnifmdpThis.modifyNIFMetaData();
            }
            ++n2;
        }
        Logr.methodExit("NIFPackageApplicationPlugin", "modifyNIFMetataData");
    }

    private void deleteCurrentInstallPackageIfItsABackup() throws URISyntaxException, IOException {
        Logr.methodEntry("NIFPackageApplicationPlugin", "deleteCurrentInstallPackageIfItsABackup");
        if (new Boolean(this.getParamValue(S_ISBACKUPPACKAGE_PARAM)).booleanValue()) {
            FileSystemEntry fseBackupPackage = new FileSystemEntry(new URI(this.getBackuppackageuri()), this.getInstallToolkitBridge());
            if (!fseBackupPackage.isDirectory()) {
                fseBackupPackage.delete();
                if (fseBackupPackage.exists()) {
                    fseBackupPackage.deleteOnExit();
                }
            } else {
                fseBackupPackage.deleteThisDirectoryRecursively();
            }
        }
        Logr.methodExit("NIFPackageApplicationPlugin", "deleteCurrentInstallPackageIfItsABackup");
    }

    private void updateHistoryXML() throws NIFException {
        try {
            Logr.methodEntry("NIFPackageApplicationPlugin", "updateHistoryXML");
            if (this.m_nifpeHistoryEntry != null) {
                NIFHistory.setToHighestOrder(this.m_nifpeHistoryEntry);
                NIFHistory.commit();
                return;
            }
            MaintenanceInfoPlugin mipThisPackage = this.getCachedMaintenanceInfoPlugin();
            NIFHistory.open(this.getBackupRepositoryDirEntry(), this.getInstallToolkitBridge());
            String sPath = this.getBackuppackageuri();
            String sFilename = new FileSystemEntry(new URI(sPath), this.getInstallToolkitBridge()).getEntryName();
            String sAction = "install";
            if (this.isBackupPackage()) {
                sAction = "uninstall";
            }
            this.m_nifpeHistoryEntry = NIFHistory.addToHighestOrder(mipThisPackage.getName(), mipThisPackage.getListOfAparsContained(), mipThisPackage.getListOfSupercededApars(), mipThisPackage.getListOfSupercededMaintenancePackages(), mipThisPackage.getListOfTargetproductids(), mipThisPackage.getListOfTargetsubproductids(), mipThisPackage.getBuildDate(), mipThisPackage.getAutouninstallable(), mipThisPackage.getIsbackuppackage(), mipThisPackage.getIsofficialfix(), mipThisPackage.getInfo(), "failure", sFilename, sAction, new Boolean(this.m_fUninstallableByUPDI).toString(), mipThisPackage.getWasinstalledasprimary(), mipThisPackage.getPackagetype(), mipThisPackage.getWasinstalledasmaintenance(), mipThisPackage.getPayloadid(), mipThisPackage.getPakversion(), mipThisPackage.getIsenablingifix(), mipThisPackage.getUritoreinstall(), mipThisPackage.getDependsOn(), mipThisPackage.getTargetOSandArchs());
            NIFHistory.commit();
        }
        catch (IOException e) {
            Logr.warn("NIFPackageApplicationPlugin", "updateHistoryXML", e.getMessage(), e);
            throw new NIFException(e, (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            Logr.warn("NIFPackageApplicationPlugin", "updateHistoryXML", e.getMessage(), e);
            throw new NIFException(e, (Throwable)e);
        }
        catch (SAXException e) {
            Logr.warn("NIFPackageApplicationPlugin", "updateHistoryXML", e.getMessage(), e);
            throw new NIFException(e, (Throwable)e);
        }
        catch (URISyntaxException e) {
            Logr.warn("NIFPackageApplicationPlugin", "updateHistoryXML", e.getMessage(), e);
            throw new NIFException(e, (Throwable)e);
        }
        Logr.methodExit("NIFPackageApplicationPlugin", "updateHistoryXML");
    }

    private void updateStackXML() throws SAXException, IOException, ParserConfigurationException, URISyntaxException {
        Logr.methodEntry("NIFPackageApplicationPlugin", "updateStackXML");
        if (!new Boolean(this.getParamValue(S_BACKUPFLAG_PARAM)).booleanValue()) {
            return;
        }
        NIFStack.open(this.getBackupRepositoryDirEntry(), this.getInstallToolkitBridge());
        MaintenanceInfoPlugin mipThisPackage = this.getCachedMaintenanceInfoPlugin();
        String sBackupPackageURI = this.getBackuppackageuri();
        String sFilename = new FileSystemEntry(new URI(sBackupPackageURI), this.getInstallToolkitBridge()).getEntryName();
        this.m_nifpeStackEntry = NIFStack.setAndEnsureItWithHighestOrder(mipThisPackage.getName(), mipThisPackage.getTargetproductids(), mipThisPackage.getTargetsubproductids(), mipThisPackage.getIsofficialfix(), mipThisPackage.getApars(), mipThisPackage.getIsbackuppackage(), mipThisPackage.getIscopyjdkrequired(), mipThisPackage.getAutouninstallable(), mipThisPackage.getBuildDate(), mipThisPackage.getSupercedes(), mipThisPackage.getSupercededApars(), mipThisPackage.getHasProfileUpdates(), mipThisPackage.getInfo(), sFilename, new Boolean(this.m_fUninstallableByUPDI).toString(), mipThisPackage.getWasinstalledasprimary(), mipThisPackage.getPackagetype(), mipThisPackage.getWasinstalledasmaintenance(), mipThisPackage.getPayloadid(), mipThisPackage.getPakversion(), mipThisPackage.getIsenablingifix(), mipThisPackage.getUritoreinstall(), mipThisPackage.getDependsOn(), mipThisPackage.getTargetOSandArchs(), mipThisPackage.getProducttype(), mipThisPackage.getCommonComponentRequires());
        if (!this.isBackupPackage()) {
            NIFStack.commit();
        }
        Logr.methodExit("NIFPackageApplicationPlugin", "updateStackXML");
    }

    private void updateStackXMLAfterUpgrade() throws IOException, ParserConfigurationException {
        Logr.methodEntry("NIFPackageApplicationPlugin", "updateStackXMLAfterUpgrade");
        if (this.m_nReturnCode != 1 && NIFStack.isOpen()) {
            if (this.isBackupPackage() && this.m_fUninstallSucceeded) {
                NIFStack.remove(this.getCachedMaintenanceInfoPlugin().getName());
            }
            NIFStack.commit();
        }
        Logr.methodExit("NIFPackageApplicationPlugin", "updateStackXMLAfterUpgrade");
    }

    private void updateHistoryXMLAfterUpgrade() throws NIFException {
        try {
            Logr.methodEntry("NIFPackageApplicationPlugin", "updateHistoryXMLAfterUpgrade");
            String sStatus = "success";
            if (this.m_nReturnCode == 2) {
                sStatus = "partialSuccess";
            } else if (this.m_nReturnCode == 1) {
                sStatus = "failure";
            }
            if (this.m_nifpeHistoryEntry != null) {
                this.m_nifpeHistoryEntry.updateOrAddParam("status", sStatus);
            }
            NIFHistory.commit();
        }
        catch (IOException e) {
            Logr.warn("NIFPackageApplicationPlugin", "updateHistoryXMLAfterUpgrade", e.getMessage(), e);
            throw new NIFException(e, (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            Logr.warn("NIFPackageApplicationPlugin", "updateHistoryXMLAfterUpgrade", e.getMessage(), e);
            throw new NIFException(e, (Throwable)e);
        }
        Logr.methodExit("NIFPackageApplicationPlugin", "updateHistoryXMLAfterUpgrade");
    }

    private MaintenanceInfoPlugin getCachedMaintenanceInfoPlugin() {
        return (MaintenanceInfoPlugin)NIFPlugin.getCachedPlugin(this.getParamValue(S_INFOPLUGINID_PARAM), this.getPluginDefinitionDocument(), this.getInstallToolkitBridge());
    }
}

