/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal;

import com.ibm.ws.pak.internal.NIFConstants;
import com.ibm.ws.pak.internal.NIFPlugin;
import com.ibm.ws.pak.internal.utils.NIFPluginUtils;
import com.ibm.ws.pak.internal.utils.SimpleXMLParser;
import com.ibm.ws.pak.internal.utils.XMLUtils;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.installtoolkitbridge.InstallToolkitBridge;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class NIFPluginImplOverridePlugin
extends NIFPlugin {
    private static NIFPluginImplOverridePlugin[] m_anifpiop = null;
    private static final String S_ORIGINALIMPL_PARAM = "originalimpl";
    private static final String S_NEWIMPL_PARAM = "newimpl";
    private static final String[] AS_EMPTY = new String[0];
    private static final String[] AS_REQUIRED_PARAMS = new String[]{"originalimpl", "newimpl"};
    private static final String className = "NIFPluginImplOverridePlugin";

    public static void bootstrapPluginImplOverrides(InstallToolkitBridge itb) throws IOException, ParserConfigurationException, SAXException, InstantiationException, IllegalAccessException, ClassNotFoundException, URISyntaxException {
        Logr.methodEntry(className, "bootstrapPluginImplOverrides");
        NIFPluginImplOverridePlugin.registerPluginImplOverrides(itb);
        Logr.methodExit(className, "bootstrapPluginImplOverrides");
    }

    public static String getPluginImplToUseFor(String sIncomingImpl) {
        if (!NIFPluginImplOverridePlugin.havePluginImplOverridesBeenBootstrapped()) {
            return sIncomingImpl;
        }
        NIFPluginImplOverridePlugin[] nIFPluginImplOverridePluginArray = m_anifpiop;
        int n = m_anifpiop.length;
        int n2 = 0;
        while (n2 < n) {
            NIFPluginImplOverridePlugin element = nIFPluginImplOverridePluginArray[n2];
            if (element.getOriginalimpl().equals(sIncomingImpl)) {
                return element.getNewimpl();
            }
            ++n2;
        }
        return sIncomingImpl;
    }

    public String getOriginalimpl() {
        return this.getUnresolvedParamValue(S_ORIGINALIMPL_PARAM);
    }

    public String getNewimpl() {
        return this.getUnresolvedParamValue(S_NEWIMPL_PARAM);
    }

    @Override
    protected String[] getRequiredParams() {
        return AS_REQUIRED_PARAMS;
    }

    @Override
    protected String[] getOptionalParams() {
        return AS_EMPTY;
    }

    private static boolean havePluginImplOverridesBeenBootstrapped() {
        return m_anifpiop != null;
    }

    private static void registerPluginImplOverrides(InstallToolkitBridge itb) throws IOException, ParserConfigurationException, SAXException, InstantiationException, IllegalAccessException, ClassNotFoundException, URISyntaxException {
        Logr.methodEntry(className, "registerPluginImplOverrides");
        FileSystemEntry fsePluginImplOverridesDB = new FileSystemEntry(NIFConstants.getMetadataDirectoryURI(itb), "framework/pluginimploverrides.xml", itb);
        SimpleXMLParser sxp = XMLUtils.getSimpleXMLParserFromFileSystemEntry(fsePluginImplOverridesDB);
        NIFPlugin[] anifp = NIFPlugin.createPlugins(sxp.getDocument(), "pluginimploverrides/pluginimploverride", itb);
        NIFPluginUtils.enforceAllThesePluginsAssignableFromThisClass(NIFPluginImplOverridePlugin.class, anifp);
        m_anifpiop = new NIFPluginImplOverridePlugin[anifp.length];
        int i = 0;
        while (i < anifp.length) {
            NIFPluginImplOverridePlugin.m_anifpiop[i] = (NIFPluginImplOverridePlugin)anifp[i];
            ++i;
        }
        Logr.methodExit(className, "registerPluginImplOverrides");
    }
}

