/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal;

import com.ibm.ws.pak.internal.NIFCacheManager;
import com.ibm.ws.pak.internal.NIFPluginImplOverridePlugin;
import com.ibm.ws.pak.internal.NIFPluginParamOverridePlugin;
import com.ibm.ws.pak.internal.utils.SimpleXMLParser;
import com.ibm.ws.pak.internal.utils.installtoolkitbridge.InstallToolkitBridge;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import com.ibm.ws.pak.internal.utils.macroresolvers.MacroResolver;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class NIFPlugin {
    private Hashtable m_hashtableParams = null;
    private String m_sID = null;
    private String m_sPluginPath = null;
    private InstallToolkitBridge m_itb = null;
    private Document m_documentPluginDefinitions = null;
    private Node m_nodePlugin = null;
    private static final String S_MISSING_PARAM_1 = "Required param: ";
    private static final String S_MISSING_PARAM_2 = " is missing for plugin: ";
    private static final String S_GET = "get";
    private static final String S_PLUGIN_NOT_FOUND_1 = "Plugin at path: ";
    private static final String S_PLUGIN_NOT_FOUND_2 = " with ID: ";
    private static final String S_PLUGIN_NOT_FOUND_3 = " not found.";
    private static final String className = "NIFPlugin";

    public void init() {
    }

    public static NIFPlugin[] createPlugins(Document documentPluginDefinitions, String sPluginPath, InstallToolkitBridge itb) throws ClassNotFoundException, InstantiationException, IllegalAccessException, ParserConfigurationException, SAXException, IOException {
        Vector vnodePlugins = new SimpleXMLParser(documentPluginDefinitions).getNodes(sPluginPath);
        NIFPlugin[] anifpRet = new NIFPlugin[vnodePlugins.size()];
        int i = 0;
        while (i < vnodePlugins.size()) {
            Node nodePluginThis = (Node)vnodePlugins.elementAt(i);
            String sPluginID = SimpleXMLParser.getNodeAttributeValue(nodePluginThis, "id");
            String sPluginImpl = SimpleXMLParser.getNodeAttributeValue(nodePluginThis, "impl");
            String sCacheFlag = SimpleXMLParser.getNodeAttributeValue(nodePluginThis, "cache");
            boolean fCache = Boolean.valueOf(sCacheFlag);
            Hashtable hashtableParams = NIFPlugin.getDefinedParamsForThisPlugin(nodePluginThis);
            anifpRet[i] = NIFPlugin.createPlugin(sPluginImpl, fCache, documentPluginDefinitions, nodePluginThis, sPluginID, sPluginPath, hashtableParams, itb);
            ++i;
        }
        return anifpRet;
    }

    public static NIFPlugin[] createPlugins(Document documentPluginDefinitions, String sPluginPath, InstallToolkitBridge itb, Class classTarget) throws ClassNotFoundException, InstantiationException, IllegalAccessException, ParserConfigurationException, SAXException, IOException {
        Vector vnodePlugins = new SimpleXMLParser(documentPluginDefinitions).getNodes(sPluginPath);
        Vector<NIFPlugin> vanifpReturn = new Vector<NIFPlugin>();
        int i = 0;
        while (i < vnodePlugins.size()) {
            Node nodePluginThis = (Node)vnodePlugins.elementAt(i);
            String sPluginID = SimpleXMLParser.getNodeAttributeValue(nodePluginThis, "id");
            String sPluginImpl = SimpleXMLParser.getNodeAttributeValue(nodePluginThis, "impl");
            if (NIFPlugin.isClassAAssignableFromClassB(classTarget, sPluginImpl)) {
                String sCacheFlag = SimpleXMLParser.getNodeAttributeValue(nodePluginThis, "cache");
                boolean fCache = Boolean.valueOf(sCacheFlag);
                Hashtable hashtableParams = NIFPlugin.getDefinedParamsForThisPlugin(nodePluginThis);
                vanifpReturn.add(NIFPlugin.createPlugin(sPluginImpl, fCache, documentPluginDefinitions, nodePluginThis, sPluginID, sPluginPath, hashtableParams, itb));
            }
            ++i;
        }
        return vanifpReturn.toArray(new NIFPlugin[vanifpReturn.size()]);
    }

    private static boolean isClassAAssignableFromClassB(Class classClassA, String sClassB) {
        try {
            Class<?> classClassB = Class.forName(sClassB);
            return classClassA.isAssignableFrom(classClassB);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            return false;
        }
        catch (LinkageError linkageError) {
            return false;
        }
    }

    public static NIFPlugin[] createChildPlugins(NIFPlugin nifpParent, String sRelativePluginPathToChildren, InstallToolkitBridge itb) throws ClassNotFoundException, InstantiationException, IllegalAccessException, ParserConfigurationException, SAXException, IOException {
        Vector vnodePlugins = SimpleXMLParser.getRelativeNodes(nifpParent.getPluginNode(), sRelativePluginPathToChildren);
        NIFPlugin[] anifpRet = new NIFPlugin[vnodePlugins.size()];
        int i = 0;
        while (i < vnodePlugins.size()) {
            Node nodePluginThis = (Node)vnodePlugins.elementAt(i);
            String sPluginID = SimpleXMLParser.getNodeAttributeValue(nodePluginThis, "id");
            String sPluginImpl = SimpleXMLParser.getNodeAttributeValue(nodePluginThis, "impl");
            String sCacheFlag = SimpleXMLParser.getNodeAttributeValue(nodePluginThis, "cache");
            boolean fCache = Boolean.valueOf(sCacheFlag);
            Hashtable hashtableParams = NIFPlugin.getDefinedParamsForThisPlugin(nodePluginThis);
            anifpRet[i] = NIFPlugin.createPlugin(sPluginImpl, fCache, nifpParent.getPluginDefinitionDocument(), nodePluginThis, sPluginID, String.valueOf(nifpParent.getPluginPath()) + "/" + sRelativePluginPathToChildren, hashtableParams, itb);
            ++i;
        }
        return anifpRet;
    }

    public static NIFPlugin getCachedPlugin(String sID, Document documentPluginDefinitions, InstallToolkitBridge itb) {
        return NIFCacheManager.getCachedPlugin(sID, documentPluginDefinitions, itb);
    }

    public static void flushCache() {
        NIFCacheManager.flushCache();
    }

    public static boolean isNIPlugin(Class classThis) {
        return NIFPlugin.class.isAssignableFrom(classThis);
    }

    public int hashCode() {
        if (this.m_sID != null) {
            return this.m_sID.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof NIFPlugin) {
            return this.m_sID.equals(((NIFPlugin)o).m_sID);
        }
        return false;
    }

    public final InstallToolkitBridge getInstallToolkitBridge() {
        return this.m_itb;
    }

    public final String getID() {
        return this.m_sID;
    }

    public String getPluginPath() {
        return this.m_sPluginPath;
    }

    protected abstract String[] getRequiredParams();

    protected abstract String[] getOptionalParams();

    public String getAttributeValue(String sAttributeName) {
        try {
            String sMethodName = S_GET + sAttributeName.substring(0, 1).toUpperCase(Locale.ENGLISH) + sAttributeName.substring(1);
            Method methodGetThisAttribute = this.getClass().getMethod(sMethodName, new Class[0]);
            String sReturn = (String)methodGetThisAttribute.invoke((Object)this, new Object[0]);
            return sReturn;
        }
        catch (NoSuchMethodException e) {
            Logr.error(className, "getAttributeValue", e.getMessage(), e);
            return null;
        }
        catch (InvocationTargetException e) {
            Logr.error(className, "getAttributeValue", e.getMessage(), e);
            return null;
        }
        catch (IllegalAccessException e) {
            Logr.error(className, "getAttributeValue", e.getMessage(), e);
            return null;
        }
    }

    protected void setPluginParam(String sParamName, String[] asParamValues) {
        NIFPlugin.setPluginParamInThisDocument(this.m_documentPluginDefinitions, this.getPluginNode(), sParamName, asParamValues);
        Vector<String> vValues = new Vector<String>(Arrays.asList(asParamValues));
        this.m_hashtableParams.put(sParamName, vValues);
    }

    protected void removeCurrentPluginEntryFromCurrentDocument() {
        SimpleXMLParser.deleteChildNodes(this.getPluginNode().getParentNode(), new Vector<Node>(Arrays.asList(this.getPluginNode())));
    }

    protected final Document getPluginDefinitionDocument() {
        return this.m_documentPluginDefinitions;
    }

    protected final String getParamValue(String sParamName) {
        String[] asValues = this.getParamValues(sParamName);
        if (asValues != null) {
            return asValues[0];
        }
        return null;
    }

    protected final String getUnresolvedParamValue(String sParamName) {
        String[] asValues = this.getUnResolvedParamValues(sParamName);
        if (asValues != null) {
            return asValues[0];
        }
        return null;
    }

    protected final String[] getParamValues(String sParamName) {
        Object oValues = this.m_hashtableParams.get(sParamName);
        if (oValues == null) {
            return null;
        }
        Vector vsUnparsedValues = (Vector)oValues;
        String[] asResolvedValues = new String[vsUnparsedValues.size()];
        int i = 0;
        while (i < vsUnparsedValues.size()) {
            asResolvedValues[i] = MacroResolver.resolveMacro(vsUnparsedValues.elementAt(i).toString(), this.m_itb, this.getPluginDefinitionDocument());
            ++i;
        }
        return asResolvedValues;
    }

    protected final String[] getUnResolvedParamValues(String sParamName) {
        Object oValues = this.m_hashtableParams.get(sParamName);
        if (oValues == null) {
            return null;
        }
        Vector vsUnparsedValues = (Vector)oValues;
        String[] asValues = new String[vsUnparsedValues.size()];
        int i = 0;
        while (i < vsUnparsedValues.size()) {
            asValues[i] = vsUnparsedValues.elementAt(i).toString();
            ++i;
        }
        return asValues;
    }

    protected Enumeration getIncomingParamNames() {
        return this.m_hashtableParams.keys();
    }

    protected Node getPluginNode() {
        return this.m_nodePlugin;
    }

    protected static void setPluginParamInThisDocument(Document documentPluginDefinition, String sPathToPlugin, String sPluginID, String sParamName, String[] asParamValues) throws SAXException {
        Node nodePluginThis = NIFPlugin.getPluginDefinitionNodeFromThisDocument(documentPluginDefinition, sPathToPlugin, sPluginID);
        NIFPlugin.setPluginParamInThisDocument(documentPluginDefinition, nodePluginThis, sParamName, asParamValues);
    }

    protected String[] getParamValuesForThisNode(Document documentPluginDefinition, String sPathToPlugin, String sPluginID, String sParamName) throws SAXException {
        Node nodeThis = NIFPlugin.getPluginDefinitionNodeFromThisDocument(documentPluginDefinition, sPathToPlugin, sPluginID);
        Vector vnodesParams = SimpleXMLParser.getAllNamedChildNodes(nodeThis, "param");
        Vector<String> vReturn = new Vector<String>();
        int i = 0;
        while (i < vnodesParams.size()) {
            Node nodeParamThis = (Node)vnodesParams.elementAt(i);
            String sParamNameThis = SimpleXMLParser.getNodeAttributeValue(nodeParamThis, "name");
            if (sParamNameThis != null && sParamNameThis.equals(sParamName)) {
                String sParamValueThis = SimpleXMLParser.getNodeAttributeValue(nodeParamThis, "value");
                vReturn.add(sParamValueThis);
            }
            ++i;
        }
        return vReturn.toArray(new String[vReturn.size()]);
    }

    protected Vector getExpandedParams(String sTokens) {
        if (sTokens == null) {
            return null;
        }
        Vector<String> vReturn = new Vector<String>();
        StringTokenizer st = new StringTokenizer(sTokens, ";");
        while (st.hasMoreTokens()) {
            String sTokenThis = st.nextToken().trim();
            vReturn.add(sTokenThis);
        }
        return vReturn;
    }

    protected String[] getListOfParamValues(String sParam) {
        String[] asValues = this.getParamValues(sParam);
        if (asValues == null) {
            return null;
        }
        Vector vReturn = new Vector();
        String[] stringArray = asValues;
        int n = asValues.length;
        int n2 = 0;
        while (n2 < n) {
            String asValue = stringArray[n2];
            vReturn.addAll(this.getExpandedParams(asValue));
            ++n2;
        }
        return vReturn.toArray(new String[vReturn.size()]);
    }

    protected String getStringRepresentation(Vector vsTokens) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < vsTokens.size()) {
            sb = sb.append(vsTokens.elementAt(i));
            if (i < vsTokens.size() - 1) {
                sb = sb.append(";");
            }
            ++i;
        }
        return sb.toString();
    }

    private static void setPluginParamInThisDocument(Document documentPluginDefinition, Node nodePlugin, String sParamName, String[] asParamValues) {
        Vector velementsParamRequired = NIFPlugin.getNamedPluginParamNode(nodePlugin, sParamName);
        SimpleXMLParser.deleteChildNodes(nodePlugin, velementsParamRequired);
        String[] stringArray = asParamValues;
        int n = asParamValues.length;
        int n2 = 0;
        while (n2 < n) {
            String asParamValue = stringArray[n2];
            Element elementParamRequired = documentPluginDefinition.createElement("param");
            elementParamRequired.setAttribute("name", sParamName);
            elementParamRequired.setAttribute("value", asParamValue);
            nodePlugin.appendChild(elementParamRequired);
            ++n2;
        }
    }

    private static Vector getNamedPluginParamNode(Node nodePlugin, String sParamName) {
        Vector vnodeParamsThisPlugin = SimpleXMLParser.getAllNamedChildNodes(nodePlugin, "param");
        Vector<Element> velementsReturn = new Vector<Element>();
        int i = 0;
        while (i < vnodeParamsThisPlugin.size()) {
            Element elementParamThis = (Element)vnodeParamsThisPlugin.elementAt(i);
            String sParamNameThis = SimpleXMLParser.getNodeAttributeValue(elementParamThis, "name");
            if (sParamNameThis.equals(sParamName)) {
                velementsReturn.add(elementParamThis);
            }
            ++i;
        }
        return velementsReturn;
    }

    private static Node getPluginDefinitionNodeFromThisDocument(Document document, String sPathToPlugin, String sPluginID) throws SAXException {
        Vector vnodesPlugin = new SimpleXMLParser(document).getNodes(sPathToPlugin);
        int i = 0;
        while (i < vnodesPlugin.size()) {
            Node nodePluginThis = (Node)vnodesPlugin.elementAt(i);
            String sIDThis = SimpleXMLParser.getNodeAttributeValue(nodePluginThis, "id");
            if (sPluginID.equals(sIDThis)) {
                return nodePluginThis;
            }
            ++i;
        }
        throw new SAXException(S_PLUGIN_NOT_FOUND_1 + sPathToPlugin + S_PLUGIN_NOT_FOUND_2 + sPluginID + S_PLUGIN_NOT_FOUND_3);
    }

    private static NIFPlugin createPlugin(String sPluginImpl, boolean fCache, Document documentPluginDefinitions, Node nodePlugin, String sID, String sPluginPath, Hashtable hashtableParams, InstallToolkitBridge itb) throws ClassNotFoundException, InstantiationException, IllegalAccessException, ParserConfigurationException, SAXException, IOException {
        Class<?> classPlugin = Class.forName(NIFPluginImplOverridePlugin.getPluginImplToUseFor(sPluginImpl));
        NIFPlugin nifpThis = (NIFPlugin)classPlugin.newInstance();
        hashtableParams = NIFPluginParamOverridePlugin.overrideParamsIfInstructed(sID, hashtableParams, NIFPlugin.getDocumentCacheId(documentPluginDefinitions, itb));
        NIFPlugin.enforceAllRequiredParamsArePresent(nifpThis, hashtableParams);
        nifpThis.m_documentPluginDefinitions = documentPluginDefinitions;
        nifpThis.m_nodePlugin = nodePlugin;
        nifpThis.m_sID = sID;
        nifpThis.m_sPluginPath = sPluginPath;
        nifpThis.m_hashtableParams = hashtableParams;
        nifpThis.m_itb = itb;
        nifpThis.init();
        if (fCache) {
            NIFCacheManager.cachePlugin(nifpThis, documentPluginDefinitions, itb);
        }
        return nifpThis;
    }

    private static Hashtable getDefinedParamsForThisPlugin(Node nodePluginThis) {
        Hashtable hashtableParams = new Hashtable();
        Vector vnodesParams = SimpleXMLParser.getAllNamedChildNodes(nodePluginThis, "param");
        int i = 0;
        while (i < vnodesParams.size()) {
            Node nodeParamThis = (Node)vnodesParams.elementAt(i);
            String sParamName = SimpleXMLParser.getNodeAttributeValue(nodeParamThis, "name");
            String sParamValue = NIFPlugin.getParamNodeValue(nodeParamThis);
            NIFPlugin.addThisParamValueToExistingValues(hashtableParams, sParamName, sParamValue);
            ++i;
        }
        return hashtableParams;
    }

    private static void addThisParamValueToExistingValues(Hashtable hashtableParams, String sParamName, String sParamValue) {
        Vector vsValues = new Vector();
        Object oExistingValues = hashtableParams.get(sParamName);
        if (oExistingValues != null) {
            vsValues = (Vector)oExistingValues;
            vsValues.add(sParamValue);
        } else {
            vsValues.add(sParamValue);
        }
        hashtableParams.put(sParamName, vsValues);
    }

    private static String getParamNodeValue(Node nodeParamThis) {
        String sParamValue = SimpleXMLParser.getNodeAttributeValue(nodeParamThis, "value");
        if (sParamValue == null) {
            sParamValue = SimpleXMLParser.getNodeText(nodeParamThis);
        }
        return sParamValue;
    }

    private static void enforceAllRequiredParamsArePresent(NIFPlugin nifpThis, Hashtable hashtableParams) throws InstantiationException {
        String[] asRequiredParams;
        String[] stringArray = asRequiredParams = nifpThis.getRequiredParams();
        int n = asRequiredParams.length;
        int n2 = 0;
        while (n2 < n) {
            String asRequiredParam = stringArray[n2];
            if (!hashtableParams.containsKey(asRequiredParam)) {
                throw new InstantiationException(S_MISSING_PARAM_1 + asRequiredParam + S_MISSING_PARAM_2 + nifpThis.getClass().toString());
            }
            ++n2;
        }
    }

    private static String getDocumentCacheId(Document documentPluginDefinitions, InstallToolkitBridge itb) {
        Vector vnodePlugins = new SimpleXMLParser(documentPluginDefinitions).getNodes("install-package/nif-cache");
        if (vnodePlugins != null && vnodePlugins.size() > 0) {
            Node nodePluginThis = (Node)vnodePlugins.elementAt(0);
            Vector vnodesParams = SimpleXMLParser.getAllNamedChildNodes(nodePluginThis, "param");
            int i = 0;
            while (i < vnodesParams.size()) {
                Node nodeParamThis = (Node)vnodesParams.elementAt(i);
                String sParamName = SimpleXMLParser.getNodeAttributeValue(nodeParamThis, "name");
                String sParamValue = NIFPlugin.getParamNodeValue(nodeParamThis);
                if (sParamName.equals("cacheid")) {
                    return sParamValue;
                }
                ++i;
            }
        }
        return null;
    }
}

