/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core.notify;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.IAgentEventManager;
import com.ibm.cic.agent.core.UpdateOfferingJob;
import com.ibm.cic.agent.internal.core.notify.Utils;
import com.ibm.cic.common.core.iwm.internal.model.IwmRepository;
import com.ibm.cic.common.core.iwm.internal.util.IwmUtils;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.repository.CompositeRepository;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.utils.MultiStatusUtil;
import com.ibm.cic.common.core.utils.Util;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class AgentListener
implements IAgentEventManager.AgentJobListener,
IAgentEventManager.AgentSessionListener,
IAgentEventManager.BeginFetchListener,
IAgentEventManager.FetchCompletedListener {
    private static final String ERROR = "Error";
    private static final String WARN = "Warn";
    private static final String INFO = "Info";
    private static final String SUCCESSFUL_MESSAGE = "Successful";
    private static final String CANCELLED_MESSAGE = "Cancelled";
    private static final String STATUS_BEGIN = "<status>";
    private static final String STATUS_END = "</status>";
    private static final String SERVERITY_BEGIN = "<severity>";
    private static final String SEVERITY_END = "</severity>";
    private static final String MESSAGE_BEGIN = "<message>";
    private static final String MESSAGE_END = "</message>";
    private static final String EXCEPTION_BEGIN = "<exception>";
    private static final String EXCEPTION_END = "</exception>";
    private static final String EXCEPTION_MESSAGE_BEGIN = "<msg>";
    private static final String EXCEPTION_MESSAGE_END = "</msg>";
    private static final String STACK_TRACE_BEGIN = "<stack-element>";
    private static final String STACK_TRACE_END = "</stack-element>";
    public static final String OPERATION_INSTALL = "install";

    @Override
    public IStatus beforeInstallSession(IAgentEventManager.AgentSessionEvent event) {
        return Status.OK_STATUS;
    }

    @Override
    public IStatus beforeInstallOfferingOrFix(IAgentEventManager.AgentJobEvent event) {
        return Status.OK_STATUS;
    }

    @Override
    public void afterInstallOfferingOrFix(IAgentEventManager.AgentJobEvent event) {
        String url;
        AgentJob job = event.getAgentJob();
        IOffering offering = job.getOffering();
        if (offering == null) {
            return;
        }
        IOffering updatedOffering = null;
        if (job instanceof UpdateOfferingJob) {
            UpdateOfferingJob updateJob = (UpdateOfferingJob)job;
            updatedOffering = updateJob.getUpdatedOffering();
        }
        if (Util.isValidUrl((String)(url = this.getNotificationUrl("iwm.notifyInstallComplete.url", offering)))) {
            IwmUtils.notifyOfferingInstallComplete((String)url, (IOffering)offering, (IOffering)updatedOffering, (IStatus)event.getStatus(), (Properties)Utils.getIwmMessageProperties());
        }
    }

    private String getNotificationUrl(String property, IOffering offering) {
        IRepositoryGroup group;
        IRepository repository = offering.getRepository();
        String url = this.getRepositoryProperty(property, repository);
        if ((url == null || url.length() == 0) && (offering = OfferingUtil.getBaseOffering((IRepositoryGroup)(group = Agent.getInstance().getRepositoryGroup()), (IOffering)offering)) != null) {
            repository = RepositoryUtils.getRawRepository((IRepository)offering.getRepository());
            if (repository instanceof CompositeRepository) {
                CompositeRepository composite = (CompositeRepository)repository;
                repository = RepositoryUtils.getRawRepository((IRepository)composite.getProviderRepository(offering));
            }
            url = this.getRepositoryProperty(property, repository);
        }
        return url;
    }

    private String getRepositoryProperty(String property, IRepository repository) {
        IRepository repo = RepositoryUtils.getRawRepository((IRepository)repository);
        if (repo == null) {
            return null;
        }
        return repo.getSiteProperties().getProperty(property).trim();
    }

    @Override
    public void afterInstallSession(IAgentEventManager.AgentSessionEvent event) {
    }

    @Override
    public IStatus beforeUninstallSession(IAgentEventManager.AgentSessionEvent event) {
        return Status.OK_STATUS;
    }

    @Override
    public IStatus beforeUninstallOfferingOrFix(IAgentEventManager.AgentJobEvent event) {
        return Status.OK_STATUS;
    }

    @Override
    public void afterUninstallOfferingOrFix(IAgentEventManager.AgentJobEvent event) {
    }

    @Override
    public void afterUninstallSession(IAgentEventManager.AgentSessionEvent event) {
    }

    @Override
    public void beginFetch(IAgentEventManager.AgentPhaseEvent event) {
        IOfferingOrFix of = event.getOfferingOrFix();
        if (!(of instanceof IOffering)) {
            return;
        }
        IOffering offering = (IOffering)of;
        String url = this.getNotificationUrl("iwm.notifyBeginDownload.url", offering);
        if (Util.isValidUrl((String)url)) {
            IwmUtils.notifyBeginFetch((String)url, (IOffering)offering, (String)event.getPhaseName(), (Properties)Utils.getIwmMessageProperties());
        }
    }

    @Override
    public void fetchCompleted(IAgentEventManager.AgentFetchCompletePhaseEvent event) {
        IOfferingOrFix of = event.getOfferingOrFix();
        if (!(of instanceof IOffering)) {
            return;
        }
        IOffering offering = (IOffering)of;
        String url = this.getNotificationUrl("iwm.notifyDownloadComplete.url", offering);
        if (Util.isValidUrl((String)url)) {
            String status = this.getStatusMessage(event);
            IwmUtils.notifyFetchComplete((String)url, (IOffering)offering, (String)event.getPhaseName(), (String)status, (long)event.getArtifactsSize(), (long)event.getDownloadedArtifactsSize(), (Properties)Utils.getIwmMessageProperties());
        }
    }

    private String getStatusMessage(IAgentEventManager.AgentFetchCompletePhaseEvent event) {
        String message;
        IStatus status = event.getStatus();
        if (status.isOK()) {
            message = SUCCESSFUL_MESSAGE;
        } else if (status.matches(8)) {
            message = CANCELLED_MESSAGE;
        } else if (status.getMessage().trim().length() > 0) {
            message = this.getFormattedStatusMessage(status);
        } else {
            IStatus filteredStatus = MultiStatusUtil.newFilteredStatus((String)status.getMessage().trim(), (IStatus)status, (MultiStatusUtil.IStatusFilter)new FetchCompletedStatusFilter(status));
            message = this.getFormattedStatusMessage(filteredStatus);
        }
        return message;
    }

    private String getFormattedStatusMessage(IStatus st) {
        IStatus[] children;
        StringBuffer buf = new StringBuffer();
        buf.append(STATUS_BEGIN).append(SERVERITY_BEGIN).append(this.getFormattedSeverity(st.getSeverity())).append(SEVERITY_END).append(MESSAGE_BEGIN).append(st.getMessage()).append(MESSAGE_END);
        if (st.getException() != null) {
            buf.append(EXCEPTION_BEGIN).append(EXCEPTION_MESSAGE_BEGIN).append(st.getException().toString()).append(EXCEPTION_MESSAGE_END);
            StackTraceElement[] stackTrace = st.getException().getStackTrace();
            if (stackTrace.length > 0) {
                buf.append(STACK_TRACE_BEGIN).append(stackTrace[0].toString()).append(STACK_TRACE_END);
            }
            buf.append(EXCEPTION_END);
        }
        IStatus[] iStatusArray = children = st.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus element = iStatusArray[n2];
            buf.append(this.getFormattedStatusMessage(element));
            ++n2;
        }
        buf.append(STATUS_END);
        return buf.toString();
    }

    private String getFormattedSeverity(int severity) {
        StringBuffer buf = new StringBuffer();
        if ((4 & severity) != 0) {
            this.addSeverity(buf, ERROR);
        }
        if ((2 & severity) != 0) {
            this.addSeverity(buf, WARN);
        }
        if ((1 & severity) != 0) {
            this.addSeverity(buf, INFO);
        }
        return buf.toString();
    }

    private void addSeverity(StringBuffer buf, String severity) {
        if (buf.length() > 0) {
            buf.append(",");
        }
        buf.append(severity);
    }

    public static IwmRepository getIwmRepository(IOffering offering) {
        return IwmUtils.getIwmRepository((IRepository)Agent.getInstance().getRepositoryGroup(), (IOffering)offering);
    }

    private static class FetchCompletedStatusFilter
    implements MultiStatusUtil.IStatusFilter {
        IStatus status;

        public FetchCompletedStatusFilter(IStatus status) {
            this.status = status;
        }

        public boolean considerChildren() {
            return true;
        }

        public boolean include(IStatus st) {
            return st.getSeverity() >= this.status.getSeverity() && st.getMessage().trim().length() != 0;
        }
    }
}

