/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core.history;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentActivator;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.core.history.HistoryIndex;
import com.ibm.cic.agent.internal.core.history.IActivity;
import com.ibm.cic.agent.internal.core.history.IHistory;
import com.ibm.cic.agent.internal.core.history.IHistoryListener;
import com.ibm.cic.agent.internal.core.history.IProfileInfo;
import com.ibm.cic.agent.internal.core.history.ProfileIdentity;
import com.ibm.cic.agent.internal.core.history.impl.FeatureInfoImpl;
import com.ibm.cic.agent.internal.core.history.impl.OfferingInfoImpl;
import com.ibm.cic.agent.internal.core.history.impl.ProblemInfoImpl;
import com.ibm.cic.agent.internal.core.history.impl.ProblemsResolvedInfoImpl;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.IProblemResolved;
import com.ibm.cic.common.core.model.IProblemsResolved;
import com.ibm.cic.common.logging.LogUtil;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Plugin;

public class HistoryStore {
    private static final Logger log = Logger.getLogger(HistoryStore.class, (Plugin)AgentActivator.getDefault());
    private final Agent agent;
    private HistoryIndex historyIndex = null;
    private final List dirtiedHistory = new ArrayList();
    private final List listeners = new ArrayList();

    public HistoryStore(Agent agent) {
        this.agent = agent;
        this.loadHistoryIndex();
    }

    private void loadHistoryIndex() {
        File indexFile = this.getHistoryIndexFile();
        this.historyIndex = new HistoryIndex(indexFile);
        if (indexFile.exists()) {
            this.historyIndex.load();
        }
    }

    public IProfileInfo getProfileInfo(Profile profile) {
        ProfileIdentity profileIdentity = new ProfileIdentity(profile);
        IProfileInfo profileInfo = this.historyIndex.getProfileInfo(profileIdentity);
        if (profileInfo == null) {
            profileInfo = this.historyIndex.createProfileInfo(profile);
        } else if (!profileInfo.getHistoryFilePath().contains(profile.getHistoryStorage().getAbsolutePath())) {
            this.moveProfileHistoryStorage(profile, false);
        }
        return profileInfo;
    }

    public Iterator getAllProfileInfos() {
        return this.historyIndex.getAllProfileInfos();
    }

    private File getHistoryIndexFile() {
        return this.agent.getHistoryStorage();
    }

    public String getAllHistoryFiles() {
        return String.valueOf(this.getHistoryIndexFile().getAbsolutePath()) + File.separator + "index.xml";
    }

    public IActivity createInstallActivity(IOfferingOrFix offeringToInstall, IFeature[] features, Profile profile) {
        return this.createActivity(0, new IOfferingOrFix[]{offeringToInstall}, features, profile);
    }

    public IActivity createUninstallActivity(IOfferingOrFix offeringToInstall, IFeature[] features, Profile profile) {
        return this.createActivity(1, new IOfferingOrFix[]{offeringToInstall}, features, profile);
    }

    public IActivity createUpdateActivity(IOfferingOrFix fromOffering, IOfferingOrFix toOffering, IFeature[] features, Profile profile) {
        return this.createActivity(3, new IOfferingOrFix[]{fromOffering, toOffering}, features, profile);
    }

    public IActivity createRollbackActivity(IOffering toOffering, IFeature[] features, Profile profile) {
        return this.createActivity(2, new IOfferingOrFix[]{toOffering}, features, profile);
    }

    private IActivity createActivity(int type, IOfferingOrFix[] offerings, IFeature[] features, Profile profile) {
        IProfileInfo profileInfo = this.getProfileInfo(profile);
        IHistory history = profileInfo.getHistory();
        IActivity activity = history.createActivity(type);
        IOfferingOrFix[] iOfferingOrFixArray = offerings;
        int n = offerings.length;
        int n2 = 0;
        while (n2 < n) {
            IOfferingOrFix offering = iOfferingOrFixArray[n2];
            if (offering != null) {
                OfferingInfoImpl offeringInfo = new OfferingInfoImpl(offering);
                activity.addOffering(offeringInfo);
                if (features != null) {
                    IFeature[] iFeatureArray = features;
                    int n3 = features.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IFeature feature = iFeatureArray[n4];
                        FeatureInfoImpl featureInfo = new FeatureInfoImpl(feature);
                        offeringInfo.addFeature(featureInfo);
                        ++n4;
                    }
                }
                if (type == 0 || type == 3) {
                    List problemsResolvedList = offering.getProblemsResolvedList();
                    int j = 0;
                    while (j < problemsResolvedList.size()) {
                        IProblemsResolved problems = (IProblemsResolved)problemsResolvedList.get(j);
                        ProblemsResolvedInfoImpl problemsResolvedInfo = new ProblemsResolvedInfoImpl();
                        List pList = problems.getProblems();
                        int k = 0;
                        while (k < pList.size()) {
                            IProblemResolved p = (IProblemResolved)pList.get(k);
                            ProblemInfoImpl pInfo = new ProblemInfoImpl();
                            pInfo.setProblemId(p.getId());
                            pInfo.setProblemDisplayId(p.getDisplayId());
                            problemsResolvedInfo.addProblem(pInfo);
                            ++k;
                        }
                        offeringInfo.addProblemsResolved(problemsResolvedInfo);
                        ++j;
                    }
                }
            }
            ++n2;
        }
        activity.setStartTime(LogUtil.toISO8601((long)System.currentTimeMillis()));
        this.dirtiedHistory.add(history);
        return activity;
    }

    public void beginUpdateHistory(IHistory history) {
        this.storeHistory(history);
    }

    public void updateHistory(IHistory history) {
        for (IHistoryListener listener : this.listeners) {
            listener.historyUpdated(history.getNewActivities());
        }
        this.storeHistory(history);
        this.dirtiedHistory.remove(history);
    }

    private void storeHistory(IHistory history) {
        IProfileInfo profileInfo = history.getProfileInfo();
        ProfileIdentity profileIdentity = profileInfo.getProfileIdentity();
        this.historyIndex.addProfileInfo(profileIdentity, profileInfo);
        try {
            history.commit();
        }
        catch (FileNotFoundException e) {
            log.error((Throwable)e, e.getMessage(), new Object[0]);
        }
        if (this.historyIndex.isDirty()) {
            this.historyIndex.save(this.getHistoryIndexFile());
        }
    }

    public void addListener(IHistoryListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IHistoryListener listener) {
        this.listeners.remove(listener);
    }

    public void removeAllLiseners() {
        this.listeners.clear();
    }

    public void refactorAgentProfileId(String oldProfileId, String newProfileId) {
        this.historyIndex.moveProfile(oldProfileId, newProfileId, null);
    }

    public void moveProfileHistoryStorage(Profile profile, boolean forceUseAgentHistoryStorage) {
        this.historyIndex.moveProfile(profile.getProfileId(), profile.getProfileId(), forceUseAgentHistoryStorage ? this.agent.getHistoryStorage() : profile.getHistoryStorage());
    }
}

