/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core.debug;

import com.ibm.cic.agent.core.AbstractInstallOperation;
import com.ibm.cic.agent.core.AgentActivator;
import com.ibm.cic.agent.internal.core.debug.InstallOperationDebug;
import com.ibm.cic.agent.internal.core.debug.InstallOperationDebugStackFrame;
import com.ibm.cic.common.core.internal.debug.IInstallOperationDebugStackFrame;
import com.ibm.cic.common.core.internal.debug.IInstallOperationDebugThread;
import com.ibm.cic.common.core.internal.utils.CicCommonCorePluginTrace;
import java.io.IOException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;

public class InstallOperationDebugThread
extends UnicastRemoteObject
implements IInstallOperationDebugThread {
    private static final long serialVersionUID = 1L;
    private static final CicCommonCorePluginTrace trace = AgentActivator.getDefault().getTrace();
    private final String name;

    public InstallOperationDebugThread(String name) throws IOException {
        this.name = name;
    }

    public String getThreadName() {
        trace.entering();
        trace.exiting((Object)this.name);
        return this.name;
    }

    public IInstallOperationDebugStackFrame[] getStackFrames() throws IOException {
        trace.entering();
        ArrayList<InstallOperationDebugStackFrame> framesList = new ArrayList<InstallOperationDebugStackFrame>();
        framesList.add(new InstallOperationDebugStackFrame(new InstallOperationDebugStackFrame.MainFrameVariablesContainer(), "main"));
        framesList.add(new InstallOperationDebugStackFrame(new InstallOperationDebugStackFrame.SessionFrameVariablesContainer(), "performSessionJobs"));
        if (InstallOperationDebug.INSTANCE.getEngineOperations() != null) {
            framesList.add(new InstallOperationDebugStackFrame(new InstallOperationDebugStackFrame.GroupFrameVariablesContainer(), "performPackageGroupJobs"));
            if (InstallOperationDebug.INSTANCE.getEngineOperation() != null && InstallOperationDebug.INSTANCE.getEnginePhase() != null) {
                framesList.add(new InstallOperationDebugStackFrame(new InstallOperationDebugStackFrame.EngineFrameVariablesContainer(), "performEngineOperation"));
                AbstractInstallOperation op = InstallOperationDebug.INSTANCE.getInstallOperation();
                if (op != null) {
                    InstallOperationDebugStackFrame topFrame = new InstallOperationDebugStackFrame(new InstallOperationDebugStackFrame.OperationFrameVariablesContainer(), "performOperation");
                    String topFrameName = InstallOperationDebug.INSTANCE.toString(op);
                    topFrame.setName(topFrameName);
                    framesList.add(topFrame);
                }
            }
        }
        Object[] frames = framesList.toArray(new IInstallOperationDebugStackFrame[framesList.size()]);
        trace.exiting(frames);
        return frames;
    }

    public void suspend() throws IOException {
        trace.entering();
        InstallOperationDebug.INSTANCE.suspend();
        trace.exiting();
    }

    public void resume() throws IOException {
        trace.entering();
        InstallOperationDebug.INSTANCE.resumeByClient();
        trace.exiting();
    }

    public void resumeWithError() throws IOException {
        trace.entering();
        InstallOperationDebug.INSTANCE.resumeByClientWithError();
        trace.exiting();
    }

    public void step() throws IOException {
        trace.entering();
        InstallOperationDebug.INSTANCE.step();
        trace.exiting();
    }

    public void stepOverUnit() throws IOException {
        trace.entering();
        InstallOperationDebug.INSTANCE.stepOverUnit();
        trace.exiting();
    }

    public void stepOverEnginePhase() throws IOException {
        trace.entering();
        InstallOperationDebug.INSTANCE.stepOverEnginePhase();
        trace.exiting();
    }

    public void stepOverEngineOperation() throws IOException {
        trace.entering();
        InstallOperationDebug.INSTANCE.stepOverEngineOperation();
        trace.exiting();
    }

    public void stepToSelectedUnit(String parentId, String unitId, String unitVersion) throws IOException {
        trace.entering();
        InstallOperationDebug.INSTANCE.stepToSelectedUnit(parentId, unitId, unitVersion);
        trace.exiting();
    }
}

