/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core.debug;

import com.ibm.cic.agent.core.AbstractInstallOperation;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.core.InstallOrderManager;
import com.ibm.cic.agent.internal.core.InstallRegistry;
import com.ibm.cic.agent.internal.core.debug.InstallOperationDebug;
import com.ibm.cic.agent.internal.core.debug.InstallOperationDebugValue;
import com.ibm.cic.agent.internal.core.debug.InstallOperationDebugVariable;
import com.ibm.cic.common.core.internal.debug.IInstallOperationDebugStackFrame;
import com.ibm.cic.common.core.internal.debug.IInstallOperationDebugVariable;
import com.ibm.cic.common.core.model.InstallableUnitPair;
import java.io.IOException;
import java.rmi.server.UnicastRemoteObject;

public class InstallOperationDebugStackFrame
extends UnicastRemoteObject
implements IInstallOperationDebugStackFrame {
    private static final long serialVersionUID = 1L;
    private final FrameVariablesContainer variablesContainer;
    private final String id;
    private String name;

    public InstallOperationDebugStackFrame(FrameVariablesContainer variablesContainer, String id) throws IOException {
        this.variablesContainer = variablesContainer;
        this.id = id;
        this.name = id;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IInstallOperationDebugVariable[] getVariables() {
        return this.variablesContainer.getVariables();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        sb.append("name=").append(this.name);
        sb.append('}');
        return sb.toString();
    }

    static class EngineFrameVariablesContainer
    extends FrameVariablesContainer {
        private static final InstallOperationDebugValue.TypeInfo TYPE_INFO = new InstallOperationDebugValue.TypeInfo(EngineFrameVariablesContainer.class);

        @Override
        public InstallOperationDebugValue.TypeInfo getTypeInfo() {
            return TYPE_INFO;
        }

        public InstallOperationDebugVariable createVar_engineOperation(String name) throws IOException {
            return InstallOperationDebugVariable.createEngineOperationVariable(name, this);
        }

        public InstallOrderManager.EngineOperation get_engineOperation() {
            return InstallOperationDebug.INSTANCE.getEngineOperation();
        }

        public InstallOperationDebugVariable createVar_enginePhase(String name) throws IOException {
            return InstallOperationDebugVariable.createStringVariable(name, this);
        }

        public String get_enginePhase() {
            return InstallOperationDebug.INSTANCE.getEnginePhase();
        }

        public InstallOperationDebugVariable createVar_status(String name) throws IOException {
            return InstallOperationDebugVariable.createStringVariable(name, this);
        }

        public String get_status() {
            return InstallOperationDebug.INSTANCE.getStatusText();
        }

        public boolean visible_status() {
            return InstallOperationDebug.INSTANCE.getStatusText() != null && InstallOperationDebug.INSTANCE.getInstallOperation() == null;
        }
    }

    private static abstract class FrameVariablesContainer
    extends InstallOperationDebugValue {
        public FrameVariablesContainer() throws IOException {
            super((InstallOperationDebugValue)null);
        }
    }

    static class GroupFrameVariablesContainer
    extends FrameVariablesContainer {
        private static final InstallOperationDebugValue.TypeInfo TYPE_INFO = new InstallOperationDebugValue.TypeInfo(GroupFrameVariablesContainer.class);

        @Override
        public InstallOperationDebugValue.TypeInfo getTypeInfo() {
            return TYPE_INFO;
        }

        public InstallOperationDebugVariable createVar_packageGroup(String name) throws IOException {
            return InstallOperationDebugVariable.createPackageGroupVariable(name, this);
        }

        public Profile get_packageGroup() {
            AgentJob[] jobs = InstallOperationDebug.INSTANCE.getGroupJobs();
            return jobs.length == 0 ? null : jobs[0].getProfile();
        }

        public InstallOperationDebugVariable createVar_jobs(String name) throws IOException {
            return InstallOperationDebugVariable.createArrayVariable(name, this, InstallOperationDebugValue.Job.TYPE_INFO);
        }

        public AgentJob[] get_jobs() {
            return InstallOperationDebug.INSTANCE.getGroupJobs();
        }

        public InstallOperationDebugVariable createVar_engineOperations(String name) throws IOException {
            return InstallOperationDebugVariable.createArrayVariable(name, this, InstallOperationDebugValue.EngineOperation.TYPE_INFO);
        }

        public InstallOrderManager.EngineOperation[] get_engineOperations() {
            return InstallOperationDebug.INSTANCE.getEngineOperations();
        }
    }

    static class MainFrameVariablesContainer
    extends FrameVariablesContainer {
        private static final InstallOperationDebugValue.TypeInfo TYPE_INFO = new InstallOperationDebugValue.TypeInfo(MainFrameVariablesContainer.class);

        @Override
        public InstallOperationDebugValue.TypeInfo getTypeInfo() {
            return TYPE_INFO;
        }

        public InstallOperationDebugVariable createVar_installationManagerVersion(String name) throws IOException {
            return InstallOperationDebugVariable.createStringVariable(name, this);
        }

        public String get_installationManagerVersion() {
            return Agent.getInstance().getInternalVersion().toString();
        }

        public InstallOperationDebugVariable createVar_installInfo(String name) throws IOException {
            return InstallOperationDebugVariable.createInstallInfoVariable(name, this);
        }

        public InstallRegistry get_installInfo() {
            return InstallRegistry.getInstance();
        }
    }

    static class OperationFrameVariablesContainer
    extends FrameVariablesContainer {
        private static final InstallOperationDebugValue.TypeInfo TYPE_INFO = new InstallOperationDebugValue.TypeInfo(OperationFrameVariablesContainer.class);

        @Override
        public InstallOperationDebugValue.TypeInfo getTypeInfo() {
            return TYPE_INFO;
        }

        public InstallOperationDebugVariable createVar_installContext(String name) throws IOException {
            return InstallOperationDebugVariable.createContextVariable(name, this);
        }

        public InstallContext get_installContext() {
            AbstractInstallOperation op = InstallOperationDebug.INSTANCE.getInstallOperation();
            return op == null ? null : op.getInstallContext();
        }

        public InstallOperationDebugVariable createVar_unitPair(String name) throws IOException {
            return InstallOperationDebugVariable.createPairVariable(name, this);
        }

        public InstallableUnitPair get_unitPair() {
            return InstallOperationDebug.INSTANCE.getPair();
        }

        public InstallOperationDebugVariable createVar_installOperation(String name) throws IOException {
            return InstallOperationDebugVariable.createOperationVariable(name, this);
        }

        public AbstractInstallOperation get_installOperation() {
            return InstallOperationDebug.INSTANCE.getInstallOperation();
        }

        public InstallOperationDebugVariable createVar_status(String name) throws IOException {
            return InstallOperationDebugVariable.createStringVariable(name, this);
        }

        public String get_status() {
            return InstallOperationDebug.INSTANCE.getStatusText();
        }

        public boolean visible_status() {
            return InstallOperationDebug.INSTANCE.getStatusText() != null;
        }
    }

    static class SessionFrameVariablesContainer
    extends FrameVariablesContainer {
        private static final InstallOperationDebugValue.TypeInfo TYPE_INFO = new InstallOperationDebugValue.TypeInfo(SessionFrameVariablesContainer.class);

        @Override
        public InstallOperationDebugValue.TypeInfo getTypeInfo() {
            return TYPE_INFO;
        }

        public InstallOperationDebugVariable createVar_jobs(String name) throws IOException {
            return InstallOperationDebugVariable.createArrayVariable(name, this, InstallOperationDebugValue.Job.TYPE_INFO);
        }

        public AgentJob[] get_jobs() {
            return InstallOperationDebug.INSTANCE.getJobs();
        }
    }
}

