/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core;

import com.ibm.cic.agent.core.AgentActivator;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.model.IAssembly;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.IShareableItem;
import com.ibm.cic.common.core.model.IShareableUnit;
import com.ibm.cic.common.core.model.ISuFragment;
import com.ibm.cic.common.core.model.Walker;
import com.ibm.cic.common.core.model.utils.TwoTierMap;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.repository.listeners.IRepositoryGroupEventListener;
import com.ibm.cic.common.core.repository.listeners.IRepositoryPropertyEventListener;
import com.ibm.cic.common.core.repository.listeners.RepositoryEventClear;
import com.ibm.cic.common.core.repository.listeners.RepositoryEventContentAddRemove;
import com.ibm.cic.common.core.repository.listeners.RepositoryEventContentChanged;
import com.ibm.cic.common.core.repository.listeners.RepositoryEventFileRemoved;
import com.ibm.cic.common.core.repository.listeners.RepositoryEventOpen;
import com.ibm.cic.common.core.repository.listeners.RepositoryEventProperty;
import com.ibm.cic.common.core.repository.listeners.RepositoryGroupEventAdd;
import com.ibm.cic.common.core.repository.listeners.RepositoryGroupEventRemove;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.logging.Logger;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

class MetadataCache
implements IRepositoryGroupEventListener,
IRepositoryPropertyEventListener {
    private static final Logger log = Logger.getLogger(MetadataCache.class, (Plugin)AgentActivator.getDefault());
    private final IRepositoryGroup group;
    private TwoTierMap shareableItems = null;
    private boolean dirty;
    private static final int TWO_TIER_MAP_POLICY = 11;

    public MetadataCache(IRepositoryGroup group) {
        this.group = group;
        log.debug("Created {0}", new Object[]{this});
        this.dirty = true;
        this.setRepositoryListener(true);
    }

    private void setRepositoryListener(boolean register) {
        if (register) {
            this.group.registerListener((IRepositoryPropertyEventListener)this);
            log.debug("Registered {0} as group listener", new Object[]{this});
        } else {
            this.group.unregisterListener((IRepositoryPropertyEventListener)this);
            log.debug("Unegistered {0} as group listener", new Object[]{this});
        }
        for (Object element : this.group) {
            IRepository rep = (IRepository)element;
            if (register) {
                rep.registerListener((IRepositoryPropertyEventListener)this);
                log.debug("Registered {0} as listener for {1}", new Object[]{this, rep.getLocationStr()});
                continue;
            }
            rep.unregisterListener((IRepositoryPropertyEventListener)this);
            log.debug("Unregistered {0} as listener for {1}", new Object[]{this, rep.getLocationStr()});
        }
    }

    public IRepositoryGroup getRepositoryGroup() {
        return this.group;
    }

    public IShareableEntity findShareableEntity(IIdentity id, Version version, IProgressMonitor monitor) {
        return (IShareableEntity)this.retrieve(id, version, monitor);
    }

    public Collection findShareableEntityContainers(IIdentity id, Version version, IProgressMonitor monitor) {
        this.refresh(monitor);
        ShareableItemAndContainers seAndContainers = (ShareableItemAndContainers)this.shareableItems.get((Object)id, (Object)version);
        return seAndContainers == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(seAndContainers.containers);
    }

    public Collection findShareableEntityContainers(IIdentity id, VersionRange tolerance, IProgressMonitor monitor) {
        LinkedList result = new LinkedList();
        Collection sesAndContainers = this.retrieveAll(id, monitor);
        for (ShareableItemAndContainers seAndContainers : sesAndContainers) {
            if (!tolerance.isIncluded(seAndContainers.se.getVersion())) continue;
            result.addAll(seAndContainers.containers);
        }
        return result;
    }

    private IContent retrieve(IIdentity id, Version version, IProgressMonitor monitor) {
        this.refresh(monitor);
        ShareableItemAndContainers seAndContainers = (ShareableItemAndContainers)this.shareableItems.get((Object)id, (Object)version);
        return seAndContainers == null ? null : seAndContainers.se;
    }

    private Collection retrieveAll(IIdentity id, IProgressMonitor monitor) {
        this.refresh(monitor);
        return this.shareableItems.getAll((Object)id);
    }

    public void markDirty() {
        if (!this.dirty) {
            log.debug("Dirtying {0}", new Object[]{this});
            this.dirty = true;
            this.shareableItems = null;
        }
    }

    private void refresh(IProgressMonitor monitor) {
        if (!this.dirty) {
            return;
        }
        log.start(log.debug("Refreshing {0}", new Object[]{this}));
        this.dirty = false;
        this.shareableItems = new TwoTierMap(8, 11);
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, Messages.MetadataCache_InitializingMetadataCache, new int[]{3, 3, 1, 1});
        List allOfferings = this.group.getAllOfferings(pm.next());
        this.collect(allOfferings, pm.next());
        if (pm.isCanceled()) {
            return;
        }
        List allFixes = this.group.getAllFixes(pm.next());
        this.collect(allFixes, pm.next());
        log.stop();
        this.dump();
    }

    private void collect(List offeringsOrFixes, IProgressMonitor monitor) {
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, offeringsOrFixes.size());
        for (IOfferingOrFix offeringOrFix : offeringsOrFixes) {
            if (pm.isCanceled()) break;
            IProgressMonitor pm2 = pm.next();
            if (offeringOrFix.getAssembly() == null) {
                SplitProgressMonitor spm2 = new SplitProgressMonitor(pm2, 2);
                log.statusNotOK(RepositoryUtils.resolve((IOfferingOrFix)offeringOrFix, (IProgressMonitor)spm2.next()));
                pm2 = spm2.next();
            }
            this.walk(offeringOrFix, pm2);
        }
        pm.done();
    }

    private void rememberShareableItem(IOfferingOrFix offeringOrFix, IShareableItem se) {
        ShareableItemAndContainers newSeAndContainers = new ShareableItemAndContainers(se, offeringOrFix);
        ShareableItemAndContainers oldSeAndContainers = (ShareableItemAndContainers)this.shareableItems.put((Object)se.getIdentity(), (Object)se.getVersion(), (Object)newSeAndContainers);
        if (oldSeAndContainers != null) {
            oldSeAndContainers.addContainer(newSeAndContainers.getFirstContainer());
        }
    }

    private void walk(final IOfferingOrFix offeringOrFix, IProgressMonitor monitor) {
        Walker walker = new Walker(){

            public boolean canHaveUnresolvedIncludes() {
                return true;
            }

            public void doAssembly(IAssembly asm) {
                MetadataCache.this.rememberShareableItem(offeringOrFix, (IShareableItem)asm);
            }

            public void doShareableUnit(IShareableUnit su) {
                MetadataCache.this.rememberShareableItem(offeringOrFix, (IShareableItem)su);
            }

            public void doSuFragment(ISuFragment suFragment) {
                MetadataCache.this.rememberShareableItem(offeringOrFix, (IShareableItem)suFragment);
            }
        };
        try {
            walker.walkIncludes((IContent)offeringOrFix, monitor);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return "Metadata cache for " + this.group.getName();
    }

    public void dump() {
        if (!log.isDebugLoggable()) {
            return;
        }
        StringBuffer sb = new StringBuffer(1024);
        sb.append("Group: ").append(this.group.getName()).append('\n');
        Collection repos = this.group.getRepositories();
        sb.append("Repositories: ").append(repos.size()).append('\n');
        Iterator i = repos.iterator();
        while (i.hasNext()) {
            sb.append('\t').append(i.next()).append('\n');
        }
        sb.append("Dirty: ").append(this.dirty).append('\n');
        sb.append("ShareableItems: ").append('\n');
        if (this.shareableItems.isEmpty()) {
            sb.append('\t').append("(Empty)").append('\n');
        } else {
            for (Map.Entry entry : this.shareableItems.entrySet()) {
                sb.append('\t').append(entry.getKey()).append(" = ").append(entry.getValue()).append('\n');
            }
        }
        log.debug(sb.toString());
    }

    public void repositoryGroupEventAddOccurred(RepositoryGroupEventAdd event) {
        this.markDirty();
        event.getRepository().registerListener((IRepositoryPropertyEventListener)this);
        log.debug("Registered {0} as listener for {1}", new Object[]{this, event.getRepository().getLocationStr()});
    }

    public void repositoryGroupEventRemoveOccurred(RepositoryGroupEventRemove event) {
        this.markDirty();
        event.getRepository().unregisterListener((IRepositoryPropertyEventListener)this);
        log.debug("Unregistered {0} as listener for {1}", new Object[]{this, event.getRepository().getLocationStr()});
    }

    public void repositoryPropertyEventOccurred(RepositoryEventProperty event) {
        if (event instanceof RepositoryEventContentAddRemove || event instanceof RepositoryEventOpen || event instanceof RepositoryEventContentChanged || event instanceof RepositoryEventClear || event instanceof RepositoryEventFileRemoved) {
            log.debug("Received event in {0}: {1}", new Object[]{this, event});
            this.markDirty();
        }
    }

    private static class ShareableItemAndContainers {
        public final IShareableItem se;
        public final List containers;

        private ShareableItemAndContainers(IShareableItem se, IOfferingOrFix container) {
            this.se = se;
            this.containers = new ArrayList(1);
            this.containers.add(container);
        }

        public void addContainer(IOfferingOrFix container) {
            this.containers.add(container);
        }

        public IOfferingOrFix getFirstContainer() {
            return (IOfferingOrFix)this.containers.get(0);
        }

        public String toString() {
            return "{" + this.se + " from " + this.containers + '}';
        }
    }
}

