/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core;

import com.ibm.cic.agent.core.utils.AgentUserOptions;
import com.ibm.cic.common.logging.ExceptionUtil;
import com.ibm.cic.common.logging.Logger;

public class MemoryCleanup
implements Runnable {
    private static final Logger log = Logger.getLogger(MemoryCleanup.class);
    private static final Runtime runtime = Runtime.getRuntime();
    private static final String THREAD_NAME = "Memory Cleanup";
    private static final int SLEEP_MS = 2500;
    private static final int NUM_INCREASES = 3;
    private static final long MB = 0x100000L;
    private static Thread thread = null;

    public static synchronized void start() {
        if (AgentUserOptions.CIC_DISABLE_MEMORY_CLEANUP.isSet()) {
            return;
        }
        if (thread == null) {
            thread = new Thread((Runnable)new MemoryCleanup(), THREAD_NAME);
            thread.start();
        }
    }

    public static synchronized void stop() {
        if (thread != null) {
            thread.interrupt();
            thread = null;
        }
    }

    private MemoryCleanup() {
    }

    @Override
    public void run() {
        log.debug("Start {0}", new Object[]{THREAD_NAME});
        try {
            this.doGC();
        }
        catch (InterruptedException e) {
            ExceptionUtil.debugLogToReview((Throwable)e);
        }
        MemoryCleanup.stop();
        log.debug("Stop {0}", new Object[]{THREAD_NAME});
    }

    private void doGC() throws InterruptedException {
        int increases = 0;
        do {
            long startTime = System.currentTimeMillis();
            long startFree = runtime.freeMemory();
            runtime.gc();
            long memFreed = startFree - runtime.freeMemory();
            if (log.isDebugLoggable()) {
                long elapsedTime = System.currentTimeMillis() - startTime;
                log.debug("Freed " + (memFreed + 524288L) / 0x100000L + " MB in " + elapsedTime + " ms");
            }
            increases = memFreed > 0L ? 0 : ++increases;
            Thread.sleep(2500L);
        } while (increases < 3 && !thread.isInterrupted());
    }
}

