/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core;

import com.ibm.cic.agent.core.AgentActivator;
import com.ibm.cic.agent.core.AgentSettings;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.core.IdVersion;
import com.ibm.cic.agent.internal.core.InstallRegistry;
import com.ibm.cic.agent.internal.core.InstallRegistryXML;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.InstallationContextScope;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.IdentityUtil;
import com.ibm.cic.common.core.utils.MetaInfo;
import com.ibm.cic.common.core.utils.StatusFormatter;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.core.utils.XMLParser;
import com.ibm.cic.common.logging.LogManager;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class InstallRegistryParser
extends XMLParser
implements InstallRegistryXML {
    private static final Logger log = Logger.getLogger(InstallRegistryParser.class);
    private static final int IGNORED_ELEMENT_STATE = 0;
    private static final int NO_CONTENT_STATE = 1;
    private static final int INITIAL_STATE = 2;
    private static final int INSTALL_REGISTRY_STATE = 3;
    private static final int PROFILE_STATE = 4;
    private static final int INSTALL_CONTEXT_STATE = 5;
    private static final int OFFERING_STATE = 6;
    private static final int FIX_STATE = 7;
    private static final int ENTITY_STATE = 8;
    private static final int VERSION_STATE = 9;
    private static final int SU_STATE = 10;
    private static final String[] STATE_NAMES = new String[]{"IGNORED", "NO CONTENT", "INITIAL", "installRegistry", "profile", "installContext", "offering", "fix", "entity", "version", "su"};
    private static final char SET_BEGIN = '{';
    private static final char SET_SEPARATOR = ',';
    private static final char SET_END = '}';
    private boolean parsingDataPartition = false;

    public static String serializePredefineds(Object obj) {
        if (obj instanceof Set) {
            return String.valueOf('{') + Util.toString((Set)((Set)obj), (char)',') + '}';
        }
        return (String)obj;
    }

    public static Object deserializePredefineds(String str) {
        if (str.length() >= 2 && str.charAt(0) == '{' && str.charAt(str.length() - 1) == '}') {
            return Util.toOrderedSet((String)str.substring(1, str.length() - 1), (char)',');
        }
        return str;
    }

    public InstallRegistryParser(BundleContext context) {
        super(context, AgentActivator.getPluginId());
        this.stateStack = new XMLParser.StateStack(STATE_NAMES);
    }

    public InstallRegistryParser(BundleContext context, boolean parsingDataPartition) {
        this(context);
        this.parsingDataPartition = parsingDataPartition;
    }

    public String toString() {
        return this.stateStack.toString();
    }

    protected Logger getLogger() {
        return log;
    }

    protected Object getRootObject() {
        return null;
    }

    protected String processCharacters(String trimmedChars) {
        if (trimmedChars.length() > 0) {
            this.unexpectedCharacterData(trimmedChars);
        }
        return null;
    }

    protected String getErrorMessage() {
        return NLS.bind((String)Messages.InstallRegistryParser_Error_Parsing_Install_Registry, (Object)LogManager.getDefaultLogFile().getPath());
    }

    public synchronized void parse(File file) throws IOException {
        this.status = null;
        try (FileInputStream stream = new FileInputStream(file);){
            try {
                this.getParser().parse((InputStream)stream, (DefaultHandler)((Object)this));
            }
            catch (SAXException e) {
                throw new IOException(e.getMessage());
            }
            catch (ParserConfigurationException e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if ("installRegistry".equals(target)) {
            Version registryVersion = MetaInfo.extractVersion((String)data);
            int cmp = registryVersion.compareTo(AgentSettings.getRunningAgentVersion());
            if (cmp > 0) {
                throw new SAXException(NLS.bind((String)Messages.InstallRegistryParser_Install_Registry_Has_Incompatible_Version, (Object)registryVersion, (Object)AgentSettings.getRunningAgentVersionStr()));
            }
            if (cmp != 0) {
                InstallRegistry.getInstance().setNeedsUpdateVersion(true);
            }
        }
    }

    public void startDocument() {
        this.stateStack.clear();
        this.stateStack.push(2, null);
    }

    public void endDocument() {
    }

    public void startElement(String uri, String name, String qName, Attributes attributes) {
        this.trace(name, attributes);
        switch (this.stateStack.peekState()) {
            case 0: {
                this.stateStack.push(0, (Object)("error: " + name));
                break;
            }
            case 2: {
                this.handleInitialState(name, attributes);
                break;
            }
            case 3: {
                this.handleInstallRegistryState(name, attributes);
                break;
            }
            case 4: {
                this.handleProfileState(name, attributes);
                break;
            }
            case 5: {
                this.handleInstallContextState(name, attributes);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                this.handleUnitState(name, attributes);
                break;
            }
            case 9: {
                this.handleVersionState(name, attributes);
                break;
            }
            case 10: {
                this.handleSuState(name, attributes);
                break;
            }
            case 1: {
                this.unexpectedElementError(name, attributes);
                break;
            }
            default: {
                throw new XMLParser.BadStateError((XMLParser)this);
            }
        }
    }

    public void endElement(String uri, String name, String qName) {
        this.trace(name, null);
        int state = this.stateStack.peekState();
        Object object = this.stateStack.peekObject();
        this.stateStack.pop();
        switch (state) {
            case 9: {
                this.endVersionElement((VersionInfo)object);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 5: {
                InstallRegistry.ContextInstallRegistry registry;
                InstallContext installContext = (InstallContext)object;
                Object parent = this.stateStack.peekObject();
                if (parent instanceof Profile) {
                    registry = ((Profile)parent).getInstallRegistry();
                } else if (parent instanceof InstallContext) {
                    registry = ((InstallContext)parent).getInstallRegistry();
                } else {
                    throw new AssertionError();
                }
                ((InstallRegistry.ContextInstallRegistry)registry).getContextInstallRegistry(installContext.getId());
                break;
            }
            default: {
                throw new XMLParser.BadStateError((XMLParser)this);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void endVersionElement(VersionInfo versionInfo) {
        int state = this.stateStack.peekState();
        int parentState = this.stateStack.peekState(1);
        if (parentState == 5) {
            InstallContext installContext = (InstallContext)this.stateStack.peekObject(1);
            InstallRegistry.ContextInstallRegistry registry = installContext.getInstallRegistry();
            if (state != 8) {
                throw new XMLParser.BadStateError((XMLParser)this);
            }
            registry.markEntityInstalled(versionInfo, versionInfo.ids);
            return;
        } else {
            if (parentState != 4) throw new XMLParser.BadStateError((XMLParser)this);
            Profile profile = (Profile)this.stateStack.peekObject(1);
            InstallRegistry.ProfileInstallRegistry registry = profile.getInstallRegistry();
            if (state == 6) {
                registry.markOfferingInstalled(versionInfo, versionInfo.repoInfo, versionInfo.ids, versionInfo.predefineds);
                return;
            } else if (state == 7) {
                registry.markFixInstalled(versionInfo, versionInfo.repoInfo, versionInfo.ids, versionInfo.predefineds);
                return;
            } else {
                if (state != 8) throw new XMLParser.BadStateError((XMLParser)this);
                this.getRootContextInstallRegistry(profile).markEntityInstalled(versionInfo, versionInfo.ids);
            }
        }
    }

    private void handleInitialState(String element, Attributes attributes) {
        if (element.equals("installRegistry")) {
            this.stateStack.push(3, null);
        } else {
            this.unexpectedElementError(element, attributes);
        }
    }

    private void handleInstallRegistryState(String element, Attributes attributes) {
        if (element.equals("profile")) {
            String[] values = this.parseAttributes(element, attributes, new String[]{"id"}, new String[]{"kind"});
            Profile profile = new Profile(values[0], values[1], null, this.parsingDataPartition);
            InstallRegistry.getInstance().addProfile(profile);
            this.stateStack.push(4, (Object)profile);
        } else if (element.equals("linkTo")) {
            String[] values = this.parseAttributes(element, attributes, new String[]{"dir"}, new String[0]);
            String linkToDir = values[0];
            if (!new File(linkToDir).exists()) {
                ICicStatus errorStatus = Statuses.ERROR.get(Messages.InstallRegistry_linkedDataLocationNotFound, new Object[]{linkToDir});
                this.addError(StatusFormatter.toString((IStatus)errorStatus));
            } else {
                InstallRegistryParser parser = new InstallRegistryParser(this.context, true);
                try {
                    File profileInstallRegistry = new File(linkToDir, "installRegistry.xml");
                    parser.parse(profileInstallRegistry);
                }
                catch (IOException e) {
                    this.addError(e.getMessage());
                }
                if (!parser.getStatus().isOK()) {
                    this.addError(parser.getStatus().getMessage());
                }
            }
            this.stateStack.push(1, null);
        } else if (element.equals("linkFrom")) {
            this.stateStack.push(1, null);
        } else if (element.equals("property")) {
            this.handleProperty(attributes);
        } else {
            this.unexpectedElementError(element, attributes);
        }
    }

    private void handleProfileState(String element, Attributes attributes) {
        if (element.equals("installContext")) {
            this.stateStack.push(5, (Object)this.parseInstallContext(attributes));
        } else if (element.equals("property")) {
            this.handleProperty(attributes);
        } else {
            String id = this.parseRequiredAttribute(element, attributes, "id");
            if (element.equals("offering")) {
                this.stateStack.push(6, (Object)id);
            } else if (element.equals("fix")) {
                this.stateStack.push(7, (Object)id);
            } else if (element.equals("entity")) {
                this.stateStack.push(8, (Object)id);
            } else {
                this.unexpectedElementError(element, attributes);
            }
        }
    }

    private void handleInstallContextState(String element, Attributes attributes) {
        if (element.equals("installContext")) {
            this.stateStack.push(5, (Object)this.parseInstallContext(attributes));
        } else if (element.equals("adapter")) {
            String adapterType = this.parseRequiredAttribute(element, attributes, "type");
            InstallContext installContext = (InstallContext)this.stateStack.peekObject();
            installContext.addAdaptorType(adapterType);
            this.stateStack.push(1, null);
        } else if (element.equals("property")) {
            this.handleProperty(attributes);
        } else if (element.equals("entity")) {
            String id = this.parseRequiredAttribute(element, attributes, "id");
            this.stateStack.push(8, (Object)id);
        } else if (element.equals("su")) {
            String id = this.parseRequiredAttribute(element, attributes, "id");
            this.stateStack.push(10, (Object)id);
        } else {
            this.unexpectedElementError(element, attributes);
        }
    }

    private void handleSuState(String element, Attributes attributes) {
        if (element.equals("iu")) {
            String[] values = this.parseRequiredAttributes(element, attributes, "id", "version");
            String id = values[0];
            String version = values[1];
            String suId = (String)this.stateStack.peekObject();
            InstallContext installContext = (InstallContext)this.stateStack.peekObject(1);
            InstallRegistry.ContextInstallRegistry registry = installContext.getInstallRegistry();
            String qualifiedId = IdentityUtil.createQualifiedId((String)suId, (String)id);
            registry.markInstalled(new IdVersion(qualifiedId, version));
            this.stateStack.push(1, null);
        } else {
            this.unexpectedElementError(element, attributes);
        }
    }

    private void handleProperty(Attributes attributes) {
        XMLParser.PropertyPair p = this.parseProperty(attributes);
        if (!p.isValid()) {
            return;
        }
        switch (this.stateStack.peekState()) {
            case 3: {
                if (this.parsingDataPartition) break;
                if (p.name.equals("cacheLocation")) {
                    InstallRegistry.getInstance().setCacheLocation(p.value);
                    break;
                }
                InstallRegistry.getInstance().setProperty(p.name, p.value);
                break;
            }
            case 4: {
                Profile profile = (Profile)this.stateStack.peekObject();
                if (p.name.equals("cacheLocation")) break;
                if (p.name.equals("installLocation")) {
                    IStatus locationStatus = profile.setInstallLocation(p.value);
                    if (!CicCommonSettings.getAccessRightsMode().isGroupMode() || !profile.isAgentProfile() || locationStatus.isOK()) break;
                    if (this.status == null) {
                        this.status = (CicMultiStatus)locationStatus;
                        break;
                    }
                    this.status.add(locationStatus);
                    break;
                }
                profile.setData(p.name, p.value);
                break;
            }
            case 5: {
                InstallContext installContext = (InstallContext)this.stateStack.peekObject();
                installContext.setLocalProperty(p.name, p.value);
                break;
            }
            default: {
                throw new XMLParser.BadStateError((XMLParser)this);
            }
        }
        this.stateStack.push(1, null);
    }

    private boolean getBooleanAttributeValue(String attrValue, boolean defaultValue) {
        if (attrValue == null) {
            return defaultValue;
        }
        return Boolean.valueOf(attrValue);
    }

    private InstallContext parseInstallContext(Attributes attributes) {
        InstallContext installContext;
        InstallationContextScope scope;
        String[] values = this.parseAttributes("installContext", attributes, new String[]{"id"}, new String[]{"name", "description", "shareable", "qualifiable", "scope"});
        String id = values[0];
        String name = values[1];
        String description = values[2];
        boolean shareable = this.getBooleanAttributeValue(values[3], true);
        boolean qualifiable = this.getBooleanAttributeValue(values[4], false);
        InstallationContextScope installationContextScope = scope = values[5] == null ? InstallationContextScope.NONE_SCOPE : InstallationContextScope.nameToInstallContextScope((String)values[5]);
        if (4 == this.stateStack.peekState()) {
            Profile parentProfile = (Profile)this.stateStack.peekObject();
            installContext = new InstallContext(parentProfile, id, name, description, shareable, qualifiable, scope);
            if (parentProfile.getRootContext() != null) {
                throw new XMLParser.BadStateError((XMLParser)this, "installContext");
            }
            parentProfile.setRootContext(installContext);
        } else if (5 == this.stateStack.peekState()) {
            InstallContext parentContext = (InstallContext)this.stateStack.peekObject();
            installContext = new InstallContext(parentContext, id, name, description, shareable, qualifiable, scope);
        } else {
            throw new XMLParser.BadStateError((XMLParser)this, "installContext");
        }
        return installContext;
    }

    private void handleUnitState(String element, Attributes attributes) {
        if (element.equals("version")) {
            String[] values = this.parseAttributes(element, attributes, new String[]{"value"}, new String[]{"repoInfo"});
            String id = (String)this.stateStack.peekObject();
            VersionInfo versionInfo = new VersionInfo(id, values[0], values[1]);
            this.stateStack.push(9, (Object)versionInfo);
        } else {
            this.unexpectedElementError(element, attributes);
        }
    }

    private void handleVersionState(String element, Attributes attributes) {
        VersionInfo versionInfo = (VersionInfo)this.stateStack.peekObject();
        if (element.equals("selector")) {
            String id = this.parseRequiredAttribute(element, attributes, "id");
            versionInfo.ids.add(id);
            this.checkParentState(8, element);
        } else if (element.equals("feature")) {
            String id = this.parseRequiredAttribute(element, attributes, "id");
            versionInfo.ids.add(id);
            this.checkParentState(6, element);
        } else if (element.equals("predefined")) {
            String[] values = this.parseRequiredAttributes(element, attributes, "key", "value");
            versionInfo.predefineds.put(values[0], InstallRegistryParser.deserializePredefineds(values[1]));
        } else if (element.equals("usage")) {
            InstallRegistry.ContextInstallRegistry registry;
            String[] values = this.parseRequiredAttributes(element, attributes, new String[]{"id", "version", "tolerance"});
            SimpleIdentity id = new SimpleIdentity(values[0]);
            Version version = new Version(values[1]);
            VersionRange tolerance = new VersionRange(values[2]);
            VersionInfo info = (VersionInfo)this.stateStack.peekObject();
            if (this.stateStack.peekState(2) == 4) {
                Profile profile = (Profile)this.stateStack.peekObject(2);
                registry = this.getRootContextInstallRegistry(profile);
            } else {
                InstallContext installContext = (InstallContext)this.stateStack.peekObject(2);
                registry = installContext.getInstallRegistry();
            }
            registry.markEntityUsage(info.getIdentity(), info.getVersion(), (IIdentity)id, version, tolerance);
            this.checkParentState(8, element);
        } else {
            this.unexpectedElementError(element, attributes);
        }
        this.stateStack.push(1, null);
    }

    private InstallRegistry.ContextInstallRegistry getRootContextInstallRegistry(Profile profile) {
        InstallContext installContext = profile.getRootContext();
        return installContext != null ? installContext.getInstallRegistry() : profile.getInstallRegistry().getContextInstallRegistry(profile.makeRootContextId());
    }

    private static class VersionInfo
    extends IdVersion {
        public final String repoInfo;
        public final Set<String> ids = new LinkedHashSet<String>();
        public final Map<String, Object> predefineds = new LinkedHashMap<String, Object>();

        public VersionInfo(String id, String version, String repoInfo) {
            super((IIdentity)new SimpleIdentity(id), new Version(version));
            this.repoInfo = repoInfo;
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + ": " + this.ids;
        }
    }
}

