/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.sharedUI;

import com.ibm.cic.agent.core.sharedUI.FeatureGroupStatus;
import com.ibm.cic.agent.core.sharedUI.FeatureStatus;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.List;
import org.eclipse.core.runtime.IStatus;

public class OfferingFeatureStatus {
    private final IOfferingOrFix offeringOrFix;
    private final CicMultiStatus offeringOrFixStatus;
    private final List<FeatureStatus> featureStatusList;
    private final List<FeatureGroupStatus> featureGroupStatusList;
    private Boolean featureOrGroupHasError = null;
    private CicMultiStatus offeringValidationSummaryStatus = null;

    public OfferingFeatureStatus(IOfferingOrFix offeringOrFix, CicMultiStatus status, List<FeatureStatus> featureStatusList, List<FeatureGroupStatus> featureGroupStatusList) {
        this.offeringOrFix = offeringOrFix;
        this.offeringOrFixStatus = status;
        this.featureStatusList = featureStatusList;
        this.featureGroupStatusList = featureGroupStatusList;
    }

    public List<FeatureStatus> getFeatureStatusList() {
        return this.featureStatusList;
    }

    public List<FeatureGroupStatus> getFeatureGroupStatusList() {
        return this.featureGroupStatusList;
    }

    public IOfferingOrFix getOfferingOrFix() {
        return this.offeringOrFix;
    }

    public CicMultiStatus getOfferingOrFixStatus() {
        return this.offeringOrFixStatus;
    }

    public boolean offeringContainErrorFeatureOrGroup() {
        IStatus status;
        if (this.featureOrGroupHasError != null) {
            return this.featureOrGroupHasError;
        }
        int i = 0;
        while (i < this.featureStatusList.size()) {
            FeatureStatus featureStatus = this.featureStatusList.get(i);
            status = featureStatus.getStatus();
            if (status != null && StatusUtil.isErrorOrCancel((IStatus)status)) {
                this.featureOrGroupHasError = Boolean.TRUE;
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < this.featureGroupStatusList.size()) {
            FeatureGroupStatus groupStatus = this.featureGroupStatusList.get(i);
            status = groupStatus.getStatus();
            if (status != null && StatusUtil.isErrorOrCancel((IStatus)status)) {
                this.featureOrGroupHasError = Boolean.TRUE;
                return true;
            }
            ++i;
        }
        this.featureOrGroupHasError = Boolean.FALSE;
        return false;
    }

    public CicMultiStatus getOfferingValidationSummaryStatus() {
        if (this.offeringValidationSummaryStatus == null) {
            IStatus status;
            this.offeringValidationSummaryStatus = Statuses.ST.createMultiStatus();
            this.offeringValidationSummaryStatus.add((IStatus)this.offeringOrFixStatus);
            for (FeatureStatus featureStatus : this.featureStatusList) {
                status = featureStatus.getStatus();
                if (status == null || status.isOK()) continue;
                this.offeringValidationSummaryStatus.add(status);
            }
            for (FeatureGroupStatus groupStatus : this.featureGroupStatusList) {
                status = groupStatus.getStatus();
                if (status == null || status.isOK()) continue;
                this.offeringValidationSummaryStatus.add(status);
            }
        }
        return this.offeringValidationSummaryStatus;
    }
}

