/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.response.impl;

import com.ibm.cic.agent.core.internal.response.IActionElement;
import com.ibm.cic.agent.core.internal.response.IElementProxy;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;

public class ElementMatch {
    private IElementProxy sourceElement;
    private IElementProxy targetElement;
    private List childSourceElements;
    private final Map elementMap = new HashMap();
    private final List unmatchedTargetList = new ArrayList();
    private boolean matchPerformed = false;

    public ElementMatch(IElementProxy sourceElement, IElementProxy targetElement) {
        this.init(sourceElement, targetElement);
    }

    public ElementMatch(IActionElement sourceElement) {
        this.init(sourceElement, null);
    }

    private void init(IElementProxy srcElement, IElementProxy tgtElement) {
        this.sourceElement = srcElement;
        this.childSourceElements = this.sourceElement.getChildElements();
        this.targetElement = tgtElement;
    }

    public List getUnmatchedTargetElements() {
        if (!this.matchPerformed) {
            this.matchChildElements();
            this.matchPerformed = true;
        }
        return this.unmatchedTargetList;
    }

    public List getChildSourceElements() {
        return this.childSourceElements;
    }

    public List getTargetElements(IElementProxy srcElm) {
        List targetElements;
        if (!this.matchPerformed) {
            this.matchChildElements();
            this.matchPerformed = true;
        }
        return (targetElements = (List)this.elementMap.get(srcElm)) == null ? Collections.EMPTY_LIST : targetElements;
    }

    private IStatus matchChildElements() {
        CicMultiStatus ret = Statuses.ST.createMultiStatus();
        if (this.targetElement == null) {
            return ret;
        }
        this.childSourceElements = this.sourceElement.getChildElements();
        List childTargetElements = this.targetElement.getChildElements();
        HashSet<IElementProxy> matchedTargetElements = new HashSet<IElementProxy>();
        for (IElementProxy srcElement : this.childSourceElements) {
            for (IElementProxy tgtElement : childTargetElements) {
                if (!srcElement.match(tgtElement)) continue;
                ArrayList<IElementProxy> matchingTargetElements = (ArrayList<IElementProxy>)this.elementMap.get(srcElement);
                if (matchingTargetElements == null) {
                    matchingTargetElements = new ArrayList<IElementProxy>();
                    this.elementMap.put(srcElement, matchingTargetElements);
                }
                matchingTargetElements.add(tgtElement);
                matchedTargetElements.add(tgtElement);
            }
        }
        for (IElementProxy tgtElement : childTargetElements) {
            if (matchedTargetElements.contains(tgtElement)) continue;
            this.unmatchedTargetList.add(tgtElement);
        }
        return ret;
    }
}

