/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.response.impl;

import com.ibm.cic.agent.core.internal.response.IElement;
import com.ibm.cic.agent.core.internal.response.IElementProxy;
import com.ibm.cic.common.core.utils.XMLUtil;
import com.ibm.cic.common.logging.LogUtil;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Element
implements IElement {
    private final String name;
    private final List children = new ArrayList();
    private final Map attributes = new HashMap();
    private IElement parent;

    public Element(String elmName) {
        this.name = elmName;
    }

    @Override
    public void setAttribute(String localName, String value) {
        this.attributes.put(localName, value);
    }

    @Override
    public void addChild(IElement element) {
        element.setParent(this);
        this.children.add(element);
    }

    @Override
    public IElement getChild(int i) {
        return (IElement)this.children.get(i);
    }

    @Override
    public boolean hasChild() {
        return !this.children.isEmpty();
    }

    protected List getChildren(String elmName) {
        ArrayList<IElement> ret = new ArrayList<IElement>();
        for (IElement child : this.children) {
            if (!child.getElementName().equals(elmName)) continue;
            ret.add(child);
        }
        return ret;
    }

    @Override
    public String getElementName() {
        return this.name;
    }

    @Override
    public String getAttribute(String attrName, String defaultValue) {
        String ret = this.getAttribute(attrName);
        return ret == null ? defaultValue : ret;
    }

    private String getAttribute(String attrName) {
        return (String)this.attributes.get(attrName);
    }

    @Override
    public boolean getBooleanAttribute(String attrName, boolean defaultValue) {
        String ret = this.getAttribute(attrName);
        return ret == null ? defaultValue : Boolean.valueOf(ret);
    }

    @Override
    public boolean isAttributeSet(String attrName) {
        return this.getAttribute(attrName) != null;
    }

    @Override
    public void setBooleanAttribute(String attrName, boolean value) {
        this.setAttribute(attrName, Boolean.toString(value));
    }

    @Override
    public void unsetAttribute(String attrName) {
        this.attributes.remove(attrName);
    }

    @Override
    public int getChildrenSize() {
        return this.children.size();
    }

    @Override
    public List getChildElements() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public String getConfigName() {
        return this.name;
    }

    @Override
    public void save(PrintWriter output) {
        output.print(LogUtil.fixNewlines((String)this.toString()));
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("<" + this.getElementName());
        if (this.attributes != null) {
            for (String attrName : this.attributes.keySet()) {
                String attrValue = (String)this.attributes.get(attrName);
                result.append(String.valueOf(' ') + attrName + "='" + XMLUtil.escape((String)attrValue) + '\'');
            }
        }
        if (this.children == null || this.children.size() == 0) {
            result.append("/>\n");
        } else {
            result.append(">\n");
            for (IElement child : this.children) {
                result.append(child.toString());
            }
            result.append("</" + this.getElementName() + ">\n");
        }
        return result.toString();
    }

    @Override
    public IElement getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Element parent) {
        this.parent = parent;
    }

    @Override
    public boolean match(IElementProxy tgtElement) {
        return this.getConfigName().equals(tgtElement.getConfigName());
    }
}

