/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.expander;

import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.InstallContextTree;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.InstallableUnitPair;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

class InstallContextMerger {
    private static final Logger log2 = Logger.getLogger();

    private InstallContextMerger() {
        assert (false) : "no instances";
    }

    public static void merge(InstallContextTree rootTree, IProgressMonitor monitor) {
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, 2);
        InstallContextMerger.merge(false, rootTree, pm.next());
        InstallContextMerger.merge(true, rootTree, pm.next());
    }

    private static void merge(boolean wantEclipse, InstallContextTree parentTree, IProgressMonitor monitor) {
        List childTrees = parentTree.getSubTrees();
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, 2 * childTrees.size());
        for (InstallContextTree childTree : childTrees) {
            InstallContext childContext = childTree.getInstallContext();
            if (childContext == null) continue;
            boolean allowsEclipse = childContext.allowsAdaptorType("eclipse");
            if (wantEclipse == allowsEclipse) {
                InstallContextMerger.merge(parentTree, childTree, pm.next());
            }
            InstallContextMerger.merge(wantEclipse, childTree, pm.next());
        }
    }

    private static void merge(InstallContextTree parentTree, InstallContextTree childTree, IProgressMonitor monitor) {
        boolean mergeNative;
        InstallContext parentContext = parentTree.getInstallContext();
        InstallContext childContext = childTree.getInstallContext();
        if (parentContext.doNotMerge() || childContext.doNotMerge()) {
            return;
        }
        boolean mergeEclipse = childContext.allowsAdaptorType("eclipse") && InstallContextMerger.locationMatches(childContext, parentContext, "configLocation");
        boolean bl = mergeNative = childContext.allowsAdaptorType("native") && InstallContextMerger.locationMatches(childContext, parentContext, "installLocation");
        if (!mergeEclipse && !mergeNative) {
            return;
        }
        parentTree.getProfile().getInstallRegistry().resolveIUs(monitor);
        InstallableUnitPair.List parentPairs = parentTree.getPairs();
        if (parentPairs.size() == 0) {
            return;
        }
        InstallableUnitPair.List childPairs = childTree.getPairs();
        log2.debug("Merging tree {0} into {1}", new Object[]{parentTree, childTree});
        Iterator j = parentPairs.iterator();
        while (j.hasNext()) {
            IInstallableUnit from;
            IInstallableUnit prevTo;
            InstallableUnitPair pair = (InstallableUnitPair)j.next();
            boolean isEclipsePair = pair.getAdapterId().equals("eclipse");
            if ((!mergeNative || isEclipsePair) && (!mergeEclipse || !isEclipsePair)) continue;
            IInstallableUnit to = pair.getTo();
            if (to != null && (prevTo = childPairs.addTo(to)) != null) {
                if (to.equals(prevTo)) {
                    log2.warning(Messages.AgentSelectorExpander_Duplicate_Conflict, new Object[]{childTree.getId(), pair.getQualifiedId(), prevTo.getVersion()});
                } else {
                    log2.warning(Messages.AgentSelectorExpander_Merge_Conflict, new Object[]{childTree.getId(), pair.getQualifiedId(), prevTo.getVersion(), to.getVersion()});
                }
            }
            if ((from = pair.getFrom()) != null) {
                IInstallableUnit prevFrom = childPairs.addFrom(from);
                assert (prevFrom == null) : prevFrom;
            }
            log2.debug("Merged IU: {0}", new Object[]{childPairs.get(pair.getQualifiedId())});
            j.remove();
        }
    }

    private static boolean locationMatches(InstallContext context, InstallContext parentContext, String property) {
        String parentProperty;
        String contextProperty = context.getProperty(property);
        if (Util.equals((Object)contextProperty, (Object)(parentProperty = parentContext.getProperty(property)))) {
            return true;
        }
        if (parentProperty == null) {
            return parentContext.isRootContext();
        }
        if (contextProperty == null) {
            return false;
        }
        try {
            return new File(contextProperty).getCanonicalPath().equals(new File(parentProperty).getCanonicalPath());
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

