/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.commands;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.internal.commands.IParseMessageFormatter;
import com.ibm.cic.agent.core.internal.commands.MissingRequiredAttrException;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;

public class XMLRule {
    private final int id;
    private final String elementName;
    private final Map attributes = new HashMap();
    private final Map deprecatedAttributeMap = new HashMap();
    private final Map childXMLRules = new HashMap();

    public XMLRule(int id, String elementName, String[] requiredAttributesNames, String[] optionalAttributesNames) {
        int n;
        int n2;
        String[] stringArray;
        this.id = id;
        this.elementName = elementName;
        if (requiredAttributesNames != null) {
            stringArray = requiredAttributesNames;
            n2 = requiredAttributesNames.length;
            n = 0;
            while (n < n2) {
                String requiredAttributesName = stringArray[n];
                this.attributes.put(requiredAttributesName, Boolean.TRUE);
                ++n;
            }
        }
        if (optionalAttributesNames != null) {
            stringArray = optionalAttributesNames;
            n2 = optionalAttributesNames.length;
            n = 0;
            while (n < n2) {
                String optionalAttributesName = stringArray[n];
                this.attributes.put(optionalAttributesName, Boolean.FALSE);
                ++n;
            }
        }
    }

    public XMLRule(int id, String elementName, String[] requiredAttributesNames, String[] optionalAttributesNames, DeprecatedAttribute[] deprecatedAttributes) {
        this(id, elementName, requiredAttributesNames, optionalAttributesNames);
        if (deprecatedAttributes != null) {
            DeprecatedAttribute[] deprecatedAttributeArray = deprecatedAttributes;
            int n = deprecatedAttributes.length;
            int n2 = 0;
            while (n2 < n) {
                DeprecatedAttribute deprecatedAttribute = deprecatedAttributeArray[n2];
                this.deprecatedAttributeMap.put(deprecatedAttribute.name, deprecatedAttribute.message);
                ++n2;
            }
        }
    }

    private IStatus validateAttributes(Attributes attrs, IParseMessageFormatter formatter) throws MissingRequiredAttrException {
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        if (attrs != null) {
            int len = attrs.getLength();
            int i = 0;
            while (i < len) {
                String name = attrs.getLocalName(i);
                if (!this.attributes.containsKey(name)) {
                    status.add((IStatus)new Status(2, Agent.PI_AGENT, 2, formatter.formatMessage(NLS.bind((String)Messages.HeadlessApplication_Not_Recognized_Attribute, (Object)name, (Object)this.elementName)), null));
                } else if (this.deprecatedAttributeMap.containsKey(name)) {
                    status.add((IStatus)new Status(2, Agent.PI_AGENT, 2, formatter.formatMessage((String)this.deprecatedAttributeMap.get(name)), null));
                }
                ++i;
            }
        }
        for (String attribute : this.attributes.keySet()) {
            if (Boolean.FALSE.equals(this.attributes.get(attribute)) || attrs != null && attrs.getIndex("", attribute) != -1) continue;
            throw new MissingRequiredAttrException(attribute);
        }
        return status;
    }

    public XMLRule validateChildElement(String childElementName, Attributes attrs, CicMultiStatus status, IParseMessageFormatter formatter) throws MissingRequiredAttrException {
        XMLRule childXMLRule = (XMLRule)this.childXMLRules.get(childElementName);
        if (childXMLRule != null && childXMLRule.getId() != 26) {
            status.add(childXMLRule.validateAttributes(attrs, formatter));
        } else {
            status.add((IStatus)new Status(2, Agent.PI_AGENT, 2, formatter.formatMessage(NLS.bind((String)Messages.InputParser_Unexpected_Element, (Object)childElementName, (Object)this.getElementName())), null));
            childXMLRule = new XMLRule(26, childElementName, new String[0], new String[0]);
        }
        return childXMLRule;
    }

    public boolean isValidElementName(String name) {
        return this.elementName.equals(name);
    }

    public void addChildRule(XMLRule childRule) {
        this.childXMLRules.put(childRule.getElementName(), childRule);
    }

    public String getElementName() {
        return this.elementName;
    }

    public int getId() {
        return this.id;
    }

    public static class DeprecatedAttribute {
        public final String name;
        public final String message;

        public DeprecatedAttribute(String name, String message) {
            this.name = name;
            this.message = message;
        }
    }
}

