/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.commands;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentActivator;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.core.internal.commands.AbstractCommand;
import com.ibm.cic.agent.core.internal.commands.HeadlessApplicationException;
import com.ibm.cic.agent.core.internal.headless.IViewLicenseCommand;
import com.ibm.cic.agent.core.internal.headless.InstallFixesAction;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.cmd.ACmdLine;
import com.ibm.cic.common.core.cmd.CmdRepositoryUtils;
import com.ibm.cic.common.core.cmd.CmdUtils;
import com.ibm.cic.common.core.cmd.SilentRepositoryUtils;
import com.ibm.cic.common.core.internal.LicenseFactory;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.MultiStatusUtil;
import com.ibm.cic.common.core.utils.OutputFormatter;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.StatusFormatter;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.Logger;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class ViewLicenseCommand
extends AbstractCommand
implements IViewLicenseCommand {
    private static final Logger log = Logger.getLogger(ViewLicenseCommand.class, (Plugin)AgentActivator.getDefault());
    private String offeringOrFixId;
    private String offeringOrFixVersion;

    public ViewLicenseCommand() {
        super("viewLicense");
    }

    @Override
    public IStatus execute(Agent agent, IProgressMonitor monitor) {
        OutputFormatter output = new OutputFormatter();
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, 3);
        try {
            try {
                this.openServiceRepositories(agent, spm.next());
                IOfferingOrFix offeringOrFix = this.findOfferingOrFix(agent, this.offeringOrFixId, this.offeringOrFixVersion, spm.next());
                if (offeringOrFix == null) {
                    if (this.offeringOrFixVersion == null) {
                        throw new CoreException((IStatus)Statuses.ERROR.get(4, Messages.AbstractCommand_Cannot_Find_Offering_Or_Fix, new Object[]{this.offeringOrFixId}));
                    }
                    throw new CoreException((IStatus)Statuses.ERROR.get(4, Messages.AbstractCommand_Cannot_Find_Offering_Or_Fix_Version, new Object[]{this.offeringOrFixId, this.offeringOrFixVersion}));
                }
                this.prepareOfferingOrFix(offeringOrFix, agent, spm.next());
                LicenseFactory.License[] licenses = this.getLicenses(offeringOrFix);
                this.printLicenses(licenses, output, Locale.getDefault());
            }
            catch (CoreException e) {
                IStatus iStatus = e.getStatus();
                spm.done();
                return iStatus;
            }
        }
        finally {
            spm.done();
        }
        System.out.print(output.toString());
        return Status.OK_STATUS;
    }

    @Override
    public int getExecutionPoint() {
        return 4;
    }

    @Override
    public void setOfferingOrFix(String id, String version) {
        this.offeringOrFixId = id;
        this.offeringOrFixVersion = version;
    }

    private Set getInstalledOfferings(Agent agent, String id, IProgressMonitor monitor) {
        List profiles = agent.getProfilesByOfferingOrFixId(id);
        if (profiles != null && profiles.size() > 0) {
            HashSet<IOffering> offerings = new HashSet<IOffering>();
            for (Profile profile : profiles) {
                IOffering[] installedOfferings = agent.getInstalledOfferings(profile);
                offerings.addAll(Arrays.asList(installedOfferings));
            }
            return offerings;
        }
        return new HashSet(1);
    }

    private IOfferingOrFix findOfferingOrFix(Agent agent, String id, String version, IProgressMonitor monitor) {
        if (version == null) {
            List aList = agent.findLatestOfferingOrUpdateFix(id, monitor, InstallFixesAction.NONE);
            if (aList.size() > 0) {
                return (IOfferingOrFix)aList.get(0);
            }
        } else {
            try {
                return this.getOfferingOrFix(agent, id, version, false, null);
            }
            catch (HeadlessApplicationException headlessApplicationException) {}
        }
        return null;
    }

    private Set getOfferingsToOpenServiceRepositories(Agent agent, String id, String version, IProgressMonitor monitor) {
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, 3);
        Set installedOfferings = this.getInstalledOfferings(agent, id, spm.next());
        IOfferingOrFix offeringOrFix = this.findOfferingOrFix(agent, id, version, spm.next());
        if (offeringOrFix == null && version != null) {
            offeringOrFix = this.findOfferingOrFix(agent, id, null, spm.next());
        }
        if (offeringOrFix instanceof IOffering) {
            installedOfferings.add(offeringOrFix);
        }
        spm.done();
        return installedOfferings;
    }

    private void openServiceRepositories(Agent agent, IProgressMonitor monitor) {
        if (CmdLine.CL.getResponseFile() != null) {
            return;
        }
        if (CmdLine.CL.isConsoleMode()) {
            return;
        }
        if (!CmdRepositoryUtils.useServiceRepositoryCmd((ACmdLine)CmdLine.CL)) {
            return;
        }
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, 2);
        Set offerings = this.getOfferingsToOpenServiceRepositories(agent, this.offeringOrFixId, this.offeringOrFixVersion, spm.next());
        if (offerings.size() > 0) {
            CicMultiStatus s = SilentRepositoryUtils.openServiceRepositories((boolean)true, (IRepositoryGroup)agent.getRepositoryGroup(), (IOffering[])offerings.toArray(new IOffering[offerings.size()]), (IProgressMonitor)spm.next());
            this.handleOpenServiceRepositoryStatus(agent, (IStatus)s);
        }
        spm.done();
    }

    private IStatus handleOpenServiceRepositoryStatus(Agent agent, IStatus status) {
        if (status.isOK() || status.matches(1)) {
            return status;
        }
        if (!status.matches(2)) {
            status = MultiStatusUtil.recodeLevel((IStatus)status, (int)2);
        }
        OutputFormatter output = agent.getStdoutBuffer();
        StringWriter sWriter = new StringWriter();
        PrintWriter pWriter = new PrintWriter(sWriter);
        CmdUtils.reportNotOKResult((IStatus)status, (PrintWriter)pWriter, (PrintWriter)pWriter);
        output.appendNT(sWriter.toString());
        return status;
    }

    private void prepareOfferingOrFix(IOfferingOrFix offeringOrFix, Agent agent, IProgressMonitor monitor) throws CoreException {
        ArrayList<IOfferingOrFix> offeringsOrFixesToPrepare = new ArrayList<IOfferingOrFix>();
        offeringsOrFixesToPrepare.add(offeringOrFix);
        IStatus preparationStatus = SharedUIUtils.prepareAndResolveOfferingsAndFixes(offeringsOrFixesToPrepare, false, monitor);
        if (StatusUtil.isErrorOrCancel((IStatus)preparationStatus)) {
            throw new CoreException(preparationStatus);
        }
    }

    private LicenseFactory.License[] getLicenses(IOfferingOrFix offeringOrFix) {
        if (offeringOrFix instanceof IOffering && LicenseUtils.isPEKOffering((IOffering)((IOffering)offeringOrFix))) {
            return null;
        }
        return LicenseFactory.getInstance().findLicenseTextFor(offeringOrFix);
    }

    private void printLicenses(LicenseFactory.License[] licenses, OutputFormatter output, Locale currentLocale) throws CoreException {
        if (licenses == null || licenses.length == 0) {
            throw new CoreException((IStatus)Statuses.ERROR.get(4, Messages.Cmd_viewLicense_Error_NoLicenses, new Object[]{this.offeringOrFixId}));
        }
        LicenseFactory.License[] licenseArray = licenses;
        int n = licenses.length;
        int n2 = 0;
        while (n2 < n) {
            LicenseFactory.License license = licenseArray[n2];
            String licenseTextToPrint = null;
            try {
                licenseTextToPrint = license.getLicenseText(currentLocale);
            }
            catch (IOException iOException) {
                ICicStatus status = Statuses.ERROR.get(Messages.Cmd_viewLicense_Error_CannotLoadLicenseText, new Object[0]);
                log.status((IStatus)status);
                licenseTextToPrint = StatusFormatter.toString((IStatus)status);
            }
            if (licenses.length > 1) {
                output.appendNT(license.getGrouping());
                output.appendNT(":");
                output.appendNT(license.getFileFullPathName(currentLocale));
                output.nl();
                output.nl();
            }
            output.appendNT(licenseTextToPrint);
            output.nl();
            output.nl();
            ++n2;
        }
    }
}

